/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.schema.XSBase64Binary;
import org.opensaml.core.xml.schema.XSBoolean;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.schema.XSDateTime;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.XSURI;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AttributeValue;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.saml.security.impl.SAMLMetadataSignatureSigningParametersResolver;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.criterion.SignatureSigningConfigurationCriterion;
import org.opensaml.xmlsec.impl.BasicSignatureSigningConfiguration;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorManager;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureSupport;
import org.opensaml.xmlsec.signature.support.Signer;

public class OpenSamlUtil {
    private static final XMLObjectBuilderFactory _xmlObjectBuilderFactory;

    public static Assertion buildAssertion() {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(Assertion.DEFAULT_ELEMENT_NAME);
        Assertion assertion = (Assertion)samlObjectBuilder.buildObject();
        assertion.setVersion(SAMLVersion.VERSION_20);
        return assertion;
    }

    public static AssertionConsumerService buildAssertionConsumerService(String binding, int index, boolean isDefault, String location) {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        AssertionConsumerService assertionConsumerService = (AssertionConsumerService)samlObjectBuilder.buildObject();
        assertionConsumerService.setBinding(binding);
        assertionConsumerService.setIndex(Integer.valueOf(index));
        assertionConsumerService.setIsDefault(Boolean.valueOf(isDefault));
        assertionConsumerService.setLocation(location);
        return assertionConsumerService;
    }

    public static Attribute buildAttribute() {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(Attribute.DEFAULT_ELEMENT_NAME);
        return (Attribute)samlObjectBuilder.buildObject();
    }

    public static Attribute buildAttribute(String name, Serializable value) {
        return OpenSamlUtil.buildAttribute(name, "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified", value);
    }

    public static Attribute buildAttribute(String name, String nameFormat, Serializable value) {
        return OpenSamlUtil.buildAttribute(name, null, nameFormat, value);
    }

    public static Attribute buildAttribute(String name, String friendlyName, String nameFormat) {
        Attribute attribute = OpenSamlUtil.buildAttribute();
        if (Validator.isNotNull((String)friendlyName)) {
            attribute.setFriendlyName(friendlyName);
        }
        attribute.setName(name);
        attribute.setNameFormat(nameFormat);
        return attribute;
    }

    public static Attribute buildAttribute(String name, String friendlyName, String nameFormat, Boolean value) {
        Attribute attribute = OpenSamlUtil.buildAttribute(name, friendlyName, nameFormat);
        List xmlObjects = attribute.getAttributeValues();
        XMLObject xmlObject = OpenSamlUtil.buildAttributeValue(value);
        xmlObjects.add(xmlObject);
        return attribute;
    }

    public static Attribute buildAttribute(String name, String friendlyName, String nameFormat, boolean[] values) {
        Attribute attribute = OpenSamlUtil.buildAttribute();
        if (Validator.isNotNull((String)friendlyName)) {
            attribute.setFriendlyName(friendlyName);
        }
        attribute.setName(name);
        attribute.setNameFormat(nameFormat);
        List xmlObjects = attribute.getAttributeValues();
        for (boolean value : values) {
            XMLObject xmlObject = OpenSamlUtil.buildAttributeValue(value);
            xmlObjects.add(xmlObject);
        }
        return attribute;
    }

    public static Attribute buildAttribute(String name, String friendlyName, String nameFormat, Date value) {
        DateTime dateTime = new DateTime(value);
        dateTime = dateTime.withZone(DateTimeZone.UTC);
        return OpenSamlUtil.buildAttribute(name, friendlyName, nameFormat, dateTime);
    }

    public static Attribute buildAttribute(String name, String friendlyName, String nameFormat, Date[] values) {
        DateTime[] dateTimeValues = new DateTime[values.length];
        for (int i = 0; i < values.length; ++i) {
            DateTime dateTime = new DateTime(values[i]);
            dateTimeValues[i] = dateTime = dateTime.withZone(DateTimeZone.UTC);
        }
        return OpenSamlUtil.buildAttribute(name, friendlyName, nameFormat, dateTimeValues);
    }

    public static Attribute buildAttribute(String name, String friendlyName, String nameFormat, DateTime value) {
        Attribute attribute = OpenSamlUtil.buildAttribute();
        if (Validator.isNotNull((String)friendlyName)) {
            attribute.setFriendlyName(friendlyName);
        }
        attribute.setName(name);
        attribute.setNameFormat(nameFormat);
        XMLObject xmlObject = OpenSamlUtil.buildAttributeValue(value);
        List xmlObjects = attribute.getAttributeValues();
        xmlObjects.add(xmlObject);
        return attribute;
    }

    public static Attribute buildAttribute(String name, String friendlyName, String nameFormat, DateTime[] values) {
        Attribute attribute = OpenSamlUtil.buildAttribute();
        if (Validator.isNotNull((String)friendlyName)) {
            attribute.setFriendlyName(friendlyName);
        }
        attribute.setName(name);
        attribute.setNameFormat(nameFormat);
        List xmlObjects = attribute.getAttributeValues();
        for (DateTime value : values) {
            XMLObject xmlObject = OpenSamlUtil.buildAttributeValue(value);
            xmlObjects.add(xmlObject);
        }
        return attribute;
    }

    public static Attribute buildAttribute(String name, String friendlyName, String nameFormat, int[] values) {
        Attribute attribute = OpenSamlUtil.buildAttribute();
        if (Validator.isNotNull((String)friendlyName)) {
            attribute.setFriendlyName(friendlyName);
        }
        attribute.setName(name);
        attribute.setNameFormat(nameFormat);
        List xmlObjects = attribute.getAttributeValues();
        for (int value : values) {
            XMLObject xmlObject = OpenSamlUtil.buildAttributeValue(value);
            xmlObjects.add(xmlObject);
        }
        return attribute;
    }

    public static Attribute buildAttribute(String name, String friendlyName, String nameFormat, Serializable value) {
        if (value instanceof Boolean) {
            return OpenSamlUtil.buildAttribute(name, friendlyName, nameFormat, (Boolean)value);
        }
        if (value instanceof boolean[]) {
            return OpenSamlUtil.buildAttribute(name, friendlyName, nameFormat, (boolean[])value);
        }
        if (value instanceof Date) {
            return OpenSamlUtil.buildAttribute(name, friendlyName, nameFormat, (Date)value);
        }
        if (value instanceof Date) {
            return OpenSamlUtil.buildAttribute(name, friendlyName, nameFormat, (Date[])value);
        }
        if (value instanceof double[]) {
            double[] values = (double[])value;
            return OpenSamlUtil.buildAttribute(name, friendlyName, nameFormat, ArrayUtil.toStringArray((double[])values));
        }
        if (value instanceof float[]) {
            float[] values = (float[])value;
            return OpenSamlUtil.buildAttribute(name, friendlyName, nameFormat, ArrayUtil.toStringArray((float[])values));
        }
        if (value instanceof int[]) {
            return OpenSamlUtil.buildAttribute(name, friendlyName, nameFormat, (int[])value);
        }
        if (value instanceof long[]) {
            long[] values = (long[])value;
            return OpenSamlUtil.buildAttribute(name, friendlyName, nameFormat, ArrayUtil.toStringArray((long[])values));
        }
        if (value instanceof Number[]) {
            Object[] values = (Number[])value;
            return OpenSamlUtil.buildAttribute(name, friendlyName, nameFormat, ArrayUtil.toStringArray((Object[])values));
        }
        if (value instanceof short[]) {
            short[] values = (short[])value;
            return OpenSamlUtil.buildAttribute(name, friendlyName, nameFormat, ArrayUtil.toStringArray((short[])values));
        }
        if (value instanceof String[]) {
            return OpenSamlUtil.buildAttribute(name, friendlyName, nameFormat, (String[])value);
        }
        return OpenSamlUtil.buildAttribute(name, friendlyName, nameFormat, String.valueOf(value));
    }

    public static Attribute buildAttribute(String name, String friendlyName, String nameFormat, String value) {
        Attribute attribute = OpenSamlUtil.buildAttribute();
        if (Validator.isNotNull((String)friendlyName)) {
            attribute.setFriendlyName(friendlyName);
        }
        attribute.setName(name);
        attribute.setNameFormat(nameFormat);
        XMLObject xmlObject = OpenSamlUtil.buildAttributeValue(value);
        List xmlObjects = attribute.getAttributeValues();
        xmlObjects.add(xmlObject);
        return attribute;
    }

    public static Attribute buildAttribute(String name, String friendlyName, String nameFormat, String[] values) {
        Attribute attribute = OpenSamlUtil.buildAttribute();
        if (Validator.isNotNull((String)friendlyName)) {
            attribute.setFriendlyName(friendlyName);
        }
        attribute.setName(name);
        attribute.setNameFormat(nameFormat);
        List xmlObjects = attribute.getAttributeValues();
        for (String value : values) {
            XMLObject xmlObject = OpenSamlUtil.buildAttributeValue(value);
            xmlObjects.add(xmlObject);
        }
        return attribute;
    }

    public static XMLObject buildAttributeBase64Value(String value) {
        XMLObjectBuilder xmlObjectBuilder = OpenSamlUtil._getBuilder(XSBase64Binary.TYPE_NAME);
        XSBase64Binary xsBase64Binary = (XSBase64Binary)xmlObjectBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSBase64Binary.TYPE_NAME);
        xsBase64Binary.setValue(value);
        return xsBase64Binary;
    }

    public static AttributeStatement buildAttributeStatement() {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(AttributeStatement.DEFAULT_ELEMENT_NAME);
        return (AttributeStatement)samlObjectBuilder.buildObject();
    }

    public static XMLObject buildAttributeValue(Boolean value) {
        XMLObjectBuilder xmlObjectBuilder = OpenSamlUtil._getBuilder(XSBoolean.TYPE_NAME);
        XSBoolean xsBoolean = (XSBoolean)xmlObjectBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSBoolean.TYPE_NAME);
        XSBooleanValue xsBooleanValue = new XSBooleanValue(value, false);
        xsBoolean.setValue(xsBooleanValue);
        return xsBoolean;
    }

    public static XMLObject buildAttributeValue(DateTime value) {
        XMLObjectBuilder xmlObjectBuilder = OpenSamlUtil._getBuilder(XSDateTime.TYPE_NAME);
        XSDateTime xsDateTime = (XSDateTime)xmlObjectBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSDateTime.TYPE_NAME);
        xsDateTime.setValue(value);
        return xsDateTime;
    }

    public static XMLObject buildAttributeValue(Integer value) {
        XMLObjectBuilder xmlObjectBuilder = OpenSamlUtil._getBuilder(XSInteger.TYPE_NAME);
        XSInteger xsInteger = (XSInteger)xmlObjectBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSInteger.TYPE_NAME);
        xsInteger.setValue(value);
        return xsInteger;
    }

    public static XMLObject buildAttributeValue(String value) {
        XMLObjectBuilder xmlObjectBuilder = OpenSamlUtil._getBuilder(XSString.TYPE_NAME);
        XSString xsString = (XSString)xmlObjectBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
        xsString.setValue(value);
        return xsString;
    }

    public static XMLObject buildAttributeValue(URI value) {
        XMLObjectBuilder xmlObjectBuilder = OpenSamlUtil._getBuilder(XSURI.TYPE_NAME);
        XSURI xsBase64Binary = (XSURI)xmlObjectBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSURI.TYPE_NAME);
        xsBase64Binary.setValue(value.toString());
        return xsBase64Binary;
    }

    public static Audience buildAudience() {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(Audience.DEFAULT_ELEMENT_NAME);
        return (Audience)samlObjectBuilder.buildObject();
    }

    public static AudienceRestriction buildAudienceRestriction() {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(AudienceRestriction.DEFAULT_ELEMENT_NAME);
        return (AudienceRestriction)samlObjectBuilder.buildObject();
    }

    public static AuthnContext buildAuthnContext() {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(AuthnContext.DEFAULT_ELEMENT_NAME);
        return (AuthnContext)samlObjectBuilder.buildObject();
    }

    public static AuthnContextClassRef buildAuthnContextClassRef() {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
        return (AuthnContextClassRef)samlObjectBuilder.buildObject();
    }

    public static AuthnRequest buildAuthnRequest(String spEntityId, AssertionConsumerService assertionConsumerService, SingleSignOnService singleSignOnService, NameIDPolicy nameIDPolicy) {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(AuthnRequest.DEFAULT_ELEMENT_NAME);
        AuthnRequest authnRequest = (AuthnRequest)samlObjectBuilder.buildObject();
        DateTime now = new DateTime(DateTimeZone.UTC);
        authnRequest.setForceAuthn(Boolean.valueOf(false));
        authnRequest.setIsPassive(Boolean.valueOf(false));
        authnRequest.setIssueInstant(now);
        Issuer issuer = OpenSamlUtil.buildIssuer(spEntityId);
        authnRequest.setIssuer(issuer);
        authnRequest.setAssertionConsumerServiceURL(assertionConsumerService.getLocation());
        authnRequest.setDestination(singleSignOnService.getLocation());
        authnRequest.setNameIDPolicy(nameIDPolicy);
        authnRequest.setProtocolBinding(assertionConsumerService.getBinding());
        authnRequest.setVersion(SAMLVersion.VERSION_20);
        return authnRequest;
    }

    public static AuthnStatement buildAuthnStatement() {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(AuthnStatement.DEFAULT_ELEMENT_NAME);
        return (AuthnStatement)samlObjectBuilder.buildObject();
    }

    public static Conditions buildConditions() {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(Conditions.DEFAULT_ELEMENT_NAME);
        return (Conditions)samlObjectBuilder.buildObject();
    }

    public static EntityDescriptor buildEntityDescriptor() {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        return (EntityDescriptor)samlObjectBuilder.buildObject();
    }

    public static IDPSSODescriptor buildIdpSsoDescriptor() {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        return (IDPSSODescriptor)samlObjectBuilder.buildObject();
    }

    public static Issuer buildIssuer(String value) {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)samlObjectBuilder.buildObject();
        issuer.setValue(value);
        return issuer;
    }

    public static KeyDescriptor buildKeyDescriptor(UsageType useType, KeyInfo keyInfo) {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(KeyDescriptor.DEFAULT_ELEMENT_NAME);
        KeyDescriptor keyDescriptor = (KeyDescriptor)samlObjectBuilder.buildObject();
        keyDescriptor.setKeyInfo(keyInfo);
        keyDescriptor.setUse(useType);
        return keyDescriptor;
    }

    public static KeyInfo buildKeyInfo(Credential credential) throws SecurityException {
        EncryptionConfiguration globalEncryptionConfiguration = SecurityConfigurationSupport.getGlobalEncryptionConfiguration();
        NamedKeyInfoGeneratorManager namedKeyInfoGeneratorManager = globalEncryptionConfiguration.getDataKeyInfoGeneratorManager();
        KeyInfoGeneratorManager keyInfoGeneratorManager = namedKeyInfoGeneratorManager.getDefaultManager();
        KeyInfoGeneratorFactory keyInfoGeneratorFactory = keyInfoGeneratorManager.getFactory(credential);
        KeyInfoGenerator keyInfoGenerator = keyInfoGeneratorFactory.newInstance();
        return keyInfoGenerator.generate(credential);
    }

    public static LogoutRequest buildLogoutRequest() {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(LogoutRequest.DEFAULT_ELEMENT_NAME);
        return (LogoutRequest)samlObjectBuilder.buildObject();
    }

    public static LogoutResponse buildLogoutResponse() {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(LogoutResponse.DEFAULT_ELEMENT_NAME);
        return (LogoutResponse)samlObjectBuilder.buildObject();
    }

    public static NameID buildNameId(String nameIdFormat, String nameIdValue) {
        return OpenSamlUtil.buildNameId(nameIdFormat, null, null, nameIdValue);
    }

    public static NameID buildNameId(String nameIdFormat, String nameIdNameQualifier, String nameIdSPNameQualifier, String nameIdValue) {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(NameID.DEFAULT_ELEMENT_NAME);
        NameID nameID = (NameID)samlObjectBuilder.buildObject();
        nameID.setFormat(nameIdFormat);
        nameID.setValue(nameIdValue);
        if (Validator.isNotNull((String)nameIdNameQualifier)) {
            nameID.setNameQualifier(nameIdNameQualifier);
        }
        if (Validator.isNotNull((String)nameIdSPNameQualifier)) {
            nameID.setSPNameQualifier(nameIdSPNameQualifier);
        }
        return nameID;
    }

    public static NameIDPolicy buildNameIdPolicy() {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(NameIDPolicy.DEFAULT_ELEMENT_NAME);
        return (NameIDPolicy)samlObjectBuilder.buildObject();
    }

    public static Response buildResponse() {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(Response.DEFAULT_ELEMENT_NAME);
        Response response = (Response)samlObjectBuilder.buildObject();
        response.setVersion(SAMLVersion.VERSION_20);
        return response;
    }

    public static SessionIndex buildSessionIndex(String sessionIndexString) {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(SessionIndex.DEFAULT_ELEMENT_NAME);
        SessionIndex sessionIndex = (SessionIndex)samlObjectBuilder.buildObject();
        sessionIndex.setSessionIndex(sessionIndexString);
        return sessionIndex;
    }

    public static Signature buildSignature(Credential credential) {
        XMLObjectBuilder samlObjectBuilder = OpenSamlUtil._getBuilder(Signature.DEFAULT_ELEMENT_NAME);
        Signature signature = (Signature)samlObjectBuilder.buildObject(Signature.DEFAULT_ELEMENT_NAME);
        signature.setSigningCredential(credential);
        return signature;
    }

    public static SingleLogoutService buildSingleLogoutService(String binding, String location) {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(SingleLogoutService.DEFAULT_ELEMENT_NAME);
        SingleLogoutService singleLogoutService = (SingleLogoutService)samlObjectBuilder.buildObject();
        singleLogoutService.setBinding(binding);
        singleLogoutService.setLocation(location);
        return singleLogoutService;
    }

    public static SingleSignOnService buildSingleSignOnService(String binding, String location) {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(SingleSignOnService.DEFAULT_ELEMENT_NAME);
        SingleSignOnService singleSignOnService = (SingleSignOnService)samlObjectBuilder.buildObject();
        singleSignOnService.setBinding(binding);
        singleSignOnService.setLocation(location);
        return singleSignOnService;
    }

    public static SPSSODescriptor buildSpSsoDescriptor() {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        return (SPSSODescriptor)samlObjectBuilder.buildObject();
    }

    public static Status buildStatus(StatusCode statusCode) {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(Status.DEFAULT_ELEMENT_NAME);
        Status status = (Status)samlObjectBuilder.buildObject();
        status.setStatusCode(statusCode);
        return status;
    }

    public static StatusCode buildStatusCode(String value) {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(StatusCode.DEFAULT_ELEMENT_NAME);
        StatusCode statusCode = (StatusCode)samlObjectBuilder.buildObject();
        statusCode.setValue(value);
        return statusCode;
    }

    public static Subject buildSubject(NameID nameID) {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(Subject.DEFAULT_ELEMENT_NAME);
        Subject subject = (Subject)samlObjectBuilder.buildObject();
        subject.setNameID(nameID);
        return subject;
    }

    public static SubjectConfirmation buildSubjectConfirmation() {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        return (SubjectConfirmation)samlObjectBuilder.buildObject();
    }

    public static SubjectConfirmationData buildSubjectConfirmationData() {
        SAMLObjectBuilder samlObjectBuilder = (SAMLObjectBuilder)OpenSamlUtil._getBuilder(SubjectConfirmationData.DEFAULT_ELEMENT_NAME);
        return (SubjectConfirmationData)samlObjectBuilder.buildObject();
    }

    public static String marshall(XMLObject xmlObject) throws MarshallingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLObjectSupport.marshallToOutputStream((XMLObject)xmlObject, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toString();
    }

    public static void prepareSecurityParametersContext(Credential credential, SecurityParametersContext securityParametersContext, RoleDescriptor peerRoleDescriptor) throws PortalException {
        try {
            SignatureSigningParameters signatureSigningParameters = OpenSamlUtil._getSignatureSigningParameters(credential, peerRoleDescriptor);
            securityParametersContext.setSignatureSigningParameters(signatureSigningParameters);
            signatureSigningParameters.setSigningCredential(credential);
        }
        catch (ResolverException re) {
            throw new PortalException((Throwable)re);
        }
    }

    public static void signObject(SignableSAMLObject signableObject, Credential credential, RoleDescriptor peerRoleDescriptor) throws MarshallingException, SecurityException, SignatureException {
        Signature signature = OpenSamlUtil.buildSignature(credential);
        try {
            SignatureSigningParameters signatureSigningParameters = OpenSamlUtil._getSignatureSigningParameters(credential, peerRoleDescriptor);
            SignatureSupport.prepareSignatureParams((Signature)signature, (SignatureSigningParameters)signatureSigningParameters);
            signableObject.setSignature(signature);
            XMLObjectProviderRegistry xmlObjectProviderRegistry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
            MarshallerFactory marshallerFactory = xmlObjectProviderRegistry.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)signableObject);
            marshaller.marshall((XMLObject)signableObject);
            Signer.signObject((Signature)signature);
        }
        catch (ResolverException re) {
            throw new SignatureException((Exception)re);
        }
    }

    public static XMLObject unmarshall(String xml) throws UnmarshallingException, XMLParserException {
        XMLObjectProviderRegistry xmlObjectProviderRegistry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
        return XMLObjectSupport.unmarshallFromInputStream((ParserPool)xmlObjectProviderRegistry.getParserPool(), (InputStream)new ByteArrayInputStream(xml.getBytes()));
    }

    private static XMLObjectBuilder _getBuilder(QName qName) {
        return _xmlObjectBuilderFactory.getBuilder(qName);
    }

    private static SignatureSigningParameters _getSignatureSigningParameters(Credential credential, RoleDescriptor peerRoleDescriptor) throws ResolverException {
        SAMLMetadataSignatureSigningParametersResolver samlMetadataSignatureSigningParametersResolver = new SAMLMetadataSignatureSigningParametersResolver();
        SignatureSigningConfiguration globalSignatureSigningConfiguration = SecurityConfigurationSupport.getGlobalSignatureSigningConfiguration();
        if (globalSignatureSigningConfiguration instanceof BasicSignatureSigningConfiguration) {
            BasicSignatureSigningConfiguration signatureSigningConfiguration = (BasicSignatureSigningConfiguration)globalSignatureSigningConfiguration;
            signatureSigningConfiguration.setSigningCredentials(Collections.singletonList(credential));
        }
        SignatureSigningConfigurationCriterion signatureSigningConfigurationCriterion = new SignatureSigningConfigurationCriterion(new SignatureSigningConfiguration[]{globalSignatureSigningConfiguration});
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{signatureSigningConfigurationCriterion});
        if (peerRoleDescriptor != null) {
            criteriaSet.add(new RoleDescriptorCriterion(peerRoleDescriptor));
        }
        return samlMetadataSignatureSigningParametersResolver.resolveSingle(criteriaSet);
    }

    static {
        XMLObjectProviderRegistry xmlObjectProviderRegistry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
        _xmlObjectBuilderFactory = xmlObjectProviderRegistry.getBuilderFactory();
    }
}

