/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.resolver;

import com.liferay.saml.opensaml.integration.internal.util.OpenSamlUtil;
import com.liferay.saml.opensaml.integration.resolver.AttributeResolver;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Attribute;

public class AttributePublisherImpl
implements AttributeResolver.AttributePublisher {
    private final List<Attribute> _attributes = new ArrayList<Attribute>();

    @Override
    public AttributeResolver.AttributePublisher.AttributeValue buildBase64(String value) {
        return new AttributeValueWrapper(OpenSamlUtil.buildAttributeBase64Value(value));
    }

    @Override
    public AttributeResolver.AttributePublisher.AttributeValue buildBoolean(boolean value) {
        return new AttributeValueWrapper(OpenSamlUtil.buildAttributeValue(value));
    }

    @Override
    public AttributeResolver.AttributePublisher.AttributeValue buildDateTime(Date value) {
        return new AttributeValueWrapper(OpenSamlUtil.buildAttributeValue(new DateTime(value)));
    }

    @Override
    public AttributeResolver.AttributePublisher.AttributeValue buildInt(int value) {
        return new AttributeValueWrapper(OpenSamlUtil.buildAttributeValue(value));
    }

    @Override
    public AttributeResolver.AttributePublisher.AttributeValue buildString(String value) {
        return new AttributeValueWrapper(OpenSamlUtil.buildAttributeValue(value));
    }

    @Override
    public AttributeResolver.AttributePublisher.AttributeValue buildURI(URI value) {
        return new AttributeValueWrapper(OpenSamlUtil.buildAttributeValue(value));
    }

    public List<Attribute> getAttributes() {
        return this._attributes;
    }

    @Override
    public void publish(String name, AttributeResolver.AttributePublisher.AttributeValue ... attributeValues) {
        this.publish(name, (String)null, attributeValues);
    }

    @Override
    public void publish(String name, String nameFormat, AttributeResolver.AttributePublisher.AttributeValue ... attributeValues) {
        this.publish(name, null, nameFormat, attributeValues);
    }

    @Override
    public void publish(String name, String friendlyName, String nameFormat, AttributeResolver.AttributePublisher.AttributeValue ... attributeValues) {
        Attribute attribute = OpenSamlUtil.buildAttribute(name, friendlyName, nameFormat);
        List attributeXmlObjects = attribute.getAttributeValues();
        Stream<AttributeResolver.AttributePublisher.AttributeValue> stream = Arrays.stream(attributeValues);
        attributeXmlObjects.addAll(stream.map(AttributeValueWrapper.class::cast).map(AttributeValueWrapper::getXmlObject).collect(Collectors.toList()));
        this._attributes.add(attribute);
    }

    private static class AttributeValueWrapper
    implements AttributeResolver.AttributePublisher.AttributeValue {
        private final XMLObject _xmlObject;

        public AttributeValueWrapper(XMLObject xmlObject) {
            this._xmlObject = xmlObject;
        }

        public XMLObject getXmlObject() {
            return this._xmlObject;
        }
    }
}

