/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.metadata;

import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.opensaml.integration.internal.util.OpenSamlUtil;
import com.liferay.saml.runtime.exception.CredentialException;
import com.liferay.saml.runtime.exception.EntityIdException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.ext.saml2alg.DigestMethod;
import org.opensaml.saml.ext.saml2alg.SigningMethod;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.EncryptionMethod;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.algorithm.AlgorithmDescriptor;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.algorithm.KeyLengthSpecifiedAlgorithm;
import org.opensaml.xmlsec.encryption.KeySize;
import org.opensaml.xmlsec.encryption.impl.KeySizeBuilder;

public class MetadataGeneratorUtil {
    public static EntityDescriptor buildIdpEntityDescriptor(String portalURL, String entityId, boolean wantAuthnRequestSigned, boolean signMetadata, Credential credential, Credential encryptionCredential) throws Exception {
        if (Validator.isNull((String)entityId)) {
            throw new EntityIdException("Entity ID is required");
        }
        if (credential == null) {
            throw new CredentialException("Credential is required");
        }
        EntityDescriptor entityDescriptor = OpenSamlUtil.buildEntityDescriptor();
        entityDescriptor.setEntityID(entityId);
        List roleDescriptors = entityDescriptor.getRoleDescriptors();
        IDPSSODescriptor roleDescriptor = MetadataGeneratorUtil.buildIdpSsoDescriptor(portalURL, entityId, wantAuthnRequestSigned, credential, encryptionCredential);
        Extensions extensions = (Extensions)XMLObjectSupport.buildXMLObject((QName)Extensions.DEFAULT_ELEMENT_NAME);
        List unknownXMLObjects = extensions.getUnknownXMLObjects();
        unknownXMLObjects.addAll(MetadataGeneratorUtil._getExtensionXmlObjects(credential));
        roleDescriptor.setExtensions(extensions);
        roleDescriptors.add(roleDescriptor);
        if (signMetadata) {
            OpenSamlUtil.signObject((SignableSAMLObject)entityDescriptor, credential, null);
        }
        return entityDescriptor;
    }

    public static IDPSSODescriptor buildIdpSsoDescriptor(String portalURL, String entityId, boolean wantAuthnRequestSigned, Credential credential, Credential encryptionCredential) throws Exception {
        IDPSSODescriptor idpSSODescriptor = OpenSamlUtil.buildIdpSsoDescriptor();
        idpSSODescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        idpSSODescriptor.setWantAuthnRequestsSigned(Boolean.valueOf(wantAuthnRequestSigned));
        List keyDescriptors = idpSSODescriptor.getKeyDescriptors();
        KeyDescriptor keyDescriptor = OpenSamlUtil.buildKeyDescriptor(UsageType.SIGNING, OpenSamlUtil.buildKeyInfo(credential));
        keyDescriptors.add(keyDescriptor);
        if (encryptionCredential != null) {
            keyDescriptors.add(MetadataGeneratorUtil.getEncryptionKeyDescriptor(encryptionCredential));
        }
        List singleSignOnServices = idpSSODescriptor.getSingleSignOnServices();
        String pathMain = PortalUtil.getPathMain();
        SingleSignOnService singleSignOnService = OpenSamlUtil.buildSingleSignOnService("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", portalURL.concat(pathMain).concat("/portal/saml/sso"));
        singleSignOnServices.add(singleSignOnService);
        singleSignOnService = OpenSamlUtil.buildSingleSignOnService("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", portalURL.concat(pathMain).concat("/portal/saml/sso"));
        singleSignOnServices.add(singleSignOnService);
        List singleLogoutServices = idpSSODescriptor.getSingleLogoutServices();
        SingleLogoutService postSingleLogoutService = OpenSamlUtil.buildSingleLogoutService("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", portalURL.concat(pathMain).concat("/portal/saml/slo"));
        singleLogoutServices.add(postSingleLogoutService);
        SingleLogoutService redirectSingleLogoutService = OpenSamlUtil.buildSingleLogoutService("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", portalURL.concat(pathMain).concat("/portal/saml/slo"));
        singleLogoutServices.add(redirectSingleLogoutService);
        return idpSSODescriptor;
    }

    public static EntityDescriptor buildSpEntityDescriptor(String portalURL, String entityId, boolean signAuthnRequests, boolean signMetadata, boolean wantAssertionsSigned, Credential credential, Credential encryptionCredential) throws Exception {
        EntityDescriptor entityDescriptor = OpenSamlUtil.buildEntityDescriptor();
        entityDescriptor.setEntityID(entityId);
        List roleDescriptors = entityDescriptor.getRoleDescriptors();
        SPSSODescriptor roleDescriptor = MetadataGeneratorUtil.buildSpSsoDescriptor(portalURL, entityId, signAuthnRequests, wantAssertionsSigned, credential, encryptionCredential);
        Extensions extensions = (Extensions)XMLObjectSupport.buildXMLObject((QName)Extensions.DEFAULT_ELEMENT_NAME);
        List unknownXMLObjects = extensions.getUnknownXMLObjects();
        unknownXMLObjects.addAll(MetadataGeneratorUtil._getExtensionXmlObjects(credential));
        roleDescriptor.setExtensions(extensions);
        roleDescriptors.add(roleDescriptor);
        if (signMetadata) {
            OpenSamlUtil.signObject((SignableSAMLObject)entityDescriptor, credential, null);
        }
        return entityDescriptor;
    }

    public static SPSSODescriptor buildSpSsoDescriptor(String portalURL, String entityId, boolean signAuthnRequests, boolean wantAssertionsSigned, Credential credential, Credential encryptionCredential) throws Exception {
        SPSSODescriptor spSSODescriptor = OpenSamlUtil.buildSpSsoDescriptor();
        spSSODescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        spSSODescriptor.setAuthnRequestsSigned(Boolean.valueOf(signAuthnRequests));
        spSSODescriptor.setWantAssertionsSigned(Boolean.valueOf(wantAssertionsSigned));
        List assertionConsumerServices = spSSODescriptor.getAssertionConsumerServices();
        String pathMain = PortalUtil.getPathMain();
        AssertionConsumerService assertionConsumerService = OpenSamlUtil.buildAssertionConsumerService("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 1, true, portalURL.concat(pathMain).concat("/portal/saml/acs"));
        assertionConsumerServices.add(assertionConsumerService);
        List keyDescriptors = spSSODescriptor.getKeyDescriptors();
        KeyDescriptor keyDescriptor = OpenSamlUtil.buildKeyDescriptor(UsageType.SIGNING, OpenSamlUtil.buildKeyInfo(credential));
        keyDescriptors.add(keyDescriptor);
        if (encryptionCredential != null) {
            keyDescriptors.add(MetadataGeneratorUtil.getEncryptionKeyDescriptor(encryptionCredential));
        }
        List singleLogoutServices = spSSODescriptor.getSingleLogoutServices();
        SingleLogoutService postSingleLogoutService = OpenSamlUtil.buildSingleLogoutService("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", portalURL.concat(pathMain).concat("/portal/saml/slo"));
        singleLogoutServices.add(postSingleLogoutService);
        SingleLogoutService redirectSingleLogoutService = OpenSamlUtil.buildSingleLogoutService("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", portalURL.concat(pathMain).concat("/portal/saml/slo"));
        singleLogoutServices.add(redirectSingleLogoutService);
        SingleLogoutService soapSingleLogoutService = OpenSamlUtil.buildSingleLogoutService("urn:oasis:names:tc:SAML:2.0:bindings:SOAP", portalURL.concat(pathMain).concat("/portal/saml/slo_soap"));
        singleLogoutServices.add(soapSingleLogoutService);
        return spSSODescriptor;
    }

    public static KeyDescriptor getEncryptionKeyDescriptor(Credential credential) throws SecurityException {
        KeyDescriptor encryptionKeyDescriptor = OpenSamlUtil.buildKeyDescriptor(UsageType.ENCRYPTION, OpenSamlUtil.buildKeyInfo(credential));
        List encryptionMethods = encryptionKeyDescriptor.getEncryptionMethods();
        ArrayList algorithms = new ArrayList();
        EncryptionConfiguration encryptionConfiguration = (EncryptionConfiguration)ConfigurationService.get(EncryptionConfiguration.class);
        algorithms.addAll(encryptionConfiguration.getDataEncryptionAlgorithms());
        algorithms.addAll(encryptionConfiguration.getKeyTransportEncryptionAlgorithms());
        for (String algorithm : algorithms) {
            AlgorithmDescriptor algorithmDescriptor;
            AlgorithmRegistry algorithmRegistry = AlgorithmSupport.getGlobalAlgorithmRegistry();
            Collection blacklistedAlgorithms = encryptionConfiguration.getBlacklistedAlgorithms();
            if (!algorithmRegistry.isRuntimeSupported(algorithm) || blacklistedAlgorithms.contains(algorithm) || AlgorithmSupport.isKeyEncryptionAlgorithm((AlgorithmDescriptor)(algorithmDescriptor = algorithmRegistry.get(algorithm))) && !AlgorithmSupport.credentialSupportsAlgorithmForEncryption((Credential)credential, (AlgorithmDescriptor)algorithmDescriptor)) continue;
            EncryptionMethod encryptionMethod = (EncryptionMethod)XMLObjectSupport.buildXMLObject((QName)EncryptionMethod.DEFAULT_ELEMENT_NAME);
            encryptionMethod.setAlgorithm(algorithmDescriptor.getURI());
            if (encryptionMethod instanceof KeyLengthSpecifiedAlgorithm) {
                KeyLengthSpecifiedAlgorithm keySpecifiedAlgorithm = (KeyLengthSpecifiedAlgorithm)encryptionMethod;
                KeySizeBuilder keySizeBuilder = new KeySizeBuilder();
                KeySize keySize = keySizeBuilder.buildObject();
                keySize.setValue(keySpecifiedAlgorithm.getKeyLength());
                encryptionMethod.setKeySize(keySize);
            }
            encryptionMethods.add(encryptionMethod);
        }
        return encryptionKeyDescriptor;
    }

    private static List<XMLObject> _getExtensionXmlObjects(Credential credential) {
        AlgorithmDescriptor algorithmDescriptor;
        ArrayList<XMLObject> xmlObjects = new ArrayList<XMLObject>();
        AlgorithmRegistry algorithmRegistry = AlgorithmSupport.getGlobalAlgorithmRegistry();
        SignatureSigningConfiguration signatureSigningConfiguration = (SignatureSigningConfiguration)ConfigurationService.get(SignatureSigningConfiguration.class);
        Collection blacklistedAlgorithms = signatureSigningConfiguration.getBlacklistedAlgorithms();
        for (String digestMethodString : signatureSigningConfiguration.getSignatureReferenceDigestMethods()) {
            if (!algorithmRegistry.isRuntimeSupported(digestMethodString) || blacklistedAlgorithms.contains(digestMethodString)) continue;
            algorithmDescriptor = algorithmRegistry.get(digestMethodString);
            DigestMethod digestMethod = (DigestMethod)XMLObjectSupport.buildXMLObject((QName)DigestMethod.DEFAULT_ELEMENT_NAME);
            digestMethod.setAlgorithm(algorithmDescriptor.getURI());
            xmlObjects.add((XMLObject)digestMethod);
        }
        for (String signatureAlgorithms : signatureSigningConfiguration.getSignatureAlgorithms()) {
            if (!algorithmRegistry.isRuntimeSupported(signatureAlgorithms) || blacklistedAlgorithms.contains(signatureAlgorithms) || !AlgorithmSupport.credentialSupportsAlgorithmForSigning((Credential)credential, (AlgorithmDescriptor)(algorithmDescriptor = algorithmRegistry.get(signatureAlgorithms)))) continue;
            SigningMethod signingMethod = (SigningMethod)XMLObjectSupport.buildXMLObject((QName)SigningMethod.DEFAULT_ELEMENT_NAME);
            signingMethod.setAlgorithm(algorithmDescriptor.getURI());
            xmlObjects.add((XMLObject)signingMethod);
        }
        return xmlObjects;
    }
}

