/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.bootstrap;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.opensaml.xmlsec.signature.support.Signer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true, service={OpenSamlBootstrap.class})
public class OpenSamlBootstrap {
    private ServiceRegistration<ParserPool> _parserPoolServiceRegistration;

    public static synchronized void bootstrap() throws IllegalAccessException, InitializationException, InvocationTargetException, NoSuchMethodException {
        InitializationService.initialize();
        OpenSamlBootstrap.initializeParserPool();
        Method method = Signer.class.getDeclaredMethod("getSignerProvider", new Class[0]);
        method.setAccessible(true);
        method.invoke(null, new Object[0]);
        method = SignatureValidator.class.getDeclaredMethod("getSignatureValidationProvider", new Class[0]);
        method.setAccessible(true);
        method.invoke(null, new Object[0]);
        if (XMLSecurityConstants.xmlOutputFactory == null) {
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    public synchronized void activate(BundleContext bundleContext) throws IllegalAccessException, InitializationException, InvocationTargetException, NoSuchMethodException {
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        try {
            Bundle bundle = bundleContext.getBundle();
            BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            currentThread.setContextClassLoader(bundleWiring.getClassLoader());
            OpenSamlBootstrap.bootstrap();
            XMLObjectProviderRegistry xmlObjectProviderRegistry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
            this._parserPoolServiceRegistration = bundleContext.registerService(ParserPool.class, (Object)xmlObjectProviderRegistry.getParserPool(), null);
        }
        finally {
            currentThread.setContextClassLoader(classLoader);
        }
    }

    protected static void initializeParserPool() throws InitializationException {
        BasicParserPool parserPool = new BasicParserPool();
        HashMap<String, Boolean> builderFeatures = new HashMap<String, Boolean>();
        builderFeatures.put("http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
        builderFeatures.put("http://apache.org/xml/features/dom/defer-node-expansion", Boolean.FALSE);
        builderFeatures.put("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        builderFeatures.put("http://xml.org/sax/features/external-general-entities", Boolean.FALSE);
        builderFeatures.put("http://xml.org/sax/features/external-parameter-entities", Boolean.FALSE);
        parserPool.setBuilderFeatures(builderFeatures);
        parserPool.setDTDValidating(false);
        parserPool.setExpandEntityReferences(false);
        parserPool.setMaxPoolSize(50);
        parserPool.setNamespaceAware(true);
        try {
            parserPool.initialize();
            parserPool.getBuilder();
            XMLObjectProviderRegistry xmlObjectProviderRegistry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
            xmlObjectProviderRegistry.setParserPool((ParserPool)parserPool);
        }
        catch (Exception xmlpe) {
            throw new InitializationException("Unable to initialize parser pool: " + xmlpe.getMessage(), (Throwable)xmlpe);
        }
    }

    @Deactivate
    protected void deactivate() {
        if (this._parserPoolServiceRegistration != null) {
            this._parserPoolServiceRegistration.unregister();
        }
    }
}

