/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.util;

import java.lang.reflect.Method;
import javax.crypto.SecretKey;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.prng.EntropySource;
import org.bouncycastle.crypto.prng.SP800SecureRandom;
import org.bouncycastle.crypto.prng.drbg.HashSP800DRBG;
import org.bouncycastle.crypto.prng.drbg.SP80090DRBG;
import org.cryptacular.generator.sp80038a.EncryptedNonce;
import org.cryptacular.generator.sp80038d.RBGNonce;
import org.cryptacular.util.ReflectUtil;

public final class NonceUtil {
    private NonceUtil() {
    }

    public static byte[] timestampNonce(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException(length + " is invalid. Length must be positive.");
        }
        byte[] nonce = new byte[length];
        int count = 0;
        while (count < length) {
            long timestamp = System.nanoTime();
            for (int i = 0; i < 8 && count < length; ++i) {
                nonce[count++] = (byte)(timestamp & 0xFFL);
                timestamp >>= 8;
            }
        }
        return nonce;
    }

    public static byte[] nist80038d(int length) {
        return new RBGNonce(length).generate();
    }

    public static byte[] nist80063a(BlockCipher cipher, SecretKey key) {
        BlockCipher raw = cipher;
        Method method = ReflectUtil.getMethod(cipher.getClass(), "getUnderlyingCipher", new Class[0]);
        if (method != null) {
            raw = (BlockCipher)ReflectUtil.invoke(cipher, method, new Object[0]);
        }
        return new EncryptedNonce(raw, key).generate();
    }

    public static byte[] nist80063a(SP800SecureRandom prng, int blockSize) {
        prng.setSeed(System.nanoTime());
        byte[] iv = new byte[blockSize];
        prng.nextBytes(iv);
        return iv;
    }

    public static byte[] nist80063a(BlockCipher cipher) {
        return new RBGNonce(cipher.getBlockSize()).generate();
    }

    public static SP80090DRBG newRBG(int length) {
        return NonceUtil.newRBG(new SHA256Digest(), length);
    }

    public static SP80090DRBG newRBG(Digest digest, final int length) {
        return new HashSP800DRBG(digest, length, new EntropySource(){

            @Override
            public boolean isPredictionResistant() {
                return false;
            }

            @Override
            public byte[] getEntropy() {
                return NonceUtil.timestampNonce(length);
            }

            @Override
            public int entropySize() {
                return length;
            }
        }, null, NonceUtil.timestampNonce(8));
    }
}

