/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml1.binding.encoding;

import java.util.List;
import org.opensaml.Configuration;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.common.binding.artifact.AbstractSAMLArtifact;
import org.opensaml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml1.binding.artifact.SAML1ArtifactBuilder;
import org.opensaml.saml1.binding.artifact.SAML1ArtifactType0001;
import org.opensaml.saml1.binding.encoding.BaseSAML1MessageEncoder;
import org.opensaml.saml1.core.Assertion;
import org.opensaml.saml1.core.Response;
import org.opensaml.util.URLBuilder;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPArtifactEncoder
extends BaseSAML1MessageEncoder {
    private final Logger log = LoggerFactory.getLogger(HTTPArtifactEncoder.class);
    private SAMLArtifactMap artifactMap;
    private byte[] defaultArtifactType;

    public HTTPArtifactEncoder(SAMLArtifactMap map) {
        this.artifactMap = map;
        this.defaultArtifactType = SAML1ArtifactType0001.TYPE_CODE;
    }

    @Override
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01";
    }

    @Override
    public boolean providesMessageConfidentiality(MessageContext messageContext) throws MessageEncodingException {
        return false;
    }

    @Override
    public boolean providesMessageIntegrity(MessageContext messageContext) throws MessageEncodingException {
        return false;
    }

    @Override
    protected void doEncode(MessageContext messageContext) throws MessageEncodingException {
        SAML1ArtifactBuilder artifactBuilder;
        if (!(messageContext instanceof SAMLMessageContext)) {
            this.log.error("Invalid message context type, this encoder only support SAMLMessageContext");
            throw new MessageEncodingException("Invalid message context type, this encoder only support SAMLMessageContext");
        }
        if (!(messageContext.getOutboundMessageTransport() instanceof HTTPOutTransport)) {
            this.log.error("Invalid outbound message transport type, this encoder only support HTTPOutTransport");
            throw new MessageEncodingException("Invalid outbound message transport type, this encoder only support HTTPOutTransport");
        }
        SAMLMessageContext artifactContext = (SAMLMessageContext)messageContext;
        HTTPOutTransport outTransport = (HTTPOutTransport)artifactContext.getOutboundMessageTransport();
        URLBuilder urlBuilder = this.getEndpointURL(artifactContext);
        List<Pair<String, String>> params = urlBuilder.getQueryParams();
        params.add(new Pair<String, String>("TARGET", artifactContext.getRelayState()));
        if (artifactContext.getOutboundMessageArtifactType() != null) {
            artifactBuilder = Configuration.getSAML1ArtifactBuilderFactory().getArtifactBuilder(artifactContext.getOutboundMessageArtifactType());
        } else {
            artifactBuilder = Configuration.getSAML1ArtifactBuilderFactory().getArtifactBuilder(this.defaultArtifactType);
            artifactContext.setOutboundMessageArtifactType(this.defaultArtifactType);
        }
        for (Assertion assertion : ((Response)artifactContext.getOutboundSAMLMessage()).getAssertions()) {
            Object artifact = artifactBuilder.buildArtifact(artifactContext, assertion);
            if (artifact == null) {
                this.log.error("Unable to build artifact for message to relying party");
                throw new MessageEncodingException("Unable to builder artifact for message to relying party");
            }
            try {
                this.artifactMap.put(((AbstractSAMLArtifact)artifact).base64Encode(), messageContext.getInboundMessageIssuer(), messageContext.getOutboundMessageIssuer(), assertion);
            }
            catch (MarshallingException e) {
                this.log.error("Unable to marshall assertion to be represented as an artifact", (Throwable)e);
                throw new MessageEncodingException("Unable to marshall assertion to be represented as an artifact", e);
            }
            String artifactString = ((AbstractSAMLArtifact)artifact).base64Encode();
            params.add(new Pair<String, String>("SAMLart", artifactString));
        }
        String redirectUrl = urlBuilder.buildURL();
        this.log.debug("Sending redirect to URL {} to relying party {}", (Object)redirectUrl, (Object)artifactContext.getInboundMessageIssuer());
        outTransport.sendRedirect(urlBuilder.buildURL());
    }
}

