/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml1.binding.decoding;

import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.common.binding.decoding.BaseSAMLMessageDecoder;
import org.opensaml.saml1.core.Assertion;
import org.opensaml.saml1.core.AssertionArtifact;
import org.opensaml.saml1.core.AttributeQuery;
import org.opensaml.saml1.core.AuthorizationDecisionQuery;
import org.opensaml.saml1.core.Request;
import org.opensaml.saml1.core.RequestAbstractType;
import org.opensaml.saml1.core.Response;
import org.opensaml.saml1.core.ResponseAbstractType;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSAML1MessageDecoder
extends BaseSAMLMessageDecoder {
    private final Logger log = LoggerFactory.getLogger(BaseSAML1MessageDecoder.class);
    private SAMLArtifactMap artifactMap;
    private boolean useQueryResourceAsEntityId;

    public BaseSAML1MessageDecoder() {
        this.useQueryResourceAsEntityId = true;
    }

    public BaseSAML1MessageDecoder(ParserPool pool) {
        super(pool);
        this.useQueryResourceAsEntityId = true;
    }

    public BaseSAML1MessageDecoder(SAMLArtifactMap map) {
        this.artifactMap = map;
        this.useQueryResourceAsEntityId = true;
    }

    public BaseSAML1MessageDecoder(SAMLArtifactMap map, ParserPool pool) {
        super(pool);
        this.artifactMap = map;
        this.useQueryResourceAsEntityId = true;
    }

    @Override
    public void decode(MessageContext messageContext) throws MessageDecodingException, SecurityException {
        super.decode(messageContext);
        SAMLMessageContext samlMsgCtx = (SAMLMessageContext)messageContext;
        if (samlMsgCtx.getInboundSAMLMessage() instanceof ResponseAbstractType) {
            this.checkEndpointURI(samlMsgCtx);
        }
    }

    public SAMLArtifactMap getArtifactMap() {
        return this.artifactMap;
    }

    public boolean getUseQueryResourceAsEntityId() {
        return this.useQueryResourceAsEntityId;
    }

    public void setUseQueryResourceAsEntityId(boolean useResource) {
        this.useQueryResourceAsEntityId = useResource;
    }

    protected void populateMessageContext(SAMLMessageContext messageContext) throws MessageDecodingException {
        this.populateMessageIdIssueInstantIssuer(messageContext);
        this.populateRelyingPartyMetadata(messageContext);
    }

    protected void populateMessageIdIssueInstantIssuer(SAMLMessageContext messageContext) throws MessageDecodingException {
        Object samlMsg = messageContext.getInboundSAMLMessage();
        if (samlMsg == null) {
            return;
        }
        if (samlMsg instanceof RequestAbstractType) {
            this.log.debug("Extracting ID, issuer and issue instant from request");
            this.extractRequestInfo(messageContext, (RequestAbstractType)samlMsg);
        } else if (samlMsg instanceof Response) {
            this.log.debug("Extracting ID, issuer and issue instant from response");
            this.extractResponseInfo(messageContext, (Response)samlMsg);
        } else {
            throw new MessageDecodingException("SAML 1.x message was not a request or a response");
        }
    }

    protected void extractRequestInfo(SAMLMessageContext messageContext, RequestAbstractType abstractRequest) {
        messageContext.setInboundSAMLMessageId(abstractRequest.getID());
        messageContext.setInboundSAMLMessageIssueInstant(abstractRequest.getIssueInstant());
        if (abstractRequest instanceof Request) {
            Request request = (Request)abstractRequest;
            if (request.getAttributeQuery() != null) {
                this.extractAttributeQueryInfo(messageContext, request.getAttributeQuery());
            }
            if (request.getAuthorizationDecisionQuery() != null) {
                this.extractAuthorizationDecisionQueryInfo(messageContext, request.getAuthorizationDecisionQuery());
            }
            if (request.getAssertionArtifacts() != null) {
                this.extractAssertionArtifactInfo(messageContext, request.getAssertionArtifacts());
            }
        }
    }

    protected void extractAttributeQueryInfo(SAMLMessageContext messageContext, AttributeQuery query) {
        if (this.useQueryResourceAsEntityId) {
            this.log.debug("Attempting to extract issuer from SAML 1 AttributeQuery Resource attribute");
            String resource = DatatypeHelper.safeTrimOrNullString(query.getResource());
            if (resource != null) {
                messageContext.setInboundMessageIssuer(resource);
                this.log.debug("Extracted issuer from SAML 1.x AttributeQuery: {}", (Object)resource);
            }
        }
    }

    protected void extractAuthorizationDecisionQueryInfo(SAMLMessageContext messageContext, AuthorizationDecisionQuery query) {
        if (this.useQueryResourceAsEntityId) {
            this.log.debug("Attempting to extract issuer from SAML 1 AuthorizationDecisionQuery Resource attribute");
            String resource = DatatypeHelper.safeTrimOrNullString(query.getResource());
            if (resource != null) {
                messageContext.setInboundMessageIssuer(resource);
                this.log.debug("Extracted issuer from SAML 1.x AuthorizationDecisionQuery: {}", (Object)resource);
            }
        }
    }

    protected void extractAssertionArtifactInfo(SAMLMessageContext messageContext, List<AssertionArtifact> artifacts) {
        if (artifacts.size() == 0) {
            return;
        }
        this.log.debug("Attempting to extract issuer based on first AssertionArtifact in request");
        AssertionArtifact artifact = artifacts.get(0);
        SAMLArtifactMap.SAMLArtifactMapEntry artifactEntry = this.artifactMap.get(artifact.getAssertionArtifact());
        messageContext.setInboundMessageIssuer(artifactEntry.getRelyingPartyId());
        this.log.debug("Extracted issuer from SAML 1.x AssertionArtifact: {}", (Object)messageContext.getInboundMessageIssuer());
    }

    protected void extractResponseInfo(SAMLMessageContext messageContext, Response response) throws MessageDecodingException {
        messageContext.setInboundSAMLMessageId(response.getID());
        messageContext.setInboundSAMLMessageIssueInstant(response.getIssueInstant());
        String issuer = null;
        List<Assertion> assertions = response.getAssertions();
        if (assertions != null && assertions.size() > 0) {
            this.log.info("Attempting to extract issuer from enclosed SAML 1.x Assertion(s)");
            for (Assertion assertion : assertions) {
                if (assertion == null || assertion.getIssuer() == null) continue;
                if (issuer != null && !issuer.equals(assertion.getIssuer())) {
                    throw new MessageDecodingException("SAML 1.x assertions, within response " + response.getID() + " contain different issuer IDs");
                }
                issuer = assertion.getIssuer();
            }
        }
        if (issuer == null) {
            this.log.warn("Issuer could not be extracted from standard SAML 1.x response message");
        }
        messageContext.setInboundMessageIssuer(issuer);
    }

    protected void populateRelyingPartyMetadata(SAMLMessageContext messageContext) throws MessageDecodingException {
        MetadataProvider metadataProvider = messageContext.getMetadataProvider();
        try {
            if (metadataProvider != null) {
                List<RoleDescriptor> roles;
                EntityDescriptor relyingPartyMD = metadataProvider.getEntityDescriptor(messageContext.getInboundMessageIssuer());
                messageContext.setPeerEntityMetadata(relyingPartyMD);
                QName relyingPartyRole = messageContext.getPeerEntityRole();
                if (relyingPartyMD != null && relyingPartyRole != null && (roles = relyingPartyMD.getRoleDescriptors(relyingPartyRole, "urn:oasis:names:tc:SAML:1.1:protocol")) != null && roles.size() > 0) {
                    messageContext.setPeerEntityRoleMetadata(roles.get(0));
                }
            }
        }
        catch (MetadataProviderException e) {
            this.log.error("Error retrieving metadata for relying party " + messageContext.getInboundMessageIssuer(), (Throwable)e);
            throw new MessageDecodingException("Error retrieving metadata for relying party " + messageContext.getInboundMessageIssuer(), e);
        }
    }

    @Override
    protected String getIntendedDestinationEndpointURI(SAMLMessageContext samlMsgCtx) throws MessageDecodingException {
        Object samlMessage = samlMsgCtx.getInboundSAMLMessage();
        String messageDestination = null;
        if (!(samlMessage instanceof ResponseAbstractType)) {
            if (samlMessage instanceof RequestAbstractType) {
                return null;
            }
            this.log.error("Invalid SAML message type encountered: {}", (Object)samlMessage.getElementQName().toString());
            throw new MessageDecodingException("Invalid SAML message type encountered");
        }
        ResponseAbstractType response = (ResponseAbstractType)samlMessage;
        messageDestination = DatatypeHelper.safeTrimOrNullString(response.getRecipient());
        return messageDestination;
    }
}

