/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.credential;

import com.liferay.saml.runtime.configuration.SamlProviderConfiguration;
import com.liferay.saml.runtime.configuration.SamlProviderConfigurationHelper;
import com.liferay.saml.runtime.credential.KeyStoreManager;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.AbstractCriteriaFilteringCredentialResolver;
import org.opensaml.xml.security.credential.BasicCredential;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.saml.runtime.configuration.SamlKeyStoreManagerConfiguration"}, immediate=true, service={CredentialResolver.class})
public class KeyStoreCredentialResolver
extends AbstractCriteriaFilteringCredentialResolver {
    private KeyStoreManager _keyStoreManager;
    private SamlProviderConfigurationHelper _samlProviderConfigurationHelper;

    @Reference(name="KeyStoreManager", target="(default=true)", unbind="-")
    public void setKeyStoreManager(KeyStoreManager keyStoreManager) {
        this._keyStoreManager = keyStoreManager;
    }

    @Reference(unbind="-")
    public void setSamlProviderConfigurationHelper(SamlProviderConfigurationHelper samlProviderConfigurationHelper) {
        this._samlProviderConfigurationHelper = samlProviderConfigurationHelper;
    }

    protected Credential buildCredential(KeyStore.Entry entry, String entityId, UsageType usage) {
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            return this.processPrivateKeyEntry((KeyStore.PrivateKeyEntry)entry, entityId, usage);
        }
        if (entry instanceof KeyStore.SecretKeyEntry) {
            return this.processSecretKeyEntry((KeyStore.SecretKeyEntry)entry, entityId, usage);
        }
        if (entry instanceof KeyStore.TrustedCertificateEntry) {
            return this.processTrustedCertificateEntry((KeyStore.TrustedCertificateEntry)entry, entityId, usage);
        }
        return null;
    }

    protected void checkCriteriaRequirements(CriteriaSet criteriaSet) {
        EntityIDCriteria entityCriteria = criteriaSet.get(EntityIDCriteria.class);
        if (entityCriteria == null) {
            throw new IllegalArgumentException("No entity ID criteria was available in criteria set");
        }
    }

    protected Credential processPrivateKeyEntry(KeyStore.PrivateKeyEntry privateKeyEntry, String entityId, UsageType usageType) {
        BasicX509Credential basicX509Credential = new BasicX509Credential();
        basicX509Credential.setEntityCertificate((X509Certificate)privateKeyEntry.getCertificate());
        basicX509Credential.setEntityCertificateChain(Arrays.asList((X509Certificate[])privateKeyEntry.getCertificateChain()));
        basicX509Credential.setEntityId(entityId);
        basicX509Credential.setPrivateKey(privateKeyEntry.getPrivateKey());
        basicX509Credential.setUsageType(usageType);
        return basicX509Credential;
    }

    protected Credential processSecretKeyEntry(KeyStore.SecretKeyEntry secretKeyEntry, String entityId, UsageType usageType) {
        BasicCredential basicCredential = new BasicCredential();
        basicCredential.setEntityId(entityId);
        basicCredential.setSecretKey(secretKeyEntry.getSecretKey());
        basicCredential.setUsageType(usageType);
        return basicCredential;
    }

    protected Credential processTrustedCertificateEntry(KeyStore.TrustedCertificateEntry trustedCertificateEntry, String entityId, UsageType usageType) {
        BasicX509Credential basicX509Credential = new BasicX509Credential();
        X509Certificate x509Certificate = (X509Certificate)trustedCertificateEntry.getTrustedCertificate();
        basicX509Credential.setEntityCertificate(x509Certificate);
        ArrayList<X509Certificate> x509Certificates = new ArrayList<X509Certificate>();
        x509Certificates.add(x509Certificate);
        basicX509Credential.setEntityCertificateChain(x509Certificates);
        basicX509Credential.setEntityId(entityId);
        basicX509Credential.setUsageType(usageType);
        return basicX509Credential;
    }

    @Override
    protected Iterable<Credential> resolveFromSource(CriteriaSet criteriaSet) throws SecurityException {
        try {
            KeyStore keyStore;
            KeyStore.Entry entry;
            String keyStoreCredentialPassword;
            this.checkCriteriaRequirements(criteriaSet);
            EntityIDCriteria entityIDCriteria = criteriaSet.get(EntityIDCriteria.class);
            String entityId = entityIDCriteria.getEntityID();
            KeyStore.PasswordProtection keyStorePasswordProtection = null;
            SamlProviderConfiguration samlProviderConfiguration = this._samlProviderConfigurationHelper.getSamlProviderConfiguration();
            if (entityId.equals(samlProviderConfiguration.entityId()) && (keyStoreCredentialPassword = samlProviderConfiguration.keyStoreCredentialPassword()) != null) {
                keyStorePasswordProtection = new KeyStore.PasswordProtection(keyStoreCredentialPassword.toCharArray());
            }
            if ((entry = (keyStore = this._keyStoreManager.getKeyStore()).getEntry(entityId, keyStorePasswordProtection)) == null) {
                return Collections.emptySet();
            }
            UsageType usageType = UsageType.UNSPECIFIED;
            UsageCriteria usageCriteria = criteriaSet.get(UsageCriteria.class);
            if (usageCriteria != null) {
                usageType = usageCriteria.getUsage();
            }
            Credential credential = this.buildCredential(entry, entityId, usageType);
            return Collections.singleton(credential);
        }
        catch (RuntimeException re) {
            throw new SecurityException(re);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }
}

