/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.util.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.util.resource.AbstractFilteredResource;
import org.opensaml.util.resource.ResourceException;
import org.opensaml.util.resource.ResourceFilter;
import org.opensaml.xml.util.DatatypeHelper;

public class FilesystemResource
extends AbstractFilteredResource {
    private File resource;

    public FilesystemResource(String resourcePath) throws ResourceException {
        if (DatatypeHelper.isEmpty(resourcePath)) {
            throw new ResourceException("Resource path may not be null or empty");
        }
        this.resource = new File(resourcePath);
    }

    public FilesystemResource(URI resourceURI) throws ResourceException {
        if (resourceURI == null) {
            throw new ResourceException("Resource URL may not be null");
        }
        this.resource = new File(resourceURI);
    }

    public FilesystemResource(String resourcePath, ResourceFilter resourceFilter) throws ResourceException {
        super(resourceFilter);
        if (DatatypeHelper.isEmpty(resourcePath)) {
            throw new ResourceException("Resource path may not be null or empty");
        }
        this.resource = new File(resourcePath);
    }

    public FilesystemResource(URI resourceURI, ResourceFilter resourceFilter) throws ResourceException {
        super(resourceFilter);
        if (resourceURI == null) {
            throw new ResourceException("Resource URI may not be null");
        }
        this.resource = new File(resourceURI);
    }

    @Override
    public boolean exists() throws ResourceException {
        return this.resource.exists();
    }

    @Override
    public InputStream getInputStream() throws ResourceException {
        try {
            FileInputStream ins = new FileInputStream(this.resource);
            return this.applyFilter(ins);
        }
        catch (FileNotFoundException e) {
            throw new ResourceException("Resource file does not exist: " + this.resource.getAbsolutePath());
        }
    }

    @Override
    public DateTime getLastModifiedTime() throws ResourceException {
        if (!this.resource.exists()) {
            throw new ResourceException("Resource file does not exist: " + this.resource.getAbsolutePath());
        }
        return new DateTime(this.resource.lastModified(), (Chronology)ISOChronology.getInstanceUTC());
    }

    @Override
    public String getLocation() {
        return this.resource.getAbsolutePath();
    }

    public String toString() {
        return this.getLocation();
    }

    public int hashCode() {
        return this.getLocation().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FilesystemResource) {
            return this.getLocation().equals(((FilesystemResource)o).getLocation());
        }
        return false;
    }
}

