/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.provider;

import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.opensaml.integration.internal.util.SamlUtil;
import com.liferay.saml.persistence.exception.NoSuchIdpSpConnectionException;
import com.liferay.saml.persistence.exception.NoSuchSpIdpConnectionException;
import com.liferay.saml.persistence.model.SamlIdpSpConnection;
import com.liferay.saml.persistence.model.SamlSpIdpConnection;
import com.liferay.saml.persistence.service.SamlIdpSpConnectionLocalService;
import com.liferay.saml.persistence.service.SamlSpIdpConnectionLocalService;
import com.liferay.saml.runtime.configuration.SamlProviderConfigurationHelper;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.joda.time.DateTime;
import org.opensaml.saml2.common.Extensions;
import org.opensaml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.provider.BaseMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.Namespace;
import org.opensaml.xml.NamespaceManager;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.schema.XSBooleanValue;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.util.IDIndex;
import org.opensaml.xml.util.LazySet;
import org.opensaml.xml.util.XMLObjectHelper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.w3c.dom.Element;

@Component(immediate=true, service={MetadataProvider.class})
public class DBMetadataProvider
extends BaseMetadataProvider {
    @Reference
    private ParserPool _parserPool;
    @Reference
    private SamlIdpSpConnectionLocalService _samlIdpSpConnectionLocalService;
    @Reference
    private SamlProviderConfigurationHelper _samlProviderConfigurationHelper;
    @Reference
    private SamlSpIdpConnectionLocalService _samlSpIdpConnectionLocalService;

    @Override
    public EntitiesDescriptor getEntitiesDescriptor(String name) {
        return null;
    }

    @Override
    public EntityDescriptor getEntityDescriptor(String entityId) throws MetadataProviderException {
        try {
            String metadataXml = this.getMetadataXml(entityId);
            if (Validator.isNull((String)metadataXml)) {
                return null;
            }
            XMLObject metadataXmlObject = XMLObjectHelper.unmarshallFromReader(this._parserPool, new StringReader(metadataXml));
            EntityDescriptor entityDescriptor = SamlUtil.getEntityDescriptorById(entityId, metadataXmlObject);
            return entityDescriptor;
        }
        catch (Exception e) {
            throw new MetadataProviderException(e);
        }
    }

    @Override
    public XMLObject getMetadata() {
        return new DBEntitiesDescriptor();
    }

    @Override
    public List<RoleDescriptor> getRole(String entityId, QName qName) throws MetadataProviderException {
        EntityDescriptor entityDescriptor = this.getEntityDescriptor(entityId);
        if (entityDescriptor != null) {
            return entityDescriptor.getRoleDescriptors(qName);
        }
        return null;
    }

    @Override
    public RoleDescriptor getRole(String entityId, QName qName, String supportedProtocol) throws MetadataProviderException {
        List<RoleDescriptor> roleDescriptors = this.getRole(entityId, qName);
        if (roleDescriptors == null || roleDescriptors.isEmpty()) {
            return null;
        }
        for (RoleDescriptor roleDescriptor : roleDescriptors) {
            if (!roleDescriptor.isSupportedProtocol(supportedProtocol)) continue;
            return roleDescriptor;
        }
        return null;
    }

    public void setParserPool(ParserPool parserPool) {
        this._parserPool = parserPool;
    }

    protected String getMetadataXml(String entityId) throws Exception {
        long companyId = CompanyThreadLocal.getCompanyId();
        if (this._samlProviderConfigurationHelper.isRoleIdp()) {
            try {
                SamlIdpSpConnection samlIdpSpConnection = this._samlIdpSpConnectionLocalService.getSamlIdpSpConnection(companyId, entityId);
                if (!samlIdpSpConnection.isEnabled()) {
                    return null;
                }
                return samlIdpSpConnection.getMetadataXml();
            }
            catch (NoSuchIdpSpConnectionException nsisce) {
                return null;
            }
        }
        if (this._samlProviderConfigurationHelper.isRoleSp()) {
            try {
                SamlSpIdpConnection samlSpIdpConnection = this._samlSpIdpConnectionLocalService.getSamlSpIdpConnection(companyId, entityId);
                if (!samlSpIdpConnection.isEnabled()) {
                    return null;
                }
                return samlSpIdpConnection.getMetadataXml();
            }
            catch (NoSuchSpIdpConnectionException nssice) {
                return null;
            }
        }
        return null;
    }

    private class DBEntitiesDescriptor
    implements EntitiesDescriptor {
        private final List<XMLObject> _xmlObjects = new ArrayList<XMLObject>();

        @Override
        public void addNamespace(Namespace namespace) {
        }

        @Override
        public void deregisterValidator(org.opensaml.xml.validation.Validator validator) {
        }

        @Override
        public void detach() {
        }

        @Override
        public Long getCacheDuration() {
            return null;
        }

        @Override
        public Element getDOM() {
            return null;
        }

        @Override
        public QName getElementQName() {
            return EntitiesDescriptor.DEFAULT_ELEMENT_NAME;
        }

        @Override
        public List<EntitiesDescriptor> getEntitiesDescriptors() {
            ArrayList<EntitiesDescriptor> entitiesDescriptors = new ArrayList<EntitiesDescriptor>();
            for (XMLObject xmlObject : this._xmlObjects) {
                if (!(xmlObject instanceof EntitiesDescriptor)) continue;
                EntitiesDescriptor entitiesDescriptor = (EntitiesDescriptor)xmlObject;
                entitiesDescriptors.add(entitiesDescriptor);
            }
            return entitiesDescriptors;
        }

        @Override
        public List<EntityDescriptor> getEntityDescriptors() {
            ArrayList<EntityDescriptor> entityDescriptors = new ArrayList<EntityDescriptor>();
            for (XMLObject xmlObject : this._xmlObjects) {
                if (!(xmlObject instanceof EntityDescriptor)) continue;
                EntityDescriptor entityDescriptor = (EntityDescriptor)xmlObject;
                entityDescriptors.add(entityDescriptor);
            }
            return entityDescriptors;
        }

        @Override
        public Extensions getExtensions() {
            return null;
        }

        @Override
        public String getID() {
            return null;
        }

        @Override
        public IDIndex getIDIndex() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public NamespaceManager getNamespaceManager() {
            return null;
        }

        @Override
        public Set<Namespace> getNamespaces() {
            return new LazySet<Namespace>();
        }

        @Override
        public String getNoNamespaceSchemaLocation() {
            return null;
        }

        @Override
        public List<XMLObject> getOrderedChildren() {
            return new ArrayList<XMLObject>();
        }

        @Override
        public XMLObject getParent() {
            return null;
        }

        @Override
        public String getSchemaLocation() {
            return null;
        }

        @Override
        public QName getSchemaType() {
            return EntitiesDescriptor.TYPE_NAME;
        }

        @Override
        public Signature getSignature() {
            return null;
        }

        @Override
        public String getSignatureReferenceID() {
            return null;
        }

        @Override
        public List<org.opensaml.xml.validation.Validator> getValidators() {
            return new ArrayList<org.opensaml.xml.validation.Validator>();
        }

        @Override
        public DateTime getValidUntil() {
            return null;
        }

        @Override
        public boolean hasChildren() {
            List<XMLObject> xmlObjects = this.getOrderedChildren();
            return !xmlObjects.isEmpty();
        }

        @Override
        public boolean hasParent() {
            return false;
        }

        @Override
        public Boolean isNil() {
            return Boolean.FALSE;
        }

        @Override
        public XSBooleanValue isNilXSBoolean() {
            return new XSBooleanValue(Boolean.FALSE, false);
        }

        @Override
        public boolean isSigned() {
            return false;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public void registerValidator(org.opensaml.xml.validation.Validator validator) {
        }

        @Override
        public void releaseChildrenDOM(boolean propagateRelease) {
        }

        @Override
        public void releaseDOM() {
        }

        @Override
        public void releaseParentDOM(boolean propagateRelease) {
        }

        @Override
        public void removeNamespace(Namespace namespace) {
        }

        @Override
        public XMLObject resolveID(String id) {
            return null;
        }

        @Override
        public XMLObject resolveIDFromRoot(String id) {
            return null;
        }

        @Override
        public void setCacheDuration(Long duration) {
        }

        @Override
        public void setDOM(Element element) {
        }

        @Override
        public void setExtensions(Extensions extensions) {
        }

        @Override
        public void setID(String id) {
        }

        @Override
        public void setName(String name) {
        }

        @Override
        public void setNil(Boolean value) {
        }

        @Override
        public void setNil(XSBooleanValue value) {
        }

        @Override
        public void setNoNamespaceSchemaLocation(String location) {
        }

        @Override
        public void setParent(XMLObject xmlObject) {
        }

        @Override
        public void setSchemaLocation(String location) {
        }

        @Override
        public void setSignature(Signature signature) {
        }

        @Override
        public void setValidUntil(DateTime validUntil) {
        }

        @Override
        public void validate(boolean validateDescendants) {
        }
    }
}

