/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.push.notifications.sender.android.internal;

import com.google.android.gcm.server.Message;
import com.google.android.gcm.server.MulticastResult;
import com.google.android.gcm.server.Result;
import com.google.android.gcm.server.Sender;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.push.notifications.exception.PushNotificationsException;
import com.liferay.push.notifications.sender.PushNotificationsSender;
import com.liferay.push.notifications.sender.android.internal.AndroidResponse;
import com.liferay.push.notifications.sender.android.internal.configuration.AndroidPushNotificationsSenderConfiguration;
import com.liferay.push.notifications.service.PushNotificationsDeviceLocalService;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.push.notifications.sender.android.internal.configuration.AndroidPushNotificationsSenderConfiguration"}, immediate=true, property={"platform=android"}, service={PushNotificationsSender.class})
public class AndroidPushNotificationsSender
implements PushNotificationsSender {
    public static final String PLATFORM = "android";
    private static final Log _log = LogFactoryUtil.getLog(AndroidPushNotificationsSender.class);
    private volatile AndroidPushNotificationsSenderConfiguration _androidPushNotificationsSenderConfiguration;
    private PushNotificationsDeviceLocalService _pushNotificationsDeviceLocalService;
    private volatile Sender _sender;

    public void send(List<String> tokens, JSONObject payloadJSONObject) throws Exception {
        if (this._sender == null) {
            throw new PushNotificationsException("Android push notifications sender is not configured properly");
        }
        Message message = this.buildMessage(payloadJSONObject);
        MulticastResult multicastResult = this._sender.send(message, tokens, this._androidPushNotificationsSenderConfiguration.retries());
        this.validateMulticastResult(tokens, payloadJSONObject, multicastResult);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._androidPushNotificationsSenderConfiguration = (AndroidPushNotificationsSenderConfiguration)ConfigurableUtil.createConfigurable(AndroidPushNotificationsSenderConfiguration.class, properties);
        String apiKey = this._androidPushNotificationsSenderConfiguration.apiKey();
        if (Validator.isNull((String)apiKey)) {
            this._sender = null;
            return;
        }
        this._sender = new Sender(apiKey);
    }

    protected Message buildMessage(JSONObject payloadJSONObject) {
        Message.Builder builder = new Message.Builder();
        builder.addData("payload", payloadJSONObject.toString());
        return builder.build();
    }

    @Deactivate
    protected void deactivate() {
        this._sender = null;
    }

    @Reference(unbind="-")
    protected void setPushNotificationsDeviceLocalService(PushNotificationsDeviceLocalService pushNotificationsDeviceLocalService) {
        this._pushNotificationsDeviceLocalService = pushNotificationsDeviceLocalService;
    }

    protected void validateMulticastResult(List<String> tokens, JSONObject payloadJSONObject, MulticastResult multicastResult) {
        List results = multicastResult.getResults();
        for (int i = 0; i < results.size(); ++i) {
            String errorCodeName;
            String token;
            Result result;
            block6: {
                result = (Result)results.get(i);
                token = tokens.get(i);
                AndroidResponse response = new AndroidResponse(result, token, payloadJSONObject);
                MessageBusUtil.sendMessage((String)"liferay/push_notification_response", (Object)((Object)response));
                if (multicastResult.getCanonicalIds() == 0 && multicastResult.getFailure() == 0) continue;
                String canonicalRegistrationId = result.getCanonicalRegistrationId();
                String messageId = result.getMessageId();
                if (Validator.isNotNull((String)canonicalRegistrationId) && Validator.isNotNull((String)messageId)) {
                    try {
                        this._pushNotificationsDeviceLocalService.updateToken(token, canonicalRegistrationId);
                    }
                    catch (Exception e) {
                        if (!_log.isWarnEnabled()) break block6;
                        _log.warn((Object)("Unable to update token " + token));
                    }
                }
            }
            if (!Validator.isNotNull((String)(errorCodeName = result.getErrorCodeName())) || !errorCodeName.equals("InvalidRegistration") && !errorCodeName.equals("MismatchSenderId") && !errorCodeName.equals("NotRegistered")) continue;
            try {
                this._pushNotificationsDeviceLocalService.deletePushNotificationsDevice(token);
                continue;
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to delete invalid token " + token));
            }
        }
    }
}

