/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sample.sql.builder;

import com.liferay.petra.string.StringBundler;
import java.util.concurrent.atomic.AtomicLong;

public class SequentialUUID {
    private static final char[] _HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String _UUID_PREFIX = "00000000-0000-0000-";
    private static final AtomicLong _counter = new AtomicLong();
    private static final SequentialUUID _sequentialUUID = new SequentialUUID();

    public static String generate() {
        long count = _counter.getAndIncrement();
        long high = count >> 48 & 0xFFFFL;
        long low = count & 0xFFFFFFFFFFFFL;
        return StringBundler.concat((String[])new String[]{_UUID_PREFIX, SequentialUUID._toHexString(high, 4), "-", SequentialUUID._toHexString(low, 8)});
    }

    public static SequentialUUID getSequentialUUID() {
        return _sequentialUUID;
    }

    private static String _toHexString(long number, int digits) {
        char[] buffer = new char[digits];
        for (int i = 0; i < digits; ++i) {
            buffer[i] = 48;
        }
        int index = digits;
        do {
            buffer[--index] = _HEX_DIGITS[(int)(number & 0xFL)];
        } while ((number >>>= 4) != 0L);
        return new String(buffer);
    }
}

