/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sample.sql.builder;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.petra.process.ClassPathUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.tools.ToolDependencies;
import com.liferay.portal.tools.sample.sql.builder.SampleSQLBuilder;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;

public class SampleSQLBuilderLauncher {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ToolDependencies.wireBasic();
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        File tempDir = FileUtil.createTempFolder();
        URLClassLoader classLoader = new URLClassLoader(SampleSQLBuilderLauncher._getURLs(contextClassLoader, tempDir.toPath()), null);
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)classLoader);){
            InstanceFactory.newInstance((ClassLoader)classLoader, (String)SampleSQLBuilder.class.getName());
        }
        finally {
            FileUtil.deltree((File)tempDir);
        }
    }

    private static URL[] _getURLs(ClassLoader classLoader, Path tempDirPath) throws Exception {
        Set urls = SetUtil.fromArray((Object[])ClassPathUtil.getClassPathURLs((String)ClassPathUtil.getJVMClassPath((boolean)true)));
        URL url = classLoader.getResource("lib");
        try (FileSystem fileSystem = FileSystems.newFileSystem(url.toURI(), Collections.emptyMap());
             DirectoryStream<Path> directoryStream = Files.newDirectoryStream(fileSystem.getPath("/lib", new String[0]), "*.jar");){
            for (Path path : directoryStream) {
                Path targetPath = tempDirPath.resolve(String.valueOf(path.getFileName()));
                Files.copy(path, targetPath, new CopyOption[0]);
                URI uri = targetPath.toUri();
                urls.add(uri.toURL());
            }
        }
        return urls.toArray(new URL[0]);
    }
}

