/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.engine;

import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceCache;
import com.liferay.portal.template.engine.TemplateContextHelper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public abstract class BaseTemplate
implements Template {
    protected Map<String, Object> context;
    private final boolean _restricted;
    private final TemplateContextHelper _templateContextHelper;
    private final TemplateResource _templateResource;

    public BaseTemplate(TemplateResource templateResource, Map<String, Object> context, TemplateContextHelper templateContextHelper, boolean restricted) {
        if (templateResource == null) {
            throw new IllegalArgumentException("Template resource is null");
        }
        if (templateContextHelper == null) {
            throw new IllegalArgumentException("Template context helper is null");
        }
        this._templateResource = templateResource;
        this.context = new HashMap<String, Object>();
        if (context != null) {
            for (Map.Entry<String, Object> entry : context.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
        this._templateContextHelper = templateContextHelper;
        this._restricted = restricted;
    }

    public void clear() {
        this.context.clear();
    }

    public boolean containsKey(Object key) {
        return this.context.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.context.containsValue(value);
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.context.entrySet();
    }

    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        return this.context.get(key);
    }

    public boolean isEmpty() {
        return this.context.isEmpty();
    }

    public boolean isRestricted() {
        return this._restricted;
    }

    public Set<String> keySet() {
        return this.context.keySet();
    }

    public void prepare(HttpServletRequest httpServletRequest) {
        this._templateContextHelper.prepare((Map<String, Object>)((Object)this), httpServletRequest);
    }

    public void prepareTaglib(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
    }

    public void processTemplate(Writer writer) throws TemplateException {
        try {
            this.processTemplate(this._templateResource, writer);
        }
        catch (Exception exception) {
            throw new TemplateException("Unable to process template " + this._templateResource.getTemplateId(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTemplate(Writer writer, Supplier<TemplateResource> errorTemplateResourceSupplier) throws TemplateException {
        if (errorTemplateResourceSupplier == null) {
            this.processTemplate(writer);
            return;
        }
        Writer oldWriter = (Writer)this.get("writer");
        try {
            UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
            this.put("writer", (Object)unsyncStringWriter);
            this.processTemplate(this._templateResource, (Writer)unsyncStringWriter);
            StringBundler sb = unsyncStringWriter.getStringBundler();
            sb.writeTo(writer);
        }
        catch (Exception exception) {
            TemplateResource errorTemplateResource = errorTemplateResourceSupplier.get();
            if (errorTemplateResource == null) {
                throw new TemplateException("Unable to process template " + this._templateResource.getTemplateId(), (Throwable)exception);
            }
            this.put("writer", (Object)writer);
            this.handleException(this._templateResource, errorTemplateResource, exception, writer);
        }
        finally {
            this.put("writer", (Object)oldWriter);
        }
    }

    public Object put(String key, Object value) {
        Set<String> restrictedVariables;
        if (key == null || value == null) {
            return null;
        }
        if (this._restricted && (restrictedVariables = this._templateContextHelper.getRestrictedVariables()).contains(key)) {
            return null;
        }
        if (value instanceof Class) {
            return this.putClass(key, (Class)value);
        }
        return this.context.put(key, value);
    }

    public void putAll(Map<? extends String, ? extends Object> map) {
        map.forEach(this::put);
    }

    public Object remove(Object key) {
        return this.context.remove(key);
    }

    public int size() {
        return this.context.size();
    }

    public Collection<Object> values() {
        return this.context.values();
    }

    protected void cacheTemplateResource(TemplateResourceCache templateResourceCache, TemplateResource templateResource) {
        TemplateResource cachedTemplateResource = templateResourceCache.getTemplateResource(templateResource.getTemplateId());
        if (cachedTemplateResource == null || !templateResource.equals((Object)cachedTemplateResource)) {
            templateResourceCache.put(templateResource.getTemplateId(), templateResource);
        }
    }

    protected String getTemplateResourceUUID(TemplateResource templateResource) {
        return StringBundler.concat((String[])new String[]{"TEMPLATE_RESOURCE_UUID", "#", templateResource.getTemplateId()});
    }

    protected abstract void handleException(TemplateResource var1, TemplateResource var2, Exception var3, Writer var4) throws TemplateException;

    protected abstract void processTemplate(TemplateResource var1, Writer var2) throws Exception;

    protected Object putClass(String key, Class<?> clazz) {
        return this.context.put(key, clazz);
    }
}

