/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.scripting.javascript.configuration;

import aQute.bnd.annotation.metatype.Meta;

import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;

/**
 * @author Michael C. Han
 */
@ExtendedObjectClassDefinition(category = "scripting-engines")
@Meta.OCD(
	id = "com.liferay.portal.scripting.javascript.configuration.JavaScriptExecutorConfiguration",
	localization = "content/Language",
	name = "javascript-executor-configuration-name"
)
public interface JavaScriptExecutorConfiguration {

	@Meta.AD(
		deflt = "com.liferay.portal.kernel.scripting.ScriptingUtil|com.liferay.portal.scripting.internal.ScriptingImpl|java.lang.System",
		name = "forbidden-class-names", required = false
	)
	public String[] forbiddenClassNames();

}