/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.instance.lifecycle.internal;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.instance.lifecycle.EveryNodeEveryStartup;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.instance.lifecycle.PortalInstanceLifecycleManager;
import com.liferay.portal.kernel.io.Deserializer;
import com.liferay.portal.kernel.io.Serializer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Transactional(propagation=Propagation.REQUIRED)
@Component(service={AopService.class})
public class PortalInstanceLifecycleListenerManagerImpl
implements AopService,
IdentifiableOSGiService,
PortalInstanceLifecycleManager {
    private static final Log _log = LogFactoryUtil.getLog(PortalInstanceLifecycleListenerManagerImpl.class);
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRED, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    private BundleContext _bundleContext;
    private final Set<Company> _companies = new CopyOnWriteArraySet<Company>();
    @Reference
    private CompanyLocalService _companyLocalService;
    private final Map<Long, Map<String, Long>> _refreshedRegistryMap = new HashMap<Long, Map<String, Long>>();
    private Map<Long, Map<String, Long>> _registryMap;
    private ServiceTrackerList<PortalInstanceLifecycleListener> _serviceTrackerList;

    public String getOSGiServiceIdentifier() {
        return PortalInstanceLifecycleListenerManagerImpl.class.getName();
    }

    @Clusterable
    public void preregisterCompany(Company company) {
        for (PortalInstanceLifecycleListener portalInstanceLifecycleListener : this._serviceTrackerList) {
            this.preregisterCompany(portalInstanceLifecycleListener, company);
        }
    }

    @Clusterable
    public void preunregisterCompany(Company company) {
        for (PortalInstanceLifecycleListener portalInstanceLifecycleListener : this._serviceTrackerList) {
            this.preunregisterCompany(portalInstanceLifecycleListener, company);
        }
    }

    @Clusterable
    public void registerCompany(Company company) {
        this._companies.add(company);
        for (PortalInstanceLifecycleListener portalInstanceLifecycleListener : this._serviceTrackerList) {
            this.registerCompany(portalInstanceLifecycleListener, company);
        }
    }

    @Clusterable
    public void unregisterCompany(Company company) {
        this._companies.remove(company);
        for (PortalInstanceLifecycleListener portalInstanceLifecycleListener : this._serviceTrackerList) {
            this.unregisterCompany(portalInstanceLifecycleListener, company);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._registryMap = this._loadRegistryMap(bundleContext);
        this._bundleContext = bundleContext;
        this._serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, PortalInstanceLifecycleListener.class, null, (ServiceTrackerCustomizer)new PortalInstanceLifecycleListenerServiceTrackerCustomizer());
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerList.close();
        this._saveRegistryMap(this._bundleContext, this._refreshedRegistryMap);
    }

    protected void preregisterCompany(PortalInstanceLifecycleListener portalInstanceLifecycleListener, Company company) {
        this._runIfNeeded(company.getCompanyId(), portalInstanceLifecycleListener, false, () -> {
            block2: {
                try {
                    portalInstanceLifecycleListener.portalInstancePreregistered(company);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to preregister portal instance " + company), (Throwable)exception);
                }
            }
        });
    }

    protected void preunregisterCompany(PortalInstanceLifecycleListener portalInstanceLifecycleListener, Company company) {
        block2: {
            try {
                portalInstanceLifecycleListener.portalInstancePreunregistered(company);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Unable to preunregister portal instance " + company), (Throwable)exception);
            }
        }
    }

    protected void registerCompany(PortalInstanceLifecycleListener portalInstanceLifecycleListener, Company company) {
        this._runIfNeeded(company.getCompanyId(), portalInstanceLifecycleListener, true, () -> {
            Long companyId = CompanyThreadLocal.getCompanyId();
            Locale siteDefaultLocale = LocaleThreadLocal.getSiteDefaultLocale();
            try (SafeCloseable safeCloseable = CompanyThreadLocal.setInitializingPortalInstance((boolean)true);){
                CompanyThreadLocal.setCompanyId((Long)company.getCompanyId());
                LocaleThreadLocal.setSiteDefaultLocale(null);
                portalInstanceLifecycleListener.portalInstanceRegistered(company);
            }
            catch (Exception exception) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to register portal instance " + company), (Throwable)exception);
                }
            }
            finally {
                CompanyThreadLocal.setCompanyId((Long)companyId);
                LocaleThreadLocal.setSiteDefaultLocale((Locale)siteDefaultLocale);
            }
        });
    }

    protected void unregisterCompany(PortalInstanceLifecycleListener portalInstanceLifecycleListener, Company company) {
        block2: {
            try {
                portalInstanceLifecycleListener.portalInstanceUnregistered(company);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Unable to unregister portal instance " + company), (Throwable)exception);
            }
        }
    }

    private Map<Long, Map<String, Long>> _loadRegistryMap(BundleContext bundleContext) {
        HashMap<Long, Map<String, Long>> registryMap;
        block6: {
            registryMap = new HashMap<Long, Map<String, Long>>();
            File dataFile = bundleContext.getDataFile("registry.data");
            if (dataFile.exists()) {
                try {
                    Deserializer deserializer = new Deserializer(ByteBuffer.wrap(FileUtil.getBytes((File)dataFile)));
                    Bundle bundle = bundleContext.getBundle();
                    if (deserializer.readLong() == bundle.getLastModified()) {
                        int size = deserializer.readInt();
                        for (int i = 0; i < size; ++i) {
                            long companyId = deserializer.readLong();
                            int count = deserializer.readInt();
                            HashMap<String, Long> registry = new HashMap<String, Long>();
                            for (int j = 0; j < count; ++j) {
                                registry.put(deserializer.readString(), deserializer.readLong());
                            }
                            registryMap.put(companyId, registry);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block6;
                    _log.warn((Object)"Unable to load registry data", (Throwable)exception);
                }
            }
        }
        return registryMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _runIfNeeded(long companyId, PortalInstanceLifecycleListener portalInstanceLifecycleListener, boolean addToRefreshedRegistry, Runnable runnable) {
        if (portalInstanceLifecycleListener instanceof EveryNodeEveryStartup) {
            runnable.run();
            return;
        }
        if (!ClusterInvokeThreadLocal.isEnabled()) {
            return;
        }
        long currentLastModifiedTime = portalInstanceLifecycleListener.getLastModifiedTime();
        String className = portalInstanceLifecycleListener.getName();
        try {
            Map<String, Long> registry = this._registryMap.get(companyId);
            if (registry == null || currentLastModifiedTime != registry.getOrDefault(className, -1L)) {
                runnable.run();
            }
        }
        finally {
            if (addToRefreshedRegistry) {
                Map refreshedRegistry = this._refreshedRegistryMap.computeIfAbsent(companyId, key -> new HashMap());
                refreshedRegistry.put(className, currentLastModifiedTime);
            }
        }
    }

    private void _saveRegistryMap(BundleContext bundleContext, Map<Long, Map<String, Long>> registryMap) {
        block16: {
            Bundle bundle = bundleContext.getBundle();
            Serializer serializer = new Serializer();
            serializer.writeLong(bundle.getLastModified());
            serializer.writeInt(registryMap.size());
            for (Map.Entry<Long, Map<String, Long>> companyEntry : registryMap.entrySet()) {
                Long companyId = companyEntry.getKey();
                serializer.writeLong(companyId.longValue());
                Map<String, Long> registry = companyEntry.getValue();
                serializer.writeInt(registry.size());
                for (Map.Entry<String, Long> registryEntry : registry.entrySet()) {
                    serializer.writeString(registryEntry.getKey());
                    serializer.writeLong(registryEntry.getValue().longValue());
                }
            }
            File dataFile = bundleContext.getDataFile("registry.data");
            try (FileOutputStream outputStream = new FileOutputStream(dataFile);){
                serializer.writeTo((OutputStream)outputStream);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block16;
                _log.warn((Object)"Unable to write JSON objects cache file", (Throwable)exception);
            }
        }
    }

    private class PortalInstanceLifecycleListenerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<PortalInstanceLifecycleListener, PortalInstanceLifecycleListener> {
        private PortalInstanceLifecycleListenerServiceTrackerCustomizer() {
        }

        public PortalInstanceLifecycleListener addingService(ServiceReference<PortalInstanceLifecycleListener> serviceReference) {
            PortalInstanceLifecycleListener portalInstanceLifecycleListener = (PortalInstanceLifecycleListener)PortalInstanceLifecycleListenerManagerImpl.this._bundleContext.getService(serviceReference);
            if (PortalInstanceLifecycleListenerManagerImpl.this._companies.isEmpty()) {
                return portalInstanceLifecycleListener;
            }
            for (Company company2 : PortalInstanceLifecycleListenerManagerImpl.this._companies) {
                Company fetchedCompany = PortalInstanceLifecycleListenerManagerImpl.this._companyLocalService.fetchCompanyById(company2.getCompanyId());
                if (fetchedCompany != null) continue;
                try {
                    TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, () -> {
                        PortalInstanceLifecycleListenerManagerImpl.this.unregisterCompany(company2);
                        return null;
                    });
                }
                catch (Throwable throwable) {
                    _log.error((Object)throwable.getMessage());
                    return portalInstanceLifecycleListener;
                }
            }
            try {
                PortalInstanceLifecycleListenerManagerImpl.this._companyLocalService.forEachCompany(company -> {
                    try {
                        TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, () -> {
                            PortalInstanceLifecycleListenerManagerImpl.this.preregisterCompany(portalInstanceLifecycleListener, (Company)company);
                            PortalInstanceLifecycleListenerManagerImpl.this.registerCompany(portalInstanceLifecycleListener, (Company)company);
                            return null;
                        });
                    }
                    catch (Throwable throwable) {
                        throw new Exception(throwable);
                    }
                }, new ArrayList(PortalInstanceLifecycleListenerManagerImpl.this._companies));
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
                return portalInstanceLifecycleListener;
            }
            return portalInstanceLifecycleListener;
        }

        public void modifiedService(ServiceReference<PortalInstanceLifecycleListener> serviceReference, PortalInstanceLifecycleListener portalInstanceLifecycleListener) {
        }

        public void removedService(ServiceReference<PortalInstanceLifecycleListener> serviceReference, PortalInstanceLifecycleListener portalInstanceLifecycleListener) {
            PortalInstanceLifecycleListenerManagerImpl.this._bundleContext.ungetService(serviceReference);
        }
    }
}

