/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.instance.lifecycle.internal;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.instance.lifecycle.Clusterable;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutor;
import com.liferay.portal.kernel.instance.lifecycle.PortalInstanceLifecycleManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Transactional(propagation=Propagation.REQUIRED)
@Component(service={AopService.class})
public class PortalInstanceLifecycleListenerManagerImpl
implements AopService,
PortalInstanceLifecycleManager {
    @Reference
    protected ClusterMasterExecutor clusterMasterExecutor;
    private static final Log _log = LogFactoryUtil.getLog(PortalInstanceLifecycleListenerManagerImpl.class);
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRED, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    private BundleContext _bundleContext;
    private final Set<Company> _companies = new CopyOnWriteArraySet<Company>();
    @Reference
    private CompanyLocalService _companyLocalService;
    private ServiceTrackerList<PortalInstanceLifecycleListener> _serviceTrackerList;

    public void preregisterCompany(Company company) {
        for (PortalInstanceLifecycleListener portalInstanceLifecycleListener : this._serviceTrackerList) {
            this.preregisterCompany(portalInstanceLifecycleListener, company);
        }
    }

    public void preunregisterCompany(Company company) {
        for (PortalInstanceLifecycleListener portalInstanceLifecycleListener : this._serviceTrackerList) {
            this.preunregisterCompany(portalInstanceLifecycleListener, company);
        }
    }

    public void registerCompany(Company company) {
        this._companies.add(company);
        for (PortalInstanceLifecycleListener portalInstanceLifecycleListener : this._serviceTrackerList) {
            this.registerCompany(portalInstanceLifecycleListener, company);
        }
    }

    public void unregisterCompany(Company company) {
        this._companies.remove(company);
        for (PortalInstanceLifecycleListener portalInstanceLifecycleListener : this._serviceTrackerList) {
            this.unregisterCompany(portalInstanceLifecycleListener, company);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, PortalInstanceLifecycleListener.class, null, (ServiceTrackerCustomizer)new PortalInstanceLifecycleListenerServiceTrackerCustomizer());
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerList.close();
    }

    protected void preregisterCompany(PortalInstanceLifecycleListener portalInstanceLifecycleListener, Company company) {
        block4: {
            if (!(portalInstanceLifecycleListener instanceof Clusterable) && !this.clusterMasterExecutor.isMaster()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Skipping " + portalInstanceLifecycleListener));
                }
                return;
            }
            try {
                portalInstanceLifecycleListener.portalInstancePreregistered(company);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)("Unable to preregister portal instance " + company), (Throwable)exception);
            }
        }
    }

    protected void preunregisterCompany(PortalInstanceLifecycleListener portalInstanceLifecycleListener, Company company) {
        block4: {
            if (!(portalInstanceLifecycleListener instanceof Clusterable) && !this.clusterMasterExecutor.isMaster()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Skipping " + portalInstanceLifecycleListener));
                }
                return;
            }
            try {
                portalInstanceLifecycleListener.portalInstancePreunregistered(company);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)("Unable to preunregister portal instance " + company), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerCompany(PortalInstanceLifecycleListener portalInstanceLifecycleListener, Company company) {
        if (!(portalInstanceLifecycleListener instanceof Clusterable) && !this.clusterMasterExecutor.isMaster()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping " + portalInstanceLifecycleListener));
            }
            return;
        }
        Long companyId = CompanyThreadLocal.getCompanyId();
        Locale siteDefaultLocale = LocaleThreadLocal.getSiteDefaultLocale();
        try (SafeCloseable safeCloseable = CompanyThreadLocal.setInitializingPortalInstance((boolean)true);){
            CompanyThreadLocal.setCompanyId((Long)company.getCompanyId());
            LocaleThreadLocal.setSiteDefaultLocale(null);
            portalInstanceLifecycleListener.portalInstanceRegistered(company);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to register portal instance " + company), (Throwable)exception);
            }
        }
        finally {
            CompanyThreadLocal.setCompanyId((Long)companyId);
            LocaleThreadLocal.setSiteDefaultLocale((Locale)siteDefaultLocale);
        }
    }

    protected void unregisterCompany(PortalInstanceLifecycleListener portalInstanceLifecycleListener, Company company) {
        block4: {
            if (!(portalInstanceLifecycleListener instanceof Clusterable) && !this.clusterMasterExecutor.isMaster()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Skipping " + portalInstanceLifecycleListener));
                }
                return;
            }
            try {
                portalInstanceLifecycleListener.portalInstanceUnregistered(company);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)("Unable to unregister portal instance " + company), (Throwable)exception);
            }
        }
    }

    private class PortalInstanceLifecycleListenerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<PortalInstanceLifecycleListener, PortalInstanceLifecycleListener> {
        private PortalInstanceLifecycleListenerServiceTrackerCustomizer() {
        }

        public PortalInstanceLifecycleListener addingService(ServiceReference<PortalInstanceLifecycleListener> serviceReference) {
            PortalInstanceLifecycleListener portalInstanceLifecycleListener = (PortalInstanceLifecycleListener)PortalInstanceLifecycleListenerManagerImpl.this._bundleContext.getService(serviceReference);
            if (PortalInstanceLifecycleListenerManagerImpl.this._companies.isEmpty()) {
                return portalInstanceLifecycleListener;
            }
            for (Company company2 : PortalInstanceLifecycleListenerManagerImpl.this._companies) {
                Company fetchedCompany = PortalInstanceLifecycleListenerManagerImpl.this._companyLocalService.fetchCompanyById(company2.getCompanyId());
                if (fetchedCompany != null) continue;
                try {
                    TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, () -> {
                        PortalInstanceLifecycleListenerManagerImpl.this.unregisterCompany(company2);
                        return null;
                    });
                }
                catch (Throwable throwable) {
                    _log.error((Object)throwable.getMessage());
                    return portalInstanceLifecycleListener;
                }
            }
            try {
                PortalInstanceLifecycleListenerManagerImpl.this._companyLocalService.forEachCompany(company -> {
                    try {
                        TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, () -> {
                            PortalInstanceLifecycleListenerManagerImpl.this.preregisterCompany(portalInstanceLifecycleListener, (Company)company);
                            PortalInstanceLifecycleListenerManagerImpl.this.registerCompany(portalInstanceLifecycleListener, (Company)company);
                            return null;
                        });
                    }
                    catch (Throwable throwable) {
                        throw new Exception(throwable);
                    }
                }, new ArrayList(PortalInstanceLifecycleListenerManagerImpl.this._companies));
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
                return portalInstanceLifecycleListener;
            }
            return portalInstanceLifecycleListener;
        }

        public void modifiedService(ServiceReference<PortalInstanceLifecycleListener> serviceReference, PortalInstanceLifecycleListener portalInstanceLifecycleListener) {
        }

        public void removedService(ServiceReference<PortalInstanceLifecycleListener> serviceReference, PortalInstanceLifecycleListener portalInstanceLifecycleListener) {
            PortalInstanceLifecycleListenerManagerImpl.this._bundleContext.ungetService(serviceReference);
            if (!(portalInstanceLifecycleListener instanceof Clusterable) && !PortalInstanceLifecycleListenerManagerImpl.this.clusterMasterExecutor.isMaster() && _log.isDebugEnabled()) {
                _log.debug((Object)("Skipping " + portalInstanceLifecycleListener));
            }
        }
    }
}

