/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.instance.lifecycle.internal;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.instance.lifecycle.Clusterable;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutor;
import com.liferay.portal.kernel.instance.lifecycle.PortalInstanceLifecycleManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Transactional(propagation=Propagation.REQUIRED)
@Component(immediate=true, service={AopService.class})
public class PortalInstanceLifecycleListenerManagerImpl
implements AopService,
PortalInstanceLifecycleManager {
    @Reference
    protected ClusterMasterExecutor clusterMasterExecutor;
    private static final Log _log = LogFactoryUtil.getLog(PortalInstanceLifecycleListenerManagerImpl.class);
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRED, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    private final Set<Company> _companies = new CopyOnWriteArraySet<Company>();
    @Reference
    private CompanyLocalService _companyLocalService;
    private final Set<PortalInstanceLifecycleListener> _portalInstanceLifecycleListeners = new CopyOnWriteArraySet<PortalInstanceLifecycleListener>();

    public void preunregisterCompany(Company company) {
        for (PortalInstanceLifecycleListener portalInstanceLifecycleListener : this._portalInstanceLifecycleListeners) {
            this.preunregisterCompany(portalInstanceLifecycleListener, company);
        }
    }

    public void registerCompany(Company company) {
        this._companies.add(company);
        for (PortalInstanceLifecycleListener portalInstanceLifecycleListener : this._portalInstanceLifecycleListeners) {
            this.registerCompany(portalInstanceLifecycleListener, company);
        }
    }

    public void unregisterCompany(Company company) {
        this._companies.remove(company);
        for (PortalInstanceLifecycleListener portalInstanceLifecycleListener : this._portalInstanceLifecycleListeners) {
            this.unregisterCompany(portalInstanceLifecycleListener, company);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addPortalInstanceLifecycleListener(PortalInstanceLifecycleListener portalInstanceLifecycleListener) throws Throwable {
        this._portalInstanceLifecycleListeners.add(portalInstanceLifecycleListener);
        if (this._companies.isEmpty()) {
            return;
        }
        for (Company company2 : this._companies) {
            Company fetchedCompany = this._companyLocalService.fetchCompanyById(company2.getCompanyId());
            if (fetchedCompany != null) continue;
            TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, () -> {
                this.unregisterCompany(company2);
                return null;
            });
        }
        this._companyLocalService.forEachCompany(company -> {
            try {
                TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, () -> {
                    this.registerCompany(portalInstanceLifecycleListener, (Company)company);
                    return null;
                });
            }
            catch (Throwable throwable) {
                throw new Exception(throwable);
            }
        }, new ArrayList<Company>(this._companies));
    }

    protected void preunregisterCompany(PortalInstanceLifecycleListener portalInstanceLifecycleListener, Company company) {
        block4: {
            if (!(portalInstanceLifecycleListener instanceof Clusterable) && !this.clusterMasterExecutor.isMaster()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Skipping " + portalInstanceLifecycleListener));
                }
                return;
            }
            try {
                portalInstanceLifecycleListener.portalInstancePreunregistered(company);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)("Unable to preunregister portal instance " + company), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerCompany(PortalInstanceLifecycleListener portalInstanceLifecycleListener, Company company) {
        if (!(portalInstanceLifecycleListener instanceof Clusterable) && !this.clusterMasterExecutor.isMaster()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping " + portalInstanceLifecycleListener));
            }
            return;
        }
        Long companyId = CompanyThreadLocal.getCompanyId();
        Locale siteDefaultLocale = LocaleThreadLocal.getSiteDefaultLocale();
        try (SafeCloseable safeCloseable = CompanyThreadLocal.setInitializingPortalInstance((boolean)true);){
            CompanyThreadLocal.setCompanyId((Long)company.getCompanyId());
            LocaleThreadLocal.setSiteDefaultLocale(null);
            portalInstanceLifecycleListener.portalInstanceRegistered(company);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to register portal instance " + company), (Throwable)exception);
            }
        }
        finally {
            CompanyThreadLocal.setCompanyId((Long)companyId);
            LocaleThreadLocal.setSiteDefaultLocale((Locale)siteDefaultLocale);
        }
    }

    protected void removePortalInstanceLifecycleListener(PortalInstanceLifecycleListener portalInstanceLifecycleListener) {
        if (!(portalInstanceLifecycleListener instanceof Clusterable) && !this.clusterMasterExecutor.isMaster()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping " + portalInstanceLifecycleListener));
            }
            return;
        }
        this._portalInstanceLifecycleListeners.remove(portalInstanceLifecycleListener);
    }

    protected void unregisterCompany(PortalInstanceLifecycleListener portalInstanceLifecycleListener, Company company) {
        block4: {
            if (!(portalInstanceLifecycleListener instanceof Clusterable) && !this.clusterMasterExecutor.isMaster()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Skipping " + portalInstanceLifecycleListener));
                }
                return;
            }
            try {
                portalInstanceLifecycleListener.portalInstanceUnregistered(company);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)("Unable to unregister portal instance " + company), (Throwable)exception);
            }
        }
    }
}

