/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.instance.lifecycle.internal;

import com.liferay.portal.instance.lifecycle.Clusterable;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutor;
import com.liferay.portal.kernel.instance.lifecycle.PortalInstanceLifecycleManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={PortalInstanceLifecycleManager.class})
public class PortalInstanceLifecycleListenerManagerImpl
implements PortalInstanceLifecycleManager {
    @Reference
    protected ClusterMasterExecutor clusterMasterExecutor;
    private static final Log _log = LogFactoryUtil.getLog(PortalInstanceLifecycleListenerManagerImpl.class);
    private final Set<Company> _companies = new CopyOnWriteArraySet<Company>();
    private final Set<PortalInstanceLifecycleListener> _portalInstanceLifecycleListeners = new CopyOnWriteArraySet<PortalInstanceLifecycleListener>();

    public void preunregisterCompany(Company company) {
        for (PortalInstanceLifecycleListener portalInstanceLifecycleListener : this._portalInstanceLifecycleListeners) {
            this.preunregisterCompany(portalInstanceLifecycleListener, company);
        }
    }

    public void registerCompany(Company company) {
        this._companies.add(company);
        for (PortalInstanceLifecycleListener portalInstanceLifecycleListener : this._portalInstanceLifecycleListeners) {
            this.registerCompany(portalInstanceLifecycleListener, company);
        }
    }

    public void unregisterCompany(Company company) {
        this._companies.remove(company);
        for (PortalInstanceLifecycleListener portalInstanceLifecycleListener : this._portalInstanceLifecycleListeners) {
            this.unregisterCompany(portalInstanceLifecycleListener, company);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addPortalInstanceLifecycleListener(PortalInstanceLifecycleListener portalInstanceLifecycleListener) {
        this._portalInstanceLifecycleListeners.add(portalInstanceLifecycleListener);
        if (this._companies.isEmpty()) {
            return;
        }
        for (Company company : this._companies) {
            this.registerCompany(portalInstanceLifecycleListener, company);
        }
    }

    protected void preunregisterCompany(PortalInstanceLifecycleListener portalInstanceLifecycleListener, Company company) {
        block4: {
            if (!(portalInstanceLifecycleListener instanceof Clusterable) && !this.clusterMasterExecutor.isMaster()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Skipping " + portalInstanceLifecycleListener));
                }
                return;
            }
            try {
                portalInstanceLifecycleListener.portalInstancePreunregistered(company);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)("Unable to preunregister portal instance " + company), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerCompany(PortalInstanceLifecycleListener portalInstanceLifecycleListener, Company company) {
        if (!(portalInstanceLifecycleListener instanceof Clusterable) && !this.clusterMasterExecutor.isMaster()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping " + portalInstanceLifecycleListener));
            }
            return;
        }
        Long companyId = CompanyThreadLocal.getCompanyId();
        Locale siteDefaultLocale = LocaleThreadLocal.getSiteDefaultLocale();
        try {
            CompanyThreadLocal.setCompanyId((Long)company.getCompanyId());
            LocaleThreadLocal.setSiteDefaultLocale(null);
            portalInstanceLifecycleListener.portalInstanceRegistered(company);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to register portal instance " + company), (Throwable)e);
            }
        }
        finally {
            CompanyThreadLocal.setCompanyId((Long)companyId);
            LocaleThreadLocal.setSiteDefaultLocale((Locale)siteDefaultLocale);
        }
    }

    protected void removePortalInstanceLifecycleListener(PortalInstanceLifecycleListener portalInstanceLifecycleListener) {
        if (!(portalInstanceLifecycleListener instanceof Clusterable) && !this.clusterMasterExecutor.isMaster()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping " + portalInstanceLifecycleListener));
            }
            return;
        }
        this._portalInstanceLifecycleListeners.remove(portalInstanceLifecycleListener);
    }

    protected void unregisterCompany(PortalInstanceLifecycleListener portalInstanceLifecycleListener, Company company) {
        block4: {
            if (!(portalInstanceLifecycleListener instanceof Clusterable) && !this.clusterMasterExecutor.isMaster()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Skipping " + portalInstanceLifecycleListener));
                }
                return;
            }
            try {
                portalInstanceLifecycleListener.portalInstanceUnregistered(company);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)("Unable to unregister portal instance " + company), (Throwable)e);
            }
        }
    }
}

