/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.info.item.provider.util;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.field.type.ActionInfoFieldType;
import com.liferay.info.field.type.ImageInfoFieldType;
import com.liferay.info.field.type.InfoFieldType;
import com.liferay.info.field.type.TextInfoFieldType;
import com.liferay.info.field.type.URLInfoFieldType;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.info.type.KeyLocalizedLabelPair;
import com.liferay.info.type.WebImage;
import com.liferay.list.type.model.ListTypeEntry;
import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.object.field.util.ObjectFieldUtil;
import com.liferay.object.info.field.converter.ObjectFieldInfoFieldConverter;
import com.liferay.object.info.field.type.util.ObjectFieldInfoFieldTypeUtil;
import com.liferay.object.info.item.ObjectEntryInfoItemFields;
import com.liferay.object.info.item.util.ObjectEntryInfoItemUtil;
import com.liferay.object.model.ObjectAction;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.rest.dto.v1_0.FileEntry;
import com.liferay.object.rest.dto.v1_0.ListEntry;
import com.liferay.object.rest.dto.v1_0.ObjectEntry;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManagerRegistry;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectActionLocalService;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class ObjectEntryInfoItemValuesProviderUtil {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryInfoItemValuesProviderUtil.class);

    public static InfoLocalizedValue<?> getFriendlyURLInfoFieldValue(long classNameId, FriendlyURLEntryLocalService friendlyURLEntryLocalService, long objectEntryId) {
        try {
            FriendlyURLEntry friendlyURLEntry = friendlyURLEntryLocalService.getMainFriendlyURLEntry(classNameId, objectEntryId);
            if (friendlyURLEntry == null) {
                return null;
            }
            return InfoLocalizedValue.function(locale -> friendlyURLEntry.getUrlTitle(LocaleUtil.toLanguageId((Locale)locale)));
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return null;
        }
    }

    public static List<InfoFieldValue<Object>> getInfoFieldValues(DLAppLocalService dlAppLocalService, DLURLHelper dlURLHelper, FriendlyURLEntryLocalService friendlyURLEntryLocalService, ListTypeEntryLocalService listTypeEntryLocalService, ObjectActionLocalService objectActionLocalService, ObjectDefinition objectDefinition, ObjectDefinitionLocalService objectDefinitionLocalService, ObjectEntryLocalService objectEntryLocalService, ObjectEntryManagerRegistry objectEntryManagerRegistry, ObjectFieldInfoFieldConverter objectFieldInfoFieldConverter, ObjectFieldLocalService objectFieldLocalService, List<ObjectField> objectFields, ObjectRelationshipLocalService objectRelationshipLocalService, ObjectScopeProviderRegistry objectScopeProviderRegistry, Portal portal, ThemeDisplay themeDisplay, Map<String, Object> values) throws Exception {
        ArrayList<InfoFieldValue<Object>> infoFieldValues = new ArrayList<InfoFieldValue<Object>>();
        for (ObjectField objectField : objectFields) {
            if (objectField.isMetadata()) continue;
            Object value = values.get(objectField.getName());
            if (objectField.isLocalized()) {
                value = values.get(objectField.getI18nObjectFieldName());
            }
            ObjectEntryInfoItemValuesProviderUtil._addInfoFieldValue(dlAppLocalService, dlURLHelper, infoFieldValues, listTypeEntryLocalService, objectEntryLocalService, objectField, objectFieldInfoFieldConverter, ObjectField.class.getSimpleName(), objectRelationshipLocalService, themeDisplay, value);
            if (!objectField.compareBusinessType("Relationship")) continue;
            Map properties = new HashMap();
            ObjectRelationship objectRelationship = objectRelationshipLocalService.fetchObjectRelationshipByObjectFieldId2(objectField.getObjectFieldId());
            ObjectDefinition parentObjectDefinition = objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId1());
            ObjectEntry objectEntry = ObjectEntryInfoItemUtil.getObjectEntry(parentObjectDefinition, objectEntryManagerRegistry, objectScopeProviderRegistry, objectEntryLocalService.fetchObjectEntry(GetterUtil.getLong((Object)values.get(objectField.getName()))), themeDisplay);
            if (objectEntry != null) {
                properties = objectEntry.getProperties();
            }
            for (ObjectField relatedObjectField : objectFieldLocalService.getObjectFields(parentObjectDefinition.getObjectDefinitionId(), false)) {
                String namespace = ObjectEntryInfoItemUtil.getInfoFieldNamespace(parentObjectDefinition, objectRelationship);
                value = properties.get(relatedObjectField.getName());
                if (relatedObjectField.isLocalized()) {
                    value = properties.get(relatedObjectField.getI18nObjectFieldName());
                }
                ObjectEntryInfoItemValuesProviderUtil._addInfoFieldValue(dlAppLocalService, dlURLHelper, infoFieldValues, listTypeEntryLocalService, objectEntryLocalService, relatedObjectField, objectFieldInfoFieldConverter, namespace, objectRelationshipLocalService, themeDisplay, value);
                infoFieldValues.add((InfoFieldValue<Object>)new InfoFieldValue(ObjectEntryInfoItemFields.getFriendlyURLInfoField(parentObjectDefinition.isEnableFriendlyURLCustomization(), objectRelationship.getName(), namespace), () -> {
                    if (objectEntry == null) {
                        return null;
                    }
                    return ObjectEntryInfoItemValuesProviderUtil.getFriendlyURLInfoFieldValue(portal.getClassNameId(parentObjectDefinition.getClassName()), friendlyURLEntryLocalService, GetterUtil.getLong(values.get(objectField.getName())));
                }));
            }
        }
        if (!objectDefinition.isDefaultStorageType()) {
            return infoFieldValues;
        }
        infoFieldValues.addAll(TransformUtil.transform((Collection)objectActionLocalService.getObjectActions(objectDefinition.getObjectDefinitionId(), "standalone"), objectAction -> {
            InfoLocalizedValue actionLabelLocalizedValue = InfoLocalizedValue.builder().defaultLocale(LocaleUtil.fromLanguageId((String)objectAction.getDefaultLanguageId())).values(objectAction.getLabelMap()).build();
            return new InfoFieldValue(InfoField.builder().infoFieldType((InfoFieldType)ActionInfoFieldType.INSTANCE).namespace(ObjectAction.class.getSimpleName()).name(objectAction.getName()).labelInfoLocalizedValue(actionLabelLocalizedValue).build(), (Object)actionLabelLocalizedValue);
        }));
        return infoFieldValues;
    }

    private static void _addInfoFieldValue(DLAppLocalService dlAppLocalService, DLURLHelper dlURLHelper, List<InfoFieldValue<Object>> infoFieldValues, ListTypeEntryLocalService listTypeEntryLocalService, ObjectEntryLocalService objectEntryLocalService, ObjectField objectField, ObjectFieldInfoFieldConverter objectFieldInfoFieldConverter, String objectFieldNamespace, ObjectRelationshipLocalService objectRelationshipLocalService, ThemeDisplay themeDisplay, Object value) throws Exception {
        Object infoFieldValue;
        block12: {
            if (value == null) {
                infoFieldValues.add((InfoFieldValue<Object>)new InfoFieldValue(objectFieldInfoFieldConverter.getInfoField(false, objectFieldNamespace, objectField), (Object)""));
                return;
            }
            infoFieldValue = null;
            Locale locale = LocaleUtil.getSiteDefault();
            if (themeDisplay != null) {
                locale = themeDisplay.getLocale();
            }
            if (objectField.isLocalized() && value instanceof Map) {
                Map map = (Map)value;
                infoFieldValue = InfoLocalizedValue.builder().defaultLocale(LocaleUtil.fromLanguageId((String)objectField.getDefaultLanguageId())).value(consumer -> {
                    for (Map.Entry entry : map.entrySet()) {
                        Locale curLocale = LocaleUtil.fromLanguageId((String)((String)entry.getKey()));
                        consumer.accept((Object)curLocale, ObjectEntryInfoItemValuesProviderUtil._parseValue(listTypeEntryLocalService, curLocale, objectEntryLocalService, objectField, objectRelationshipLocalService, entry.getValue()));
                    }
                }).build();
            } else {
                infoFieldValue = ObjectEntryInfoItemValuesProviderUtil._parseValue(listTypeEntryLocalService, locale, objectEntryLocalService, objectField, objectRelationshipLocalService, value);
            }
            if (infoFieldValue == null) {
                infoFieldValues.add((InfoFieldValue<Object>)new InfoFieldValue(objectFieldInfoFieldConverter.getInfoField(false, objectFieldNamespace, objectField), (Object)""));
                return;
            }
            if (objectField.compareBusinessType("Attachment")) {
                try {
                    String downloadURLInfoFieldValue = null;
                    String fileNameInfoFieldValue = null;
                    String mimeTypeInfoFieldValue = null;
                    String previewURLInfoFieldValue = null;
                    Long sizeInfoFieldValue = null;
                    if (infoFieldValue instanceof Long) {
                        Long fileEntryId = (Long)infoFieldValue;
                        com.liferay.portal.kernel.repository.model.FileEntry fileEntry = dlAppLocalService.getFileEntry(GetterUtil.getLong((Object)fileEntryId));
                        downloadURLInfoFieldValue = dlURLHelper.getDownloadURL(fileEntry, fileEntry.getFileVersion(), null, "");
                        fileNameInfoFieldValue = fileEntry.getFileName();
                        mimeTypeInfoFieldValue = fileEntry.getMimeType();
                        previewURLInfoFieldValue = dlURLHelper.getPreviewURL(fileEntry, fileEntry.getFileVersion(), null, "");
                        sizeInfoFieldValue = fileEntry.getSize();
                    } else if (infoFieldValue instanceof InfoLocalizedValue) {
                        InfoLocalizedValue infoLocalizedValue = (InfoLocalizedValue)infoFieldValue;
                        InfoLocalizedValue.Builder downloadURLInfoFieldValueBuilder = InfoLocalizedValue.builder();
                        InfoLocalizedValue.Builder fileNameInfoFieldValueBuilder = InfoLocalizedValue.builder();
                        InfoLocalizedValue.Builder mimeTypeInfoFieldValueBuilder = InfoLocalizedValue.builder();
                        InfoLocalizedValue.Builder previewURLInfoFieldValueBuilder = InfoLocalizedValue.builder();
                        InfoLocalizedValue.Builder sizeInfoFieldValueBuilder = InfoLocalizedValue.builder();
                        Map values = infoLocalizedValue.getValues();
                        for (Map.Entry entry : values.entrySet()) {
                            Long fileEntryId = (Long)entry.getValue();
                            com.liferay.portal.kernel.repository.model.FileEntry fileEntry = dlAppLocalService.getFileEntry(GetterUtil.getLong((Object)fileEntryId));
                            downloadURLInfoFieldValueBuilder.value((Locale)entry.getKey(), (Object)dlURLHelper.getDownloadURL(fileEntry, fileEntry.getFileVersion(), null, ""));
                            fileNameInfoFieldValueBuilder.value((Locale)entry.getKey(), (Object)fileEntry.getFileName());
                            mimeTypeInfoFieldValueBuilder.value((Locale)entry.getKey(), (Object)fileEntry.getMimeType());
                            previewURLInfoFieldValueBuilder.value((Locale)entry.getKey(), (Object)dlURLHelper.getPreviewURL(fileEntry, fileEntry.getFileVersion(), null, ""));
                            sizeInfoFieldValueBuilder.value((Locale)entry.getKey(), (Object)fileEntry.getSize());
                        }
                        downloadURLInfoFieldValue = downloadURLInfoFieldValueBuilder.build();
                        fileNameInfoFieldValue = fileNameInfoFieldValueBuilder.build();
                        mimeTypeInfoFieldValue = mimeTypeInfoFieldValueBuilder.build();
                        previewURLInfoFieldValue = previewURLInfoFieldValueBuilder.build();
                        sizeInfoFieldValue = sizeInfoFieldValueBuilder.build();
                    }
                    infoFieldValues.add((InfoFieldValue<Object>)new InfoFieldValue(InfoField.builder().infoFieldType((InfoFieldType)URLInfoFieldType.INSTANCE).namespace(objectFieldNamespace).name(objectField.getObjectFieldId() + "#downloadURL").labelInfoLocalizedValue(InfoLocalizedValue.localize(ObjectEntryInfoItemFields.class, (String)"download-url")).build(), (Object)downloadURLInfoFieldValue));
                    infoFieldValues.add((InfoFieldValue<Object>)new InfoFieldValue(InfoField.builder().infoFieldType((InfoFieldType)TextInfoFieldType.INSTANCE).namespace(objectFieldNamespace).name(objectField.getObjectFieldId() + "#fileName").labelInfoLocalizedValue(InfoLocalizedValue.localize(ObjectEntryInfoItemFields.class, (String)"file-name")).build(), (Object)fileNameInfoFieldValue));
                    infoFieldValues.add((InfoFieldValue<Object>)new InfoFieldValue(InfoField.builder().infoFieldType((InfoFieldType)TextInfoFieldType.INSTANCE).namespace(objectFieldNamespace).name(objectField.getObjectFieldId() + "#mimeType").labelInfoLocalizedValue(InfoLocalizedValue.localize(ObjectEntryInfoItemFields.class, (String)"mime-type")).build(), (Object)mimeTypeInfoFieldValue));
                    infoFieldValues.add((InfoFieldValue<Object>)new InfoFieldValue(InfoField.builder().infoFieldType((InfoFieldType)ImageInfoFieldType.INSTANCE).namespace(objectFieldNamespace).name(objectField.getObjectFieldId() + "#previewURL").labelInfoLocalizedValue(InfoLocalizedValue.localize(ObjectEntryInfoItemFields.class, (String)"preview-url")).build(), (Object)previewURLInfoFieldValue));
                    infoFieldValues.add((InfoFieldValue<Object>)new InfoFieldValue(InfoField.builder().infoFieldType((InfoFieldType)TextInfoFieldType.INSTANCE).namespace(objectFieldNamespace).name(objectField.getObjectFieldId() + "#size").labelInfoLocalizedValue(InfoLocalizedValue.localize(ObjectEntryInfoItemFields.class, (String)"size")).build(), (Object)sizeInfoFieldValue));
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block12;
                    _log.debug((Throwable)exception);
                }
            }
        }
        infoFieldValues.add((InfoFieldValue<Object>)new InfoFieldValue(objectFieldInfoFieldConverter.getInfoField(false, objectFieldNamespace, objectField), GetterUtil.getObject((Object)infoFieldValue, (Object)"")));
    }

    private static KeyLocalizedLabelPair _getKeyLocalizedLabelPair(ListTypeEntryLocalService listTypeEntryLocalService, Object object, ObjectField objectField) {
        String key = null;
        if (object instanceof ListEntry) {
            ListEntry listEntry = (ListEntry)object;
            key = listEntry.getKey();
        } else {
            key = object instanceof Map ? MapUtil.getString((Map)((Map)object), (Object)"key") : GetterUtil.getString((Object)object);
        }
        ListTypeEntry listTypeEntry = listTypeEntryLocalService.fetchListTypeEntry(objectField.getListTypeDefinitionId(), key);
        if (listTypeEntry == null) {
            return null;
        }
        return new KeyLocalizedLabelPair(listTypeEntry.getKey(), InfoLocalizedValue.builder().defaultLocale(LocaleUtil.fromLanguageId((String)listTypeEntry.getDefaultLanguageId())).values(listTypeEntry.getNameMap()).build());
    }

    private static Object _parseValue(ListTypeEntryLocalService listTypeEntryLocalService, Locale locale, ObjectEntryLocalService objectEntryLocalService, ObjectField objectField, ObjectRelationshipLocalService objectRelationshipLocalService, Object value) {
        block22: {
            if (value == null) {
                return null;
            }
            if (Objects.equals(ObjectFieldInfoFieldTypeUtil.getInfoFieldType(objectField), ImageInfoFieldType.INSTANCE)) {
                try {
                    JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)new String((byte[])value));
                    WebImage webImage = new WebImage(jsonObject.getString("url"));
                    webImage.setAlt(jsonObject.getString("alt"));
                    return webImage;
                }
                catch (Exception exception) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Throwable)exception);
                        return null;
                    }
                    break block22;
                }
            }
            if (objectField.compareBusinessType("Attachment")) {
                if (value instanceof Long) {
                    return value;
                }
                FileEntry dtoFileEntry = (FileEntry)value;
                return dtoFileEntry.getId();
            }
            if (objectField.compareBusinessType("Date")) {
                try {
                    return DateUtil.parseDate((String)"yyyy-MM-dd", (String)value.toString(), (Locale)locale);
                }
                catch (Exception exception) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Throwable)exception);
                        return null;
                    }
                    break block22;
                }
            }
            if (objectField.compareBusinessType("DateTime")) {
                return LocalDateTime.parse(value.toString(), DateTimeFormatter.ofPattern(ObjectFieldUtil.getDateTimePattern((String)value.toString())));
            }
            if (objectField.compareBusinessType("MultiselectPicklist")) {
                ArrayList<KeyLocalizedLabelPair> keyLocalizedLabelPairs = new ArrayList<KeyLocalizedLabelPair>();
                List objects = new ArrayList();
                objects = value instanceof String ? ListUtil.fromArray((Object[])StringUtil.split((String)((String)value), (String)", ")) : (List)value;
                for (Object object : objects) {
                    KeyLocalizedLabelPair keyLocalizedLabelPair = ObjectEntryInfoItemValuesProviderUtil._getKeyLocalizedLabelPair(listTypeEntryLocalService, object, objectField);
                    if (keyLocalizedLabelPair == null) continue;
                    keyLocalizedLabelPairs.add(keyLocalizedLabelPair);
                }
                if (ListUtil.isNotEmpty(keyLocalizedLabelPairs)) {
                    return keyLocalizedLabelPairs;
                }
            } else if (objectField.compareBusinessType("Picklist")) {
                KeyLocalizedLabelPair keyLocalizedLabelPair = ObjectEntryInfoItemValuesProviderUtil._getKeyLocalizedLabelPair(listTypeEntryLocalService, value, objectField);
                if (keyLocalizedLabelPair != null) {
                    return ListUtil.fromArray((Object[])new KeyLocalizedLabelPair[]{keyLocalizedLabelPair});
                }
            } else if (objectField.compareBusinessType("Relationship")) {
                ObjectRelationship objectRelationship = objectRelationshipLocalService.fetchObjectRelationshipByObjectFieldId2(objectField.getObjectFieldId());
                try {
                    return new KeyValuePair(String.valueOf(value), objectEntryLocalService.getTitleValue(objectRelationship.getObjectDefinitionId1(), GetterUtil.getLong((Object)value)));
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block22;
                    _log.debug((Throwable)exception);
                    return null;
                }
            }
        }
        return value;
    }
}

