/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.info.item.util;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryVersion;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManagerRegistry;
import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectEntryVersionLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;

public class ObjectEntryInfoItemUtil {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryInfoItemUtil.class);

    public static String getInfoFieldNamespace(ObjectDefinition objectDefinition, ObjectRelationship objectRelationship) {
        return StringBundler.concat((String[])new String[]{ObjectRelationship.class.getSimpleName(), "#", objectDefinition.getName(), "#", objectRelationship.getName()});
    }

    public static com.liferay.object.rest.dto.v1_0.ObjectEntry getObjectEntry(ObjectDefinition objectDefinition, ObjectEntryManagerRegistry objectEntryManagerRegistry, ObjectScopeProviderRegistry objectScopeProviderRegistry, ObjectEntry serviceBuilderObjectEntry, ThemeDisplay themeDisplay) {
        if (serviceBuilderObjectEntry == null || themeDisplay == null) {
            return null;
        }
        ObjectEntryManager objectEntryManager = objectEntryManagerRegistry.getObjectEntryManager(objectDefinition.getStorageType());
        DefaultDTOConverterContext dtoConverterContext = new DefaultDTOConverterContext(false, null, null, null, null, themeDisplay.getLocale(), null, themeDisplay.getUser());
        ObjectEntryVersion objectEntryVersion = ObjectEntryVersionLocalServiceUtil.fetchObjectEntryVersion((long)serviceBuilderObjectEntry.getObjectEntryId(), (int)serviceBuilderObjectEntry.getVersion());
        if (objectEntryVersion != null) {
            dtoConverterContext.setAttribute("objectEntryVersion", (Object)objectEntryVersion);
        }
        try {
            return objectEntryManager.getObjectEntry(themeDisplay.getCompanyId(), (DTOConverterContext)dtoConverterContext, serviceBuilderObjectEntry.getExternalReferenceCode(), objectDefinition, ObjectEntryInfoItemUtil.getScopeKey(serviceBuilderObjectEntry.getGroupId(), objectDefinition, objectScopeProviderRegistry));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return null;
        }
    }

    public static String getScopeKey(long groupId, ObjectDefinition objectDefinition, ObjectScopeProviderRegistry objectScopeProviderRegistry) {
        ObjectScopeProvider objectScopeProvider = objectScopeProviderRegistry.getObjectScopeProvider(objectDefinition.getScope());
        if (!objectScopeProvider.isGroupAware()) {
            return null;
        }
        Group group = GroupLocalServiceUtil.fetchGroup((long)groupId);
        if (group == null) {
            return null;
        }
        return group.getGroupKey();
    }

    public static ThemeDisplay getThemeDisplay() throws Exception {
        final ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return null;
        }
        ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
        if (themeDisplay != null) {
            return themeDisplay;
        }
        return new ThemeDisplay(){
            {
                this.setCompany(CompanyLocalServiceUtil.getCompany((long)serviceContext.getCompanyId()));
                this.setLocale(LocaleUtil.fromLanguageId((String)serviceContext.getLanguageId()));
                this.setSiteGroupId(serviceContext.getScopeGroupId());
                this.setUser(this.getUser());
            }
        };
    }

    public static User getUser() {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return null;
        }
        ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
        if (themeDisplay != null) {
            return themeDisplay.getUser();
        }
        User user = UserLocalServiceUtil.fetchUser((long)serviceContext.getUserId());
        if (user == null) {
            user = UserLocalServiceUtil.fetchGuestUser((long)serviceContext.getCompanyId());
        }
        return user;
    }
}

