/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.info.field.converter;

import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.info.field.InfoField;
import com.liferay.info.field.type.FileInfoFieldType;
import com.liferay.info.field.type.LongTextInfoFieldType;
import com.liferay.info.field.type.MultiselectInfoFieldType;
import com.liferay.info.field.type.NumberInfoFieldType;
import com.liferay.info.field.type.OptionInfoFieldType;
import com.liferay.info.field.type.RelationshipInfoFieldType;
import com.liferay.info.field.type.SelectInfoFieldType;
import com.liferay.info.field.type.TextInfoFieldType;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.info.localized.bundle.FunctionInfoLocalizedValue;
import com.liferay.layout.display.page.LayoutDisplayPageObjectProvider;
import com.liferay.list.type.model.ListTypeEntry;
import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.object.configuration.ObjectConfiguration;
import com.liferay.object.field.setting.util.ObjectFieldSettingUtil;
import com.liferay.object.field.util.ObjectFieldUtil;
import com.liferay.object.info.field.type.util.ObjectFieldInfoFieldTypeUtil;
import com.liferay.object.info.item.util.ObjectEntryInfoItemUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.model.ObjectState;
import com.liferay.object.model.ObjectStateFlow;
import com.liferay.object.rest.context.path.RESTContextPathResolver;
import com.liferay.object.rest.context.path.RESTContextPathResolverRegistry;
import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.service.ObjectStateFlowLocalService;
import com.liferay.object.service.ObjectStateLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import jakarta.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ObjectFieldInfoFieldConverter {
    private static final Log _log = LogFactoryUtil.getLog(ObjectFieldInfoFieldConverter.class);
    private final DDMExpressionFactory _ddmExpressionFactory;
    private final ListTypeEntryLocalService _listTypeEntryLocalService;
    private final ObjectConfiguration _objectConfiguration;
    private final ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final ObjectFieldLocalService _objectFieldLocalService;
    private final ObjectFieldSettingLocalService _objectFieldSettingLocalService;
    private final ObjectRelationshipLocalService _objectRelationshipLocalService;
    private final ObjectScopeProviderRegistry _objectScopeProviderRegistry;
    private final ObjectStateFlowLocalService _objectStateFlowLocalService;
    private final ObjectStateLocalService _objectStateLocalService;
    private final Portal _portal;
    private final RESTContextPathResolverRegistry _restContextPathResolverRegistry;
    private final UserLocalService _userLocalService;

    public ObjectFieldInfoFieldConverter(DDMExpressionFactory ddmExpressionFactory, ListTypeEntryLocalService listTypeEntryLocalService, ObjectConfiguration objectConfiguration, ObjectDefinitionLocalService objectDefinitionLocalService, ObjectFieldLocalService objectFieldLocalService, ObjectFieldSettingLocalService objectFieldSettingLocalService, ObjectRelationshipLocalService objectRelationshipLocalService, ObjectScopeProviderRegistry objectScopeProviderRegistry, ObjectStateFlowLocalService objectStateFlowLocalService, ObjectStateLocalService objectStateLocalService, Portal portal, RESTContextPathResolverRegistry restContextPathResolverRegistry, UserLocalService userLocalService) {
        this._ddmExpressionFactory = ddmExpressionFactory;
        this._listTypeEntryLocalService = listTypeEntryLocalService;
        this._objectConfiguration = objectConfiguration;
        this._objectDefinitionLocalService = objectDefinitionLocalService;
        this._objectFieldLocalService = objectFieldLocalService;
        this._objectFieldSettingLocalService = objectFieldSettingLocalService;
        this._objectRelationshipLocalService = objectRelationshipLocalService;
        this._objectScopeProviderRegistry = objectScopeProviderRegistry;
        this._objectStateFlowLocalService = objectStateFlowLocalService;
        this._objectStateLocalService = objectStateLocalService;
        this._portal = portal;
        this._restContextPathResolverRegistry = restContextPathResolverRegistry;
        this._userLocalService = userLocalService;
    }

    public InfoField<?> getInfoField(boolean editable, String namespace, ObjectField objectField) {
        return this._addAttributes(InfoField.builder().infoFieldType(ObjectFieldInfoFieldTypeUtil.getInfoFieldType(objectField)).namespace(namespace).name(objectField.getName()).editable(editable).labelInfoLocalizedValue(InfoLocalizedValue.builder().defaultLocale(LocaleUtil.fromLanguageId((String)objectField.getDefaultLanguageId())).values(objectField.getLabelMap()).build()).localizable(objectField.isLocalized()).readOnly(this._isReadOnly(objectField)).required(objectField.isRequired()), objectField);
    }

    private InfoField<?> _addAttributes(InfoField.FinalStep finalStep, ObjectField objectField) {
        if (Objects.equals(objectField.getBusinessType(), "Attachment")) {
            finalStep.attribute(FileInfoFieldType.ALLOWED_FILE_EXTENSIONS, (Object)this._getAcceptedFileExtensions(objectField)).attribute(FileInfoFieldType.FILE_SOURCE, (Object)this._getFileSourceType(objectField)).attribute(FileInfoFieldType.MAX_FILE_SIZE, (Object)this._getMaximumFileSize(objectField));
        } else if (Objects.equals(objectField.getBusinessType(), "Decimal")) {
            finalStep.attribute(NumberInfoFieldType.DECIMAL, (Object)true).attribute(NumberInfoFieldType.DECIMAL_PART_MAX_LENGTH, (Object)16);
        } else if (Objects.equals(objectField.getBusinessType(), "Integer")) {
            finalStep.attribute(NumberInfoFieldType.MAX_VALUE, (Object)BigDecimal.valueOf(Integer.MAX_VALUE)).attribute(NumberInfoFieldType.MIN_VALUE, (Object)BigDecimal.valueOf(Integer.MIN_VALUE));
        } else if (Objects.equals(objectField.getBusinessType(), "LongInteger")) {
            finalStep.attribute(NumberInfoFieldType.MAX_VALUE, (Object)BigDecimal.valueOf(0x1FFFFFFFFFFFFFL)).attribute(NumberInfoFieldType.MIN_VALUE, (Object)BigDecimal.valueOf(-9007199254740991L));
        } else if (Objects.equals(objectField.getBusinessType(), "LongText")) {
            finalStep.attribute(LongTextInfoFieldType.MAX_LENGTH, (Object)this._getMaxLength(objectField, 65000L));
        } else if (Objects.equals(objectField.getBusinessType(), "MultiselectPicklist")) {
            finalStep.attribute(MultiselectInfoFieldType.OPTIONS, (Object)TransformUtil.transform((Collection)this._listTypeEntryLocalService.getListTypeEntries(objectField.getListTypeDefinitionId()), listTypeEntry -> new OptionInfoFieldType(Objects.equals(ObjectFieldSettingUtil.getDefaultValue(null, (ObjectField)objectField, null), listTypeEntry.getKey()), (InfoLocalizedValue)new FunctionInfoLocalizedValue(arg_0 -> ((ListTypeEntry)listTypeEntry).getName(arg_0)), listTypeEntry.getKey())));
        } else if (Objects.equals(objectField.getBusinessType(), "Picklist")) {
            finalStep.attribute(SelectInfoFieldType.OPTIONS, this._getOptionInfoFieldTypes(objectField));
        } else if (Objects.equals(objectField.getBusinessType(), "PrecisionDecimal")) {
            finalStep.attribute(NumberInfoFieldType.DECIMAL, (Object)true).attribute(NumberInfoFieldType.DECIMAL_PART_MAX_LENGTH, (Object)16).attribute(NumberInfoFieldType.MAX_VALUE, (Object)new BigDecimal("99999999999999.9999999999999999")).attribute(NumberInfoFieldType.MIN_VALUE, (Object)new BigDecimal("-99999999999999.9999999999999999"));
        } else if (Objects.equals(objectField.getBusinessType(), "Relationship")) {
            finalStep.attribute(RelationshipInfoFieldType.LABEL_FIELD_NAME, (Object)this._getRelationshipLabelFieldName(objectField)).attribute(RelationshipInfoFieldType.URL, (Object)this._getRelationshipURL(objectField)).attribute(RelationshipInfoFieldType.VALUE_FIELD_NAME, (Object)"id");
        } else if (Objects.equals(objectField.getBusinessType(), "Text")) {
            finalStep.attribute(TextInfoFieldType.MAX_LENGTH, (Object)this._getMaxLength(objectField, 280L));
        }
        return finalStep.build();
    }

    private String _getAcceptedFileExtensions(ObjectField objectField) {
        ObjectFieldSetting acceptedFileExtensionsObjectFieldSetting = this._objectFieldSettingLocalService.fetchObjectFieldSetting(objectField.getObjectFieldId(), "acceptedFileExtensions");
        if (acceptedFileExtensionsObjectFieldSetting == null) {
            return "";
        }
        return acceptedFileExtensionsObjectFieldSetting.getValue();
    }

    private FileInfoFieldType.FileSourceType _getFileSourceType(ObjectField objectField) {
        ObjectFieldSetting objectFieldSetting = this._objectFieldSettingLocalService.fetchObjectFieldSetting(objectField.getObjectFieldId(), "fileSource");
        if (objectFieldSetting == null) {
            return null;
        }
        if (Objects.equals(objectFieldSetting.getValue(), "documentsAndMedia")) {
            return FileInfoFieldType.FileSourceType.DOCUMENTS_AND_MEDIA;
        }
        if (Objects.equals(objectFieldSetting.getValue(), "userComputer")) {
            return FileInfoFieldType.FileSourceType.USER_COMPUTER;
        }
        return null;
    }

    private long _getGroupId(HttpServletRequest httpServletRequest, ObjectDefinition objectDefinition) {
        try {
            ObjectScopeProvider objectScopeProvider = this._objectScopeProviderRegistry.getObjectScopeProvider(objectDefinition.getScope());
            return objectScopeProvider.getGroupId(httpServletRequest);
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return 0L;
        }
    }

    private long _getMaximumFileSize(ObjectField objectField) {
        ObjectFieldSetting objectFieldSetting = this._objectFieldSettingLocalService.fetchObjectFieldSetting(objectField.getObjectFieldId(), "maximumFileSize");
        long maximumFileSizeForGuestUsers = this._objectConfiguration.maximumFileSizeForGuestUsers();
        if (objectFieldSetting == null) {
            return maximumFileSizeForGuestUsers;
        }
        long maximumFileSize = GetterUtil.getLong((String)objectFieldSetting.getValue());
        if (maximumFileSizeForGuestUsers < maximumFileSize && this._isGuestUser()) {
            maximumFileSize = maximumFileSizeForGuestUsers;
        }
        return maximumFileSize;
    }

    private long _getMaxLength(ObjectField objectField, long defaultMaxLength) {
        ObjectFieldSetting objectFieldSetting = this._objectFieldSettingLocalService.fetchObjectFieldSetting(objectField.getObjectFieldId(), "maxLength");
        if (objectFieldSetting == null) {
            return defaultMaxLength;
        }
        return GetterUtil.getLong((String)objectFieldSetting.getValue(), (long)defaultMaxLength);
    }

    private ObjectEntry _getObjectEntry() {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return null;
        }
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        if (httpServletRequest == null) {
            return null;
        }
        LayoutDisplayPageObjectProvider layoutDisplayPageObjectProvider = (LayoutDisplayPageObjectProvider)httpServletRequest.getAttribute("LAYOUT_DISPLAY_PAGE_OBJECT_PROVIDER");
        if (layoutDisplayPageObjectProvider == null || !(layoutDisplayPageObjectProvider.getDisplayObject() instanceof ObjectEntry)) {
            return null;
        }
        return (ObjectEntry)layoutDisplayPageObjectProvider.getDisplayObject();
    }

    private List<OptionInfoFieldType> _getOptionInfoFieldTypes(ObjectField objectField) {
        ListTypeEntry listTypeEntry;
        String defaultValue = String.valueOf(ObjectFieldSettingUtil.getDefaultValue(null, (ObjectField)objectField, null));
        if (!objectField.isState()) {
            return this._getOptionInfoFieldTypes(defaultValue, this._listTypeEntryLocalService.getListTypeEntries(objectField.getListTypeDefinitionId()));
        }
        String listTypeEntryKey = defaultValue;
        ObjectEntry objectEntry = this._getObjectEntry();
        if (objectEntry != null) {
            listTypeEntryKey = MapUtil.getString((Map)objectEntry.getValues(), (Object)objectField.getName(), (String)listTypeEntryKey);
        }
        if ((listTypeEntry = this._listTypeEntryLocalService.fetchListTypeEntry(objectField.getListTypeDefinitionId(), listTypeEntryKey)) == null) {
            return Collections.emptyList();
        }
        ObjectStateFlow objectStateFlow = this._objectStateFlowLocalService.fetchObjectFieldObjectStateFlow(objectField.getObjectFieldId());
        ObjectState objectState = this._objectStateLocalService.fetchObjectStateFlowObjectState(listTypeEntry.getListTypeEntryId(), objectStateFlow.getObjectStateFlowId());
        return this._getOptionInfoFieldTypes(defaultValue, ListUtil.concat((List[])new List[]{Collections.singletonList(listTypeEntry), TransformUtil.transform((Collection)this._objectStateLocalService.getNextObjectStates(objectState.getObjectStateId()), nextObjectState -> this._listTypeEntryLocalService.fetchListTypeEntry(nextObjectState.getListTypeEntryId()))}));
    }

    private List<OptionInfoFieldType> _getOptionInfoFieldTypes(String defaultValue, List<ListTypeEntry> listTypeEntries) {
        return TransformUtil.transform(listTypeEntries, listTypeEntry -> new OptionInfoFieldType(Objects.equals(defaultValue, listTypeEntry.getKey()), (InfoLocalizedValue)new FunctionInfoLocalizedValue(arg_0 -> ((ListTypeEntry)listTypeEntry).getName(arg_0)), listTypeEntry.getKey()));
    }

    private String _getRelationshipLabelFieldName(ObjectField objectField) {
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.fetchObjectRelationshipByObjectFieldId2(objectField.getObjectFieldId());
        ObjectDefinition relatedObjectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(objectRelationship.getObjectDefinitionId1());
        if (relatedObjectDefinition == null) {
            return "id";
        }
        ObjectField titleObjectField = this._objectFieldLocalService.fetchObjectField(relatedObjectDefinition.getTitleObjectFieldId());
        if (titleObjectField == null) {
            return "id";
        }
        if (Objects.equals(titleObjectField.getName(), "createDate")) {
            return "dateCreated";
        }
        if (Objects.equals(titleObjectField.getName(), "modifiedDate")) {
            return "dateModified";
        }
        return titleObjectField.getName();
    }

    private String _getRelationshipURL(ObjectField objectField) {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null || serviceContext.getRequest() == null) {
            return "";
        }
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.fetchObjectRelationshipByObjectFieldId2(objectField.getObjectFieldId());
        ObjectDefinition relatedObjectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(objectRelationship.getObjectDefinitionId1());
        if (relatedObjectDefinition == null) {
            return "";
        }
        RESTContextPathResolver restContextPathResolver = this._restContextPathResolverRegistry.getRESTContextPathResolver(relatedObjectDefinition.getClassName());
        String restContextPath = restContextPathResolver.getRESTContextPath(this._getGroupId(serviceContext.getRequest(), relatedObjectDefinition));
        return this._portal.getPortalURL(serviceContext.getRequest()) + this._portal.getPathContext() + restContextPath;
    }

    private boolean _isGuestUser() {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return true;
        }
        User user = this._userLocalService.fetchUser(serviceContext.getUserId());
        return user == null || user.isGuestUser();
    }

    private boolean _isReadOnly(ObjectField objectField) {
        ObjectEntry objectEntry = this._getObjectEntry();
        User user = ObjectEntryInfoItemUtil.getUser();
        try {
            return ObjectFieldUtil.isReadOnly((DDMExpressionFactory)this._ddmExpressionFactory, (String)(objectEntry != null ? objectEntry.getExternalReferenceCode() : null), (ObjectField)objectField, (long)(user != null ? user.getUserId() : PrincipalThreadLocal.getUserId()));
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return false;
        }
    }
}

