/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.info.item.provider.util;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.field.type.ActionInfoFieldType;
import com.liferay.info.field.type.ImageInfoFieldType;
import com.liferay.info.field.type.InfoFieldType;
import com.liferay.info.field.type.TextInfoFieldType;
import com.liferay.info.field.type.URLInfoFieldType;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.info.type.KeyLocalizedLabelPair;
import com.liferay.info.type.WebImage;
import com.liferay.list.type.model.ListTypeEntry;
import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.object.field.util.ObjectFieldUtil;
import com.liferay.object.info.field.converter.ObjectFieldInfoFieldConverter;
import com.liferay.object.info.field.type.util.ObjectFieldInfoFieldTypeUtil;
import com.liferay.object.info.item.ObjectEntryInfoItemFields;
import com.liferay.object.info.item.util.ObjectEntryInfoItemUtil;
import com.liferay.object.model.ObjectAction;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.rest.dto.v1_0.FileEntry;
import com.liferay.object.rest.dto.v1_0.ListEntry;
import com.liferay.object.rest.dto.v1_0.ObjectEntry;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManagerRegistry;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectActionLocalService;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class ObjectEntryInfoItemValuesProviderUtil {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryInfoItemValuesProviderUtil.class);

    public static List<InfoFieldValue<Object>> getInfoFieldValues(DLAppLocalService dlAppLocalService, DLURLHelper dlURLHelper, ListTypeEntryLocalService listTypeEntryLocalService, ObjectActionLocalService objectActionLocalService, ObjectDefinition objectDefinition, ObjectDefinitionLocalService objectDefinitionLocalService, ObjectEntryLocalService objectEntryLocalService, ObjectEntryManagerRegistry objectEntryManagerRegistry, ObjectFieldInfoFieldConverter objectFieldInfoFieldConverter, ObjectFieldLocalService objectFieldLocalService, List<ObjectField> objectFields, ObjectRelationshipLocalService objectRelationshipLocalService, ObjectScopeProviderRegistry objectScopeProviderRegistry, ThemeDisplay themeDisplay, Map<String, Object> values) throws Exception {
        ArrayList<InfoFieldValue<Object>> infoFieldValues = new ArrayList<InfoFieldValue<Object>>();
        for (ObjectField objectField : objectFields) {
            if (objectField.isMetadata()) continue;
            ObjectEntryInfoItemValuesProviderUtil._addInfoFieldValue(dlAppLocalService, dlURLHelper, infoFieldValues, listTypeEntryLocalService, objectEntryLocalService, objectField, objectFieldInfoFieldConverter, ObjectField.class.getSimpleName(), objectRelationshipLocalService, themeDisplay, values.get(objectField.getName()));
            if (!objectField.compareBusinessType("Relationship")) continue;
            Map properties = new HashMap();
            ObjectRelationship objectRelationship = objectRelationshipLocalService.fetchObjectRelationshipByObjectFieldId2(objectField.getObjectFieldId());
            ObjectDefinition parentObjectDefinition = objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId1());
            ObjectEntry objectEntry = ObjectEntryInfoItemUtil.getObjectEntry(parentObjectDefinition, objectEntryManagerRegistry, objectScopeProviderRegistry, objectEntryLocalService.fetchObjectEntry(GetterUtil.getLong((Object)values.get(objectField.getName()))), themeDisplay);
            if (objectEntry != null) {
                properties = objectEntry.getProperties();
            }
            for (ObjectField relatedObjectField : objectFieldLocalService.getObjectFields(parentObjectDefinition.getObjectDefinitionId(), false)) {
                ObjectEntryInfoItemValuesProviderUtil._addInfoFieldValue(dlAppLocalService, dlURLHelper, infoFieldValues, listTypeEntryLocalService, objectEntryLocalService, relatedObjectField, objectFieldInfoFieldConverter, StringBundler.concat((String[])new String[]{ObjectRelationship.class.getSimpleName(), "#", parentObjectDefinition.getName(), "#", objectRelationship.getName()}), objectRelationshipLocalService, themeDisplay, properties.get(relatedObjectField.getName()));
            }
        }
        if (!objectDefinition.isDefaultStorageType()) {
            return infoFieldValues;
        }
        infoFieldValues.addAll(TransformUtil.transform((Collection)objectActionLocalService.getObjectActions(objectDefinition.getObjectDefinitionId(), "standalone"), objectAction -> {
            InfoLocalizedValue actionLabelLocalizedValue = InfoLocalizedValue.builder().defaultLocale(LocaleUtil.fromLanguageId((String)objectAction.getDefaultLanguageId())).values(objectAction.getLabelMap()).build();
            return new InfoFieldValue(InfoField.builder().infoFieldType((InfoFieldType)ActionInfoFieldType.INSTANCE).namespace(ObjectAction.class.getSimpleName()).name(objectAction.getName()).labelInfoLocalizedValue(actionLabelLocalizedValue).build(), (Object)actionLabelLocalizedValue);
        }));
        return infoFieldValues;
    }

    private static void _addInfoFieldValue(DLAppLocalService dlAppLocalService, DLURLHelper dlURLHelper, List<InfoFieldValue<Object>> infoFieldValues, ListTypeEntryLocalService listTypeEntryLocalService, ObjectEntryLocalService objectEntryLocalService, ObjectField objectField, ObjectFieldInfoFieldConverter objectFieldInfoFieldConverter, String objectFieldNamespace, ObjectRelationshipLocalService objectRelationshipLocalService, ThemeDisplay themeDisplay, Object value) throws Exception {
        if (value == null) {
            infoFieldValues.add((InfoFieldValue<Object>)new InfoFieldValue(objectFieldInfoFieldConverter.getInfoField(false, objectFieldNamespace, objectField), (Object)""));
            return;
        }
        KeyValuePair infoFieldValue = "";
        if (Objects.equals(ObjectFieldInfoFieldTypeUtil.getInfoFieldType(objectField), ImageInfoFieldType.INSTANCE)) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)new String((byte[])value));
            WebImage webImage = new WebImage(jsonObject.getString("url"));
            webImage.setAlt(jsonObject.getString("alt"));
            infoFieldValue = webImage;
        } else if (objectField.compareBusinessType("Attachment")) {
            Long fileEntryId;
            if (value instanceof Long) {
                fileEntryId = (Long)value;
            } else {
                FileEntry dtoFileEntry = (FileEntry)value;
                fileEntryId = dtoFileEntry.getId();
            }
            try {
                com.liferay.portal.kernel.repository.model.FileEntry fileEntry = dlAppLocalService.getFileEntry(GetterUtil.getLong((Object)fileEntryId));
                infoFieldValue = Long.valueOf(fileEntry.getFileEntryId());
                infoFieldValues.add((InfoFieldValue<Object>)new InfoFieldValue(InfoField.builder().infoFieldType((InfoFieldType)URLInfoFieldType.INSTANCE).namespace(objectFieldNamespace).name(objectField.getObjectFieldId() + "#downloadURL").labelInfoLocalizedValue(InfoLocalizedValue.localize(ObjectEntryInfoItemFields.class, (String)"download-url")).build(), (Object)dlURLHelper.getDownloadURL(fileEntry, fileEntry.getFileVersion(), null, "")));
                infoFieldValues.add((InfoFieldValue<Object>)new InfoFieldValue(InfoField.builder().infoFieldType((InfoFieldType)TextInfoFieldType.INSTANCE).namespace(objectFieldNamespace).name(objectField.getObjectFieldId() + "#fileName").labelInfoLocalizedValue(InfoLocalizedValue.localize(ObjectEntryInfoItemFields.class, (String)"file-name")).build(), (Object)fileEntry.getFileName()));
                infoFieldValues.add((InfoFieldValue<Object>)new InfoFieldValue(InfoField.builder().infoFieldType((InfoFieldType)TextInfoFieldType.INSTANCE).namespace(objectFieldNamespace).name(objectField.getObjectFieldId() + "#mimeType").labelInfoLocalizedValue(InfoLocalizedValue.localize(ObjectEntryInfoItemFields.class, (String)"mime-type")).build(), (Object)fileEntry.getMimeType()));
                infoFieldValues.add((InfoFieldValue<Object>)new InfoFieldValue(InfoField.builder().infoFieldType((InfoFieldType)ImageInfoFieldType.INSTANCE).namespace(objectFieldNamespace).name(objectField.getObjectFieldId() + "#previewURL").labelInfoLocalizedValue(InfoLocalizedValue.localize(ObjectEntryInfoItemFields.class, (String)"preview-url")).build(), (Object)dlURLHelper.getPreviewURL(fileEntry, fileEntry.getFileVersion(), null, "")));
                infoFieldValues.add((InfoFieldValue<Object>)new InfoFieldValue(InfoField.builder().infoFieldType((InfoFieldType)TextInfoFieldType.INSTANCE).namespace(objectFieldNamespace).name(objectField.getObjectFieldId() + "#size").labelInfoLocalizedValue(InfoLocalizedValue.localize(ObjectEntryInfoItemFields.class, (String)"size")).build(), (Object)fileEntry.getSize()));
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
            }
        } else if (objectField.compareBusinessType("Date") && themeDisplay != null) {
            infoFieldValue = DateUtil.parseDate((String)"yyyy-MM-dd", (String)value.toString(), (Locale)themeDisplay.getLocale());
        } else if (objectField.compareBusinessType("DateTime")) {
            infoFieldValue = LocalDateTime.parse(value.toString(), DateTimeFormatter.ofPattern(ObjectFieldUtil.getDateTimePattern((String)value.toString())));
        } else if (objectField.compareBusinessType("MultiselectPicklist")) {
            KeyValuePair keyLocalizedLabelPairs = new ArrayList();
            List objects = new ArrayList();
            objects = value instanceof String ? ListUtil.fromArray((Object[])StringUtil.split((String)((String)value), (String)", ")) : (List)value;
            for (Object object : objects) {
                KeyLocalizedLabelPair keyLocalizedLabelPair = ObjectEntryInfoItemValuesProviderUtil._getKeyLocalizedLabelPair(listTypeEntryLocalService, object, objectField);
                if (keyLocalizedLabelPair == null) continue;
                keyLocalizedLabelPairs.add(keyLocalizedLabelPair);
            }
            if (ListUtil.isNotEmpty(keyLocalizedLabelPairs)) {
                infoFieldValue = keyLocalizedLabelPairs;
            }
        } else if (objectField.compareBusinessType("Picklist")) {
            KeyLocalizedLabelPair keyLocalizedLabelPair = ObjectEntryInfoItemValuesProviderUtil._getKeyLocalizedLabelPair(listTypeEntryLocalService, value, objectField);
            if (keyLocalizedLabelPair != null) {
                infoFieldValue = ListUtil.fromArray((Object[])new KeyLocalizedLabelPair[]{keyLocalizedLabelPair});
            }
        } else if (objectField.compareBusinessType("Relationship")) {
            ObjectRelationship objectRelationship = objectRelationshipLocalService.fetchObjectRelationshipByObjectFieldId2(objectField.getObjectFieldId());
            try {
                infoFieldValue = new KeyValuePair(String.valueOf(value), objectEntryLocalService.getTitleValue(objectRelationship.getObjectDefinitionId1(), GetterUtil.getLong((Object)value)));
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
            }
        } else {
            infoFieldValue = value;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            if (themeDisplay != null && map.containsKey(themeDisplay.getLanguageId())) {
                infoFieldValue = map.get(themeDisplay.getLanguageId());
            }
        }
        infoFieldValues.add((InfoFieldValue<Object>)new InfoFieldValue(objectFieldInfoFieldConverter.getInfoField(false, objectFieldNamespace, objectField), GetterUtil.getObject((Object)infoFieldValue, (Object)"")));
    }

    private static KeyLocalizedLabelPair _getKeyLocalizedLabelPair(ListTypeEntryLocalService listTypeEntryLocalService, Object object, ObjectField objectField) {
        String key;
        if (object instanceof ListEntry) {
            ListEntry listEntry = (ListEntry)object;
            key = listEntry.getKey();
        } else {
            key = GetterUtil.getString((Object)object);
        }
        ListTypeEntry listTypeEntry = listTypeEntryLocalService.fetchListTypeEntry(objectField.getListTypeDefinitionId(), key);
        if (listTypeEntry == null) {
            return null;
        }
        return new KeyLocalizedLabelPair(listTypeEntry.getKey(), InfoLocalizedValue.builder().defaultLocale(LocaleUtil.fromLanguageId((String)listTypeEntry.getDefaultLanguageId())).values(listTypeEntry.getNameMap()).build());
    }
}

