/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.dynamic.data.mapping.internal.form.field.type;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTemplateContextContributor;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldRenderingContext;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.rest.context.path.RESTContextPathResolver;
import com.liferay.object.rest.context.path.RESTContextPathResolverRegistry;
import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"ddm.form.field.type.name=object-relationship"}, service={DDMFormFieldTemplateContextContributor.class, ObjectRelationshipDDMFormFieldTemplateContextContributor.class})
public class ObjectRelationshipDDMFormFieldTemplateContextContributor
implements DDMFormFieldTemplateContextContributor {
    private static final Log _log = LogFactoryUtil.getLog(ObjectRelationshipDDMFormFieldTemplateContextContributor.class);
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectScopeProviderRegistry _objectScopeProviderRegistry;
    @Reference
    private PersistedModelLocalServiceRegistry _persistedModelLocalServiceRegistry;
    @Reference
    private Portal _portal;
    @Reference
    private RESTContextPathResolverRegistry _restContextPathResolverRegistry;

    public Map<String, Object> getParameters(DDMFormField ddmFormField, DDMFormFieldRenderingContext ddmFormFieldRenderingContext) {
        return HashMapBuilder.put((Object)"apiURL", (Object)this._getAPIURL(ddmFormField, ddmFormFieldRenderingContext)).put((Object)"initialLabel", (Object)this._getInitialLabel(ddmFormField, ddmFormFieldRenderingContext.getValue())).put((Object)"inputName", (Object)ddmFormField.getName()).put((Object)"labelKey", (Object)this._getLabelKey(ddmFormField)).put((Object)"objectDefinitionId", (Object)GetterUtil.getLong((Object)ddmFormField.getProperty("objectDefinitionId"))).put((Object)"placeholder", () -> {
            LocalizedValue localizedValue = (LocalizedValue)ddmFormField.getProperty("placeholder");
            if (localizedValue == null) {
                return null;
            }
            return GetterUtil.getString((String)localizedValue.getString(ddmFormFieldRenderingContext.getLocale()));
        }).put((Object)"value", (Object)ddmFormFieldRenderingContext.getValue()).put((Object)"valueKey", (Object)"id").build();
    }

    protected String getValue(String valueString) {
        try {
            JSONArray jsonArray = this._jsonFactory.createJSONArray(valueString);
            return GetterUtil.getString((Object)jsonArray.get(0));
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)jsonException, (Throwable)jsonException);
            }
            return valueString;
        }
    }

    private String _getAPIURL(DDMFormField ddmFormField, DDMFormFieldRenderingContext ddmFormFieldRenderingContext) {
        String apiURL = GetterUtil.getString((Object)ddmFormField.getProperty("apiURL"));
        if (Validator.isNotNull((String)apiURL)) {
            return apiURL;
        }
        apiURL = this._portal.getPortalURL(ddmFormFieldRenderingContext.getHttpServletRequest());
        ObjectDefinition objectDefinition = this._getObjectDefinition(ddmFormField);
        if (objectDefinition == null) {
            return apiURL;
        }
        RESTContextPathResolver restContextPathResolver = this._restContextPathResolverRegistry.getRESTContextPathResolver(objectDefinition.getClassName());
        String restContextPath = restContextPathResolver.getRESTContextPath(this._getGroupId(ddmFormFieldRenderingContext, objectDefinition));
        return apiURL + restContextPath;
    }

    private long _getGroupId(DDMFormFieldRenderingContext ddmFormFieldRenderingContext, ObjectDefinition objectDefinition) {
        if (StringUtil.startsWith((String)ddmFormFieldRenderingContext.getPortletNamespace(), (String)this._portal.getPortletNamespace("com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormPortlet"))) {
            return GetterUtil.getLong((Object)ddmFormFieldRenderingContext.getProperty("groupId"));
        }
        try {
            ObjectScopeProvider objectScopeProvider = this._objectScopeProviderRegistry.getObjectScopeProvider(objectDefinition.getScope());
            return objectScopeProvider.getGroupId(ddmFormFieldRenderingContext.getHttpServletRequest());
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)portalException, (Throwable)portalException);
            }
            return 0L;
        }
    }

    private String _getInitialLabel(DDMFormField ddmFormField, String value) {
        String initialLabel = GetterUtil.getString((Object)ddmFormField.getProperty("initialLabel"));
        if (Validator.isNotNull((String)initialLabel)) {
            return initialLabel;
        }
        if (Validator.isBlank((String)value)) {
            return "";
        }
        ObjectDefinition objectDefinition = this._getObjectDefinition(ddmFormField);
        if (objectDefinition != null && objectDefinition.isSystem()) {
            return this._getPersistedModelValue(objectDefinition, value);
        }
        return this._getObjectEntryTitleValue(value);
    }

    private String _getLabelKey(DDMFormField ddmFormField) {
        ObjectField objectField;
        String labelKey = GetterUtil.getString((Object)ddmFormField.getProperty("labelKey"));
        if (Validator.isNotNull((String)labelKey)) {
            return labelKey;
        }
        ObjectDefinition objectDefinition = this._getObjectDefinition(ddmFormField);
        if (objectDefinition != null && objectDefinition.getTitleObjectFieldId() > 0L && (objectField = this._objectFieldLocalService.fetchObjectField(objectDefinition.getTitleObjectFieldId())) != null) {
            return objectField.getName();
        }
        return "id";
    }

    private ObjectDefinition _getObjectDefinition(DDMFormField ddmFormField) {
        return this._objectDefinitionLocalService.fetchObjectDefinition(GetterUtil.getLong((String)this.getValue(GetterUtil.getString((Object)ddmFormField.getProperty("objectDefinitionId")))));
    }

    private String _getObjectEntryTitleValue(String value) {
        block3: {
            ObjectEntry objectEntry = this._objectEntryLocalService.fetchObjectEntry(GetterUtil.getLong((String)value));
            if (objectEntry != null) {
                try {
                    return objectEntry.getTitleValue();
                }
                catch (PortalException portalException) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug((Object)portalException, (Throwable)portalException);
                }
            }
        }
        return value;
    }

    private String _getObjectFieldDBColumnName(ObjectDefinition objectDefinition) {
        ObjectField objectField = this._objectFieldLocalService.fetchObjectField(objectDefinition.getTitleObjectFieldId());
        if (objectField != null) {
            return objectField.getDBColumnName();
        }
        return objectDefinition.getPKObjectFieldDBColumnName();
    }

    private String _getPersistedModelValue(ObjectDefinition objectDefinition, String value) {
        try {
            PersistedModelLocalService persistedModelLocalService = this._persistedModelLocalServiceRegistry.getPersistedModelLocalService(objectDefinition.getClassName());
            PersistedModel persistedModel = persistedModelLocalService.getPersistedModel((Serializable)Long.valueOf(GetterUtil.getLong((String)value)));
            JSONObject jsonObject = this._jsonFactory.createJSONObject(this._jsonFactory.looseSerialize((Object)persistedModel));
            return jsonObject.getString(this._getObjectFieldDBColumnName(objectDefinition));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)exception, (Throwable)exception);
            }
            return value;
        }
    }
}

