/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.test.util;

import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.model.NotificationQueueEntry;
import com.liferay.notification.model.NotificationRecipientSetting;
import com.liferay.notification.model.NotificationTemplate;
import com.liferay.notification.service.NotificationQueueEntryLocalServiceUtil;
import com.liferay.notification.service.NotificationRecipientLocalServiceUtil;
import com.liferay.notification.service.NotificationTemplateLocalServiceUtil;
import com.liferay.notification.util.NotificationRecipientSettingUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class NotificationTemplateUtil {
    public static NotificationContext createNotificationContext(List<NotificationRecipientSetting> notificationRecipientSettings, String type) throws PortalException {
        return NotificationTemplateUtil.createNotificationContext(TestPropsValues.getUser(), RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), notificationRecipientSettings, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), type);
    }

    public static NotificationContext createNotificationContext(String type) throws Exception {
        return NotificationTemplateUtil.createNotificationContext(TestPropsValues.getUser(), RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), type);
    }

    public static NotificationContext createNotificationContext(User user) {
        return NotificationTemplateUtil.createNotificationContext(user, null, "userNotification");
    }

    public static NotificationContext createNotificationContext(User user, long objectDefinitionId, String body, String description, String editorType, List<NotificationRecipientSetting> notificationRecipientSettings, String subject, String type, List<Long> attachmentObjectFieldIds) {
        NotificationContext notificationContext = new NotificationContext();
        notificationContext.setAttachmentObjectFieldIds(attachmentObjectFieldIds);
        notificationContext.setNotificationQueueEntry(NotificationTemplateUtil.createNotificationQueueEntry(user, body, subject, type));
        notificationContext.setNotificationRecipient(NotificationRecipientLocalServiceUtil.createNotificationRecipient((long)RandomTestUtil.randomInt()));
        notificationContext.setNotificationRecipientSettings(notificationRecipientSettings);
        notificationContext.setNotificationTemplate(NotificationTemplateUtil.createNotificationTemplate(user.getUserId(), objectDefinitionId, body, description, editorType, subject, type));
        notificationContext.setType(type);
        return notificationContext;
    }

    public static NotificationContext createNotificationContext(User user, String description, String type) {
        return NotificationTemplateUtil.createNotificationContext(user, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), description, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), type);
    }

    public static NotificationContext createNotificationContext(User user, String body, String description, List<NotificationRecipientSetting> notificationRecipientSettings, String subject, String type) {
        return NotificationTemplateUtil.createNotificationContext(user, 0L, body, description, "richText", notificationRecipientSettings, subject, type, Collections.emptyList());
    }

    public static NotificationContext createNotificationContext(User user, String body, String description, String subject, String type) {
        List<NotificationRecipientSetting> notificationRecipientSettings = new ArrayList<NotificationRecipientSetting>();
        if (type.equals("email")) {
            notificationRecipientSettings = Arrays.asList(NotificationRecipientSettingUtil.createNotificationRecipientSetting((String)"from", (Object)"[%CURRENT_USER_EMAIL_ADDRESS%]"), NotificationRecipientSettingUtil.createNotificationRecipientSetting((String)"fromName", (Object)LocalizedMapUtil.getLocalizedMap((String)"[%CURRENT_USER_FIRST_NAME%]")), NotificationRecipientSettingUtil.createNotificationRecipientSetting((String)"to", (Object)"test@liferay.com"));
        } else if (type.equals("userNotification")) {
            notificationRecipientSettings = Collections.singletonList(NotificationRecipientSettingUtil.createNotificationRecipientSetting((String)"userScreenName", (Object)user.getScreenName()));
        }
        return NotificationTemplateUtil.createNotificationContext(user, body, description, notificationRecipientSettings, subject, type);
    }

    public static NotificationQueueEntry createNotificationQueueEntry(User user, String body, String subject, String type) {
        NotificationQueueEntry notificationQueueEntry = NotificationQueueEntryLocalServiceUtil.createNotificationQueueEntry((long)RandomTestUtil.randomInt());
        notificationQueueEntry.setUserId(user.getUserId());
        notificationQueueEntry.setUserName(user.getFullName());
        notificationQueueEntry.setBody(body);
        notificationQueueEntry.setSubject(subject);
        notificationQueueEntry.setType(type);
        notificationQueueEntry.setStatus(2);
        return notificationQueueEntry;
    }

    public static NotificationTemplate createNotificationTemplate(long userId, long objectDefinitionId, String body, String description, String editorType, String subject, String type) {
        NotificationTemplate notificationTemplate = NotificationTemplateLocalServiceUtil.createNotificationTemplate((long)RandomTestUtil.randomInt());
        notificationTemplate.setUserId(userId);
        notificationTemplate.setObjectDefinitionId(objectDefinitionId);
        notificationTemplate.setBody(body);
        notificationTemplate.setDescription(description);
        notificationTemplate.setEditorType(editorType);
        notificationTemplate.setName(RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]));
        notificationTemplate.setSubject(subject);
        notificationTemplate.setType(type);
        return notificationTemplate;
    }
}

