/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.multi.factor.authentication.timebased.otp.model.impl;

import com.liferay.multi.factor.authentication.timebased.otp.model.MFATimeBasedOTPEntry;
import com.liferay.multi.factor.authentication.timebased.otp.service.MFATimeBasedOTPEntryLocalServiceUtil;

/**
 * The extended model base implementation for the MFATimeBasedOTPEntry service. Represents a row in the &quot;MFATimeBasedOTPEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link MFATimeBasedOTPEntryImpl}.
 * </p>
 *
 * @author Arthur Chan
 * @see MFATimeBasedOTPEntryImpl
 * @see MFATimeBasedOTPEntry
 * @generated
 */
public abstract class MFATimeBasedOTPEntryBaseImpl
	extends MFATimeBasedOTPEntryModelImpl implements MFATimeBasedOTPEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a mfa time based otp entry model instance should use the <code>MFATimeBasedOTPEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			MFATimeBasedOTPEntryLocalServiceUtil.addMFATimeBasedOTPEntry(this);
		}
		else {
			MFATimeBasedOTPEntryLocalServiceUtil.updateMFATimeBasedOTPEntry(
				this);
		}
	}

}