/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.multi.factor.authentication.email.otp.service.impl;

import com.liferay.multi.factor.authentication.email.otp.exception.DuplicateMFAEmailOTPEntryException;
import com.liferay.multi.factor.authentication.email.otp.exception.NoSuchEntryException;
import com.liferay.multi.factor.authentication.email.otp.model.MFAEmailOTPEntry;
import com.liferay.multi.factor.authentication.email.otp.service.base.MFAEmailOTPEntryLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import java.util.Date;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.multi.factor.authentication.email.otp.model.MFAEmailOTPEntry"}, service={AopService.class})
public class MFAEmailOTPEntryLocalServiceImpl
extends MFAEmailOTPEntryLocalServiceBaseImpl {
    @Reference
    private UserLocalService _userLocalService;

    public MFAEmailOTPEntry addMFAEmailOTPEntry(long userId) throws PortalException {
        MFAEmailOTPEntry mfaEmailOTPEntry = this.mfaEmailOTPEntryPersistence.fetchByUserId(userId);
        if (mfaEmailOTPEntry != null) {
            throw new DuplicateMFAEmailOTPEntryException("User ID " + userId);
        }
        mfaEmailOTPEntry = this.mfaEmailOTPEntryPersistence.create(this.counterLocalService.increment());
        User user = this._userLocalService.getUserById(userId);
        mfaEmailOTPEntry.setCompanyId(user.getCompanyId());
        mfaEmailOTPEntry.setUserId(user.getUserId());
        mfaEmailOTPEntry.setUserName(user.getFullName());
        mfaEmailOTPEntry.setCreateDate(new Date());
        mfaEmailOTPEntry.setModifiedDate(new Date());
        return (MFAEmailOTPEntry)this.mfaEmailOTPEntryPersistence.update((BaseModel)mfaEmailOTPEntry);
    }

    public MFAEmailOTPEntry fetchMFAEmailOTPEntryByUserId(long userId) {
        return this.mfaEmailOTPEntryPersistence.fetchByUserId(userId);
    }

    public MFAEmailOTPEntry resetFailedAttempts(long userId) throws PortalException {
        MFAEmailOTPEntry mfaEmailOTPEntry = this.mfaEmailOTPEntryPersistence.fetchByUserId(userId);
        if (mfaEmailOTPEntry == null) {
            throw new NoSuchEntryException("User ID " + userId);
        }
        mfaEmailOTPEntry.setFailedAttempts(0);
        mfaEmailOTPEntry.setLastFailDate(null);
        mfaEmailOTPEntry.setLastFailIP(null);
        return (MFAEmailOTPEntry)this.mfaEmailOTPEntryPersistence.update((BaseModel)mfaEmailOTPEntry);
    }

    public MFAEmailOTPEntry updateAttempts(long userId, String ip, boolean success) throws PortalException {
        MFAEmailOTPEntry mfaEmailOTPEntry = this.mfaEmailOTPEntryPersistence.fetchByUserId(userId);
        if (mfaEmailOTPEntry == null) {
            throw new NoSuchEntryException("User ID " + userId);
        }
        if (success) {
            mfaEmailOTPEntry.setFailedAttempts(0);
            mfaEmailOTPEntry.setLastFailDate(null);
            mfaEmailOTPEntry.setLastFailIP(null);
            mfaEmailOTPEntry.setLastSuccessDate(new Date());
            mfaEmailOTPEntry.setLastSuccessIP(ip);
        } else {
            mfaEmailOTPEntry.setFailedAttempts(mfaEmailOTPEntry.getFailedAttempts() + 1);
            mfaEmailOTPEntry.setLastFailDate(new Date());
            mfaEmailOTPEntry.setLastFailIP(ip);
        }
        return (MFAEmailOTPEntry)this.mfaEmailOTPEntryPersistence.update((BaseModel)mfaEmailOTPEntry);
    }
}

