/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.multi.factor.authentication.email.otp.model.impl;

import com.liferay.multi.factor.authentication.email.otp.model.MFAEmailOTPEntry;
import com.liferay.multi.factor.authentication.email.otp.service.MFAEmailOTPEntryLocalServiceUtil;

/**
 * The extended model base implementation for the MFAEmailOTPEntry service. Represents a row in the &quot;MFAEmailOTPEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link MFAEmailOTPEntryImpl}.
 * </p>
 *
 * @author Arthur Chan
 * @see MFAEmailOTPEntryImpl
 * @see MFAEmailOTPEntry
 * @generated
 */
public abstract class MFAEmailOTPEntryBaseImpl
	extends MFAEmailOTPEntryModelImpl implements MFAEmailOTPEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a mfa email otp entry model instance should use the <code>MFAEmailOTPEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			MFAEmailOTPEntryLocalServiceUtil.addMFAEmailOTPEntry(this);
		}
		else {
			MFAEmailOTPEntryLocalServiceUtil.updateMFAEmailOTPEntry(this);
		}
	}

}