/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.messaging.internal;

import com.liferay.mail.kernel.model.MailMessage;
import com.liferay.mail.kernel.service.MailService;
import com.liferay.mail.messaging.internal.MailEngine;
import com.liferay.mail.settings.configuration.MailSettingSystemConfiguration;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.security.auth.EmailAddressGenerator;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.security.auth.EmailAddressGeneratorFactory;
import jakarta.mail.internet.InternetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.mail.settings.configuration.MailSettingSystemConfiguration"}, property={"destination.name=liferay/mail"}, service={MessageListener.class})
public class MailMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(MailMessageListener.class);
    @Reference
    private MailService _mailService;
    private volatile MailSettingSystemConfiguration _mailSettingSystemConfiguration;

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._mailSettingSystemConfiguration = (MailSettingSystemConfiguration)ConfigurableUtil.createConfigurable(MailSettingSystemConfiguration.class, properties);
    }

    protected void doMailMessage(MailMessage mailMessage) throws Exception {
        InternetAddress from = this.filterInternetAddress(mailMessage.getFrom());
        if (from == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Skipping email because the sender is not specified");
            }
            return;
        }
        mailMessage.setFrom(from);
        Object[] to = this.filterInternetAddresses(mailMessage.getTo());
        mailMessage.setTo((InternetAddress[])to);
        Object[] cc = this.filterInternetAddresses(mailMessage.getCC());
        mailMessage.setCC((InternetAddress[])cc);
        Object[] bcc = this.filterInternetAddresses(mailMessage.getBCC());
        InternetAddress[] auditTrail = InternetAddress.parse((String)this._mailSettingSystemConfiguration.auditTrail());
        if (auditTrail.length > 0) {
            if (ArrayUtil.isNotEmpty((Object[])bcc)) {
                for (InternetAddress internetAddress : auditTrail) {
                    bcc = (InternetAddress[])ArrayUtil.append((Object[])bcc, (Object)internetAddress);
                }
            } else {
                bcc = auditTrail;
            }
        }
        mailMessage.setBCC((InternetAddress[])bcc);
        Object[] bulkAddresses = this.filterInternetAddresses(mailMessage.getBulkAddresses());
        mailMessage.setBulkAddresses((InternetAddress[])bulkAddresses);
        InternetAddress[] replyTo = this.filterInternetAddresses(mailMessage.getReplyTo());
        mailMessage.setReplyTo(replyTo);
        if (ArrayUtil.isNotEmpty((Object[])to) || ArrayUtil.isNotEmpty((Object[])cc) || ArrayUtil.isNotEmpty((Object[])bcc) || ArrayUtil.isNotEmpty((Object[])bulkAddresses)) {
            MailEngine.send(this._mailService, mailMessage, this._mailSettingSystemConfiguration.batchSize(), this._mailSettingSystemConfiguration.throwsExceptionOnFailure());
        }
    }

    protected void doReceive(Message message) throws Exception {
        this.doMailMessage((MailMessage)message.getPayload());
    }

    protected InternetAddress filterInternetAddress(InternetAddress internetAddress) {
        String emailAddress;
        if (PortalRunMode.isTestMode()) {
            return internetAddress;
        }
        EmailAddressGenerator emailAddressGenerator = EmailAddressGeneratorFactory.getInstance();
        if (emailAddressGenerator.isFake(emailAddress = internetAddress.getAddress())) {
            return null;
        }
        HashSet<String> sendBlacklist = new HashSet<String>(Arrays.asList(this._mailSettingSystemConfiguration.sendBlacklist()));
        if (sendBlacklist.contains(emailAddress)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Email ", emailAddress, " will be ignored because it ", "is included in blacklist"}));
            }
            return null;
        }
        return internetAddress;
    }

    protected InternetAddress[] filterInternetAddresses(InternetAddress[] internetAddresses) {
        if (internetAddresses == null) {
            return null;
        }
        ArrayList<InternetAddress> filteredInternetAddresses = new ArrayList<InternetAddress>(internetAddresses.length);
        for (InternetAddress internetAddress : internetAddresses) {
            InternetAddress filteredInternetAddress = this.filterInternetAddress(internetAddress);
            if (filteredInternetAddress == null) continue;
            filteredInternetAddresses.add(filteredInternetAddress);
        }
        return filteredInternetAddresses.toArray(new InternetAddress[0]);
    }
}

