/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.messaging.internal;

import com.liferay.mail.kernel.model.Account;
import com.liferay.mail.kernel.model.FileAttachment;
import com.liferay.mail.kernel.model.MailMessage;
import com.liferay.mail.kernel.model.SMTPAccount;
import com.liferay.mail.kernel.service.MailService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.log.LogUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Header;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.SendFailedException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.InternetHeaders;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.File;
import java.io.InputStream;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class MailEngine {
    private static final int _BATCH_SIZE = 0;
    private static final long _DATA_LIMIT_MAIL_MESSAGE_MAX_COUNT = GetterUtil.getLong((String)PropsUtil.get((String)"data.limit.mail.message.max.count"));
    private static final long _DATA_LIMIT_MAIL_MESSAGE_MAX_PERIOD = GetterUtil.getLong((String)PropsUtil.get((String)"data.limit.mail.message.max.period"));
    private static final String _MULTIPART_TYPE_ALTERNATIVE = "alternative";
    private static final String _MULTIPART_TYPE_MIXED = "mixed";
    private static final String _TEXT_HTML = "text/html;charset=\"UTF-8\"";
    private static final String _TEXT_PLAIN = "text/plain;charset=\"UTF-8\"";
    private static final Log _log = LogFactoryUtil.getLog(MailEngine.class);
    private static final AtomicLong _lastResetTime = new AtomicLong();
    private static final Map<Long, AtomicLong> _mailMessageCounts = new ConcurrentHashMap<Long, AtomicLong>();

    public static void send(MailService mailService, InternetAddress from, InternetAddress[] to, InternetAddress[] cc, InternetAddress[] bcc, InternetAddress[] bulkAddresses, String subject, String body, boolean htmlFormat, InternetAddress[] replyTo, String messageId, String inReplyTo, List<FileAttachment> fileAttachments, SMTPAccount smtpAccount, InternetHeaders internetHeaders, String batchSize, boolean throwsExceptionOnFailure) throws PortalException {
        long startTime = System.currentTimeMillis();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("From: " + String.valueOf(from)));
            _log.debug((Object)("To: " + Arrays.toString(to)));
            _log.debug((Object)("CC: " + Arrays.toString(cc)));
            _log.debug((Object)("BCC: " + Arrays.toString(bcc)));
            _log.debug((Object)("List Addresses: " + Arrays.toString(bulkAddresses)));
            _log.debug((Object)("Subject: " + subject));
            _log.debug((Object)("Body: " + body));
            _log.debug((Object)("HTML Format: " + htmlFormat));
            _log.debug((Object)("Reply to: " + Arrays.toString(replyTo)));
            _log.debug((Object)("Message ID: " + messageId));
            _log.debug((Object)("In Reply To: " + inReplyTo));
            if (fileAttachments != null && _log.isDebugEnabled()) {
                for (int i = 0; i < fileAttachments.size(); ++i) {
                    FileAttachment fileAttachment = fileAttachments.get(i);
                    InputStream inputStream = fileAttachment.getInputStream();
                    if (inputStream == null) continue;
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Attachment ", i, " and file name ", fileAttachment.getFileName()}));
                }
            }
        }
        ArrayList<File> tempFiles = new ArrayList<File>();
        try {
            MailEngine._validateAddress((Address)from);
            if (ArrayUtil.isNotEmpty((Object[])to)) {
                MailEngine._validateAddresses((Address[])to);
            }
            if (ArrayUtil.isNotEmpty((Object[])cc)) {
                MailEngine._validateAddresses((Address[])cc);
            }
            if (ArrayUtil.isNotEmpty((Object[])bcc)) {
                MailEngine._validateAddresses((Address[])bcc);
            }
            if (ArrayUtil.isNotEmpty((Object[])replyTo)) {
                MailEngine._validateAddresses((Address[])replyTo);
            }
            if (ArrayUtil.isNotEmpty((Object[])bulkAddresses)) {
                MailEngine._validateAddresses((Address[])bulkAddresses);
            }
            Object session = null;
            session = smtpAccount == null ? mailService.getSession() : mailService.getSession((Account)smtpAccount);
            LiferayMimeMessage message = new LiferayMimeMessage((Session)session);
            message.addHeader("X-Auto-Response-Suppress", "AutoReply, DR, NDR, NRN, OOF, RN");
            message.setFrom((Address)from);
            if (ArrayUtil.isNotEmpty((Object[])to)) {
                message.setRecipients(Message.RecipientType.TO, (Address[])to);
            }
            if (ArrayUtil.isNotEmpty((Object[])cc)) {
                message.setRecipients(Message.RecipientType.CC, (Address[])cc);
            }
            if (ArrayUtil.isNotEmpty((Object[])bcc)) {
                message.setRecipients(Message.RecipientType.BCC, (Address[])bcc);
            }
            subject = GetterUtil.getString((String)subject);
            message.setSubject(MailEngine._sanitizeCRLF(subject));
            if (ListUtil.isNotEmpty(fileAttachments)) {
                MimeMultipart rootMultipart = new MimeMultipart(_MULTIPART_TYPE_MIXED);
                MimeMultipart messageMultipart = new MimeMultipart(_MULTIPART_TYPE_ALTERNATIVE);
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                messageBodyPart.setContent((Multipart)messageMultipart);
                rootMultipart.addBodyPart((BodyPart)messageBodyPart);
                if (htmlFormat) {
                    bodyPart = new MimeBodyPart();
                    bodyPart.setContent((Object)body, _TEXT_HTML);
                    messageMultipart.addBodyPart((BodyPart)bodyPart);
                } else {
                    bodyPart = new MimeBodyPart();
                    bodyPart.setText(body);
                    messageMultipart.addBodyPart((BodyPart)bodyPart);
                }
                for (FileAttachment fileAttachment : fileAttachments) {
                    InputStream inputStream = fileAttachment.getInputStream();
                    if (inputStream == null) continue;
                    MimeBodyPart mimeBodyPart = new MimeBodyPart();
                    File file = FileUtil.createTempFile((InputStream)inputStream);
                    tempFiles.add(file);
                    FileDataSource dataSource = new FileDataSource(file);
                    mimeBodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
                    mimeBodyPart.setDisposition("attachment");
                    if (fileAttachment.getFileName() != null) {
                        mimeBodyPart.setFileName(fileAttachment.getFileName());
                    } else {
                        mimeBodyPart.setFileName(file.getName());
                    }
                    rootMultipart.addBodyPart((BodyPart)mimeBodyPart);
                }
                message.setContent((Multipart)rootMultipart);
                message.saveChanges();
            } else if (htmlFormat) {
                message.setContent(body, _TEXT_HTML);
            } else {
                message.setContent(body, _TEXT_PLAIN);
            }
            message.setSentDate(new Date());
            if (ArrayUtil.isNotEmpty((Object[])replyTo)) {
                message.setReplyTo((Address[])replyTo);
            }
            if (messageId != null) {
                message.setHeader("Message-ID", MailEngine._sanitizeCRLF(messageId));
            }
            if (inReplyTo != null) {
                message.setHeader("In-Reply-To", MailEngine._sanitizeCRLF(inReplyTo));
                message.setHeader("References", MailEngine._sanitizeCRLF(inReplyTo));
            }
            if (internetHeaders != null) {
                Enumeration enumeration = internetHeaders.getAllHeaders();
                while (enumeration.hasMoreElements()) {
                    Header header = (Header)enumeration.nextElement();
                    message.setHeader(header.getName(), header.getValue());
                }
            }
            MailEngine._send((Session)session, (Message)message, bulkAddresses, GetterUtil.getInteger((String)batchSize, (int)0), throwsExceptionOnFailure);
        }
        catch (SendFailedException sendFailedException) {
            _log.error((Throwable)sendFailedException);
            if (throwsExceptionOnFailure) {
                throw new PortalException((Throwable)sendFailedException);
            }
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
        finally {
            for (File file : tempFiles) {
                file.delete();
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Sending mail takes " + (System.currentTimeMillis() - startTime) + " ms"));
        }
    }

    public static void send(MailService mailService, MailMessage mailMessage, String batchSize, boolean throwsExceptionOnFailure) throws PortalException {
        MailEngine.send(mailService, mailMessage.getFrom(), mailMessage.getTo(), mailMessage.getCC(), mailMessage.getBCC(), mailMessage.getBulkAddresses(), mailMessage.getSubject(), mailMessage.getBody(), mailMessage.isHTMLFormat(), mailMessage.getReplyTo(), mailMessage.getMessageId(), mailMessage.getInReplyTo(), mailMessage.getFileAttachments(), mailMessage.getSMTPAccount(), mailMessage.getInternetHeaders(), batchSize, throwsExceptionOnFailure);
    }

    private static Address[] _getBatchAddresses(Address[] addresses, int index, int batchSize) {
        if (batchSize == 0 && index == 0) {
            return addresses;
        }
        if (batchSize == 0) {
            return null;
        }
        int start = index * batchSize;
        if (start > addresses.length) {
            return null;
        }
        int end = (index + 1) * batchSize;
        if (end > addresses.length) {
            end = addresses.length;
        }
        return (Address[])ArrayUtil.subset((Object[])addresses, (int)start, (int)end);
    }

    private static String _getSMTPProperty(Session session, String suffix) {
        String protocol = GetterUtil.getString((String)session.getProperty("mail.transport.protocol"));
        if (protocol.equals("smtps")) {
            return session.getProperty("mail.smtps." + suffix);
        }
        return session.getProperty("mail.smtp." + suffix);
    }

    private static String _sanitizeCRLF(String text) {
        return StringUtil.replace((String)text, (char[])new char[]{'\n', '\r'}, (char[])new char[]{' ', ' '});
    }

    private static void _send(Session session, Message message, InternetAddress[] bulkAddresses, int batchSize, boolean throwsExceptionOnFailure) throws PortalException {
        block14: {
            if (_DATA_LIMIT_MAIL_MESSAGE_MAX_PERIOD > 0L && _DATA_LIMIT_MAIL_MESSAGE_MAX_COUNT > 0L) {
                AtomicLong mailMessageCount;
                long currentTime = System.currentTimeMillis();
                if ((currentTime - _lastResetTime.get()) / 1000L > _DATA_LIMIT_MAIL_MESSAGE_MAX_PERIOD) {
                    _mailMessageCounts.clear();
                    _lastResetTime.set(currentTime);
                }
                if ((mailMessageCount = _mailMessageCounts.computeIfAbsent(CompanyThreadLocal.getCompanyId(), id -> new AtomicLong())).incrementAndGet() > _DATA_LIMIT_MAIL_MESSAGE_MAX_COUNT) {
                    throw new PortalException("Unable to exceed maximum number of allowed mail messages");
                }
            }
            try {
                boolean smtpAuth = GetterUtil.getBoolean((String)MailEngine._getSMTPProperty(session, "auth"));
                String smtpHost = MailEngine._getSMTPProperty(session, "host");
                int smtpPort = GetterUtil.getInteger((String)MailEngine._getSMTPProperty(session, "port"), (int)25);
                String user = MailEngine._getSMTPProperty(session, "user");
                String password = MailEngine._getSMTPProperty(session, "password");
                if (smtpAuth && Validator.isNotNull((String)user) && Validator.isNotNull((String)password)) {
                    Object[] batchAddresses;
                    String protocol = GetterUtil.getString((String)session.getProperty("mail.transport.protocol"), (String)"smtp");
                    Transport transport = session.getTransport(protocol);
                    transport.connect(smtpHost, smtpPort, user, password);
                    Object[] addresses = null;
                    addresses = ArrayUtil.isNotEmpty((Object[])bulkAddresses) ? bulkAddresses : message.getAllRecipients();
                    int i = 0;
                    while (!ArrayUtil.isEmpty((Object[])(batchAddresses = MailEngine._getBatchAddresses((Address[])addresses, i, batchSize)))) {
                        transport.sendMessage(message, (Address[])batchAddresses);
                        ++i;
                    }
                    transport.close();
                } else if (ArrayUtil.isNotEmpty((Object[])bulkAddresses)) {
                    int curBatch = 0;
                    Object[] portion = MailEngine._getBatchAddresses((Address[])bulkAddresses, curBatch, batchSize);
                    while (ArrayUtil.isNotEmpty((Object[])portion)) {
                        Transport.send((Message)message, (Address[])portion);
                        portion = MailEngine._getBatchAddresses((Address[])bulkAddresses, ++curBatch, batchSize);
                    }
                } else {
                    Transport.send((Message)message);
                }
            }
            catch (MessagingException messagingException) {
                if (messagingException.getNextException() instanceof SocketException) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Unable to connect to a valid mail server. Please make sure one is properly configured: " + messagingException.getMessage()));
                    }
                } else {
                    LogUtil.log((Log)_log, (Throwable)messagingException, (String)("Unable to send message: " + messagingException.getMessage()));
                }
                if (!throwsExceptionOnFailure) break block14;
                throw new PortalException((Throwable)messagingException);
            }
        }
    }

    private static void _validateAddress(Address address) throws AddressException {
        if (address == null) {
            throw new AddressException("Email address is null");
        }
        String addressString = address.toString();
        for (char c : addressString.toCharArray()) {
            if (c != '\n' && c != '\r') continue;
            throw new AddressException(StringBundler.concat((String[])new String[]{"Email address ", addressString, " is invalid because it contains line breaks"}));
        }
    }

    private static void _validateAddresses(Address[] addresses) throws AddressException {
        if (addresses == null) {
            throw new AddressException();
        }
        for (Address internetAddress : addresses) {
            MailEngine._validateAddress(internetAddress);
        }
    }

    private static class LiferayMimeMessage
    extends MimeMessage {
        protected void updateMessageID() throws MessagingException {
            Object[] messageIds = this.getHeader("Message-ID");
            if (ArrayUtil.isNotEmpty((Object[])messageIds)) {
                return;
            }
            super.updateMessageID();
        }

        private LiferayMimeMessage(Session session) {
            super(session);
        }
    }
}

