/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.layout.utility.page.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ExternalReferenceCodeModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedGroupedModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the LayoutUtilityPageEntry service. Represents a row in the &quot;LayoutUtilityPageEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.layout.utility.page.model.impl.LayoutUtilityPageEntryModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.layout.utility.page.model.impl.LayoutUtilityPageEntryImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LayoutUtilityPageEntry
 * @generated
 */
@ProviderType
public interface LayoutUtilityPageEntryModel
	extends BaseModel<LayoutUtilityPageEntry>, CTModel<LayoutUtilityPageEntry>,
			ExternalReferenceCodeModel, MVCCModel, ShardedModel,
			StagedGroupedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a layout utility page entry model instance should use the {@link LayoutUtilityPageEntry} interface instead.
	 */

	/**
	 * Returns the primary key of this layout utility page entry.
	 *
	 * @return the primary key of this layout utility page entry
	 */
	@Override
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this layout utility page entry.
	 *
	 * @param primaryKey the primary key of this layout utility page entry
	 */
	@Override
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this layout utility page entry.
	 *
	 * @return the mvcc version of this layout utility page entry
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this layout utility page entry.
	 *
	 * @param mvccVersion the mvcc version of this layout utility page entry
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the ct collection ID of this layout utility page entry.
	 *
	 * @return the ct collection ID of this layout utility page entry
	 */
	@Override
	public long getCtCollectionId();

	/**
	 * Sets the ct collection ID of this layout utility page entry.
	 *
	 * @param ctCollectionId the ct collection ID of this layout utility page entry
	 */
	@Override
	public void setCtCollectionId(long ctCollectionId);

	/**
	 * Returns the uuid of this layout utility page entry.
	 *
	 * @return the uuid of this layout utility page entry
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this layout utility page entry.
	 *
	 * @param uuid the uuid of this layout utility page entry
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the external reference code of this layout utility page entry.
	 *
	 * @return the external reference code of this layout utility page entry
	 */
	@AutoEscape
	@Override
	public String getExternalReferenceCode();

	/**
	 * Sets the external reference code of this layout utility page entry.
	 *
	 * @param externalReferenceCode the external reference code of this layout utility page entry
	 */
	@Override
	public void setExternalReferenceCode(String externalReferenceCode);

	/**
	 * Returns the layout utility page entry ID of this layout utility page entry.
	 *
	 * @return the layout utility page entry ID of this layout utility page entry
	 */
	public long getLayoutUtilityPageEntryId();

	/**
	 * Sets the layout utility page entry ID of this layout utility page entry.
	 *
	 * @param LayoutUtilityPageEntryId the layout utility page entry ID of this layout utility page entry
	 */
	public void setLayoutUtilityPageEntryId(long LayoutUtilityPageEntryId);

	/**
	 * Returns the group ID of this layout utility page entry.
	 *
	 * @return the group ID of this layout utility page entry
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this layout utility page entry.
	 *
	 * @param groupId the group ID of this layout utility page entry
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this layout utility page entry.
	 *
	 * @return the company ID of this layout utility page entry
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this layout utility page entry.
	 *
	 * @param companyId the company ID of this layout utility page entry
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this layout utility page entry.
	 *
	 * @return the user ID of this layout utility page entry
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this layout utility page entry.
	 *
	 * @param userId the user ID of this layout utility page entry
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this layout utility page entry.
	 *
	 * @return the user uuid of this layout utility page entry
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this layout utility page entry.
	 *
	 * @param userUuid the user uuid of this layout utility page entry
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this layout utility page entry.
	 *
	 * @return the user name of this layout utility page entry
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this layout utility page entry.
	 *
	 * @param userName the user name of this layout utility page entry
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this layout utility page entry.
	 *
	 * @return the create date of this layout utility page entry
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this layout utility page entry.
	 *
	 * @param createDate the create date of this layout utility page entry
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this layout utility page entry.
	 *
	 * @return the modified date of this layout utility page entry
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this layout utility page entry.
	 *
	 * @param modifiedDate the modified date of this layout utility page entry
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the plid of this layout utility page entry.
	 *
	 * @return the plid of this layout utility page entry
	 */
	public long getPlid();

	/**
	 * Sets the plid of this layout utility page entry.
	 *
	 * @param plid the plid of this layout utility page entry
	 */
	public void setPlid(long plid);

	/**
	 * Returns the preview file entry ID of this layout utility page entry.
	 *
	 * @return the preview file entry ID of this layout utility page entry
	 */
	public long getPreviewFileEntryId();

	/**
	 * Sets the preview file entry ID of this layout utility page entry.
	 *
	 * @param previewFileEntryId the preview file entry ID of this layout utility page entry
	 */
	public void setPreviewFileEntryId(long previewFileEntryId);

	/**
	 * Returns the default layout utility page entry of this layout utility page entry.
	 *
	 * @return the default layout utility page entry of this layout utility page entry
	 */
	public boolean getDefaultLayoutUtilityPageEntry();

	/**
	 * Returns <code>true</code> if this layout utility page entry is default layout utility page entry.
	 *
	 * @return <code>true</code> if this layout utility page entry is default layout utility page entry; <code>false</code> otherwise
	 */
	public boolean isDefaultLayoutUtilityPageEntry();

	/**
	 * Sets whether this layout utility page entry is default layout utility page entry.
	 *
	 * @param defaultLayoutUtilityPageEntry the default layout utility page entry of this layout utility page entry
	 */
	public void setDefaultLayoutUtilityPageEntry(
		boolean defaultLayoutUtilityPageEntry);

	/**
	 * Returns the name of this layout utility page entry.
	 *
	 * @return the name of this layout utility page entry
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this layout utility page entry.
	 *
	 * @param name the name of this layout utility page entry
	 */
	public void setName(String name);

	/**
	 * Returns the type of this layout utility page entry.
	 *
	 * @return the type of this layout utility page entry
	 */
	@AutoEscape
	public String getType();

	/**
	 * Sets the type of this layout utility page entry.
	 *
	 * @param type the type of this layout utility page entry
	 */
	public void setType(String type);

	/**
	 * Returns the last publish date of this layout utility page entry.
	 *
	 * @return the last publish date of this layout utility page entry
	 */
	@Override
	public Date getLastPublishDate();

	/**
	 * Sets the last publish date of this layout utility page entry.
	 *
	 * @param lastPublishDate the last publish date of this layout utility page entry
	 */
	@Override
	public void setLastPublishDate(Date lastPublishDate);

	@Override
	public LayoutUtilityPageEntry cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}