/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.utility.page.exception;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;

public class LayoutUtilityPageEntryNameException
extends PortalException {
    private LayoutUtilityPageEntryNameException(String msg) {
        super(msg);
    }

    public static class MustNotExceedMaximumSize
    extends LayoutUtilityPageEntryNameException {
        public MustNotExceedMaximumSize(int maxLength) {
            super("Maximum length of name exceeded " + maxLength);
        }
    }

    public static class MustNotContainInvalidCharacters
    extends LayoutUtilityPageEntryNameException {
        public final char character;

        public MustNotContainInvalidCharacters(char character) {
            super("Invalid character in name " + character);
            this.character = character;
        }
    }

    public static class MustNotBeNull
    extends LayoutUtilityPageEntryNameException {
        public MustNotBeNull(long groupId) {
            super("Name must not be null for group " + groupId);
        }
    }

    public static class MustNotBeDuplicate
    extends LayoutUtilityPageEntryNameException {
        public MustNotBeDuplicate(long groupId, String name) {
            super(String.format(StringBundler.concat((Object[])new Object[]{"Duplicate utility page for group ", groupId, " with name ", name}), new Object[0]));
        }
    }
}

