/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.layout.item.selector;

import com.liferay.item.selector.ItemSelectorReturnType;

/**
 * This return type should return the following information of a layout page
 * template entry as a JSON object:
 *
 * <ul>
 * <li>
 * <code>layoutId</code>: The layoutId of the selected layout
 * </li>
 * <li>
 * <code>name</code>: The name of the selected layout
 * </li>
 * <li>
 * <code>plid</code>: The plid of the selected layout
 * </li>
 * <li>
 * <code>private</code>: Is true if the layout is private, false another case
 * </li>
 * <li>
 * <code>url</code>: The URL of the selected layout
 * </li>
 * <li>
 * <code>uuid</code>: The UUID of the selected layout
 * </li>
 * </ul>
 *
 * @author Lourdes Fernández Besada
 */
public class LayoutItemSelectorReturnType implements ItemSelectorReturnType {
}