/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.service.persistence.impl;

import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBArticleTable;
import com.liferay.knowledge.base.model.impl.KBArticleImpl;
import com.liferay.knowledge.base.service.persistence.KBArticleFinder;
import com.liferay.knowledge.base.service.persistence.impl.KBArticleFinderBaseImpl;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.OrderByStep;
import com.liferay.petra.sql.dsl.query.sort.OrderByExpression;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Iterator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={KBArticleFinder.class})
public class KBArticleFinderImpl
extends KBArticleFinderBaseImpl
implements KBArticleFinder {
    private static final String _COUNT_BY_URL_TITLE = KBArticleFinder.class.getName() + ".countByUrlTitle";
    private static final String _FIND_BY_URL_TITLE = KBArticleFinder.class.getName() + ".findByUrlTitle";
    @Reference
    private CustomSQL _customSQL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countByUrlTitle(long groupId, String kbFolderUrlTitle, String kbArticleUrlTitle, int[] status) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = this._customSQL.get(KBArticleFinderImpl.class, _COUNT_BY_URL_TITLE);
            sql = this.replaceWorkflowStatus(sql, status);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(kbArticleUrlTitle);
            queryPos.add(kbFolderUrlTitle);
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    public int filterCountByKeywords(long groupId, String keywords, int status) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery((DSLQuery)this._getOrderByStep(DSLQueryFactoryUtil.select((Expression[])new Expression[]{DSLFunctionFactoryUtil.count((Expression)KBArticleTable.INSTANCE.kbArticleId).as("COUNT_VALUE")}), groupId, keywords, status));
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<KBArticle> filterFindByKeywords(long groupId, String keywords, int status, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            OrderByStep orderByStep = this._getOrderByStep(DSLQueryFactoryUtil.select((Table)KBArticleTable.INSTANCE), groupId, keywords, status);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery((DSLQuery)orderByStep.orderBy(new OrderByExpression[]{KBArticleTable.INSTANCE.priority.ascending()}));
            sqlQuery.addEntity("KBArticle", KBArticleImpl.class);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KBArticle> findByUrlTitle(long groupId, String kbFolderUrlTitle, String kbArticleUrlTitle, int[] status, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(KBArticleFinderImpl.class, _FIND_BY_URL_TITLE);
            sql = this.replaceWorkflowStatus(sql, status);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("KBArticle", KBArticleImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(kbArticleUrlTitle);
            queryPos.add(kbFolderUrlTitle);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String replaceWorkflowStatus(String sql, int[] status) {
        StringBundler sb = new StringBundler(status.length);
        for (int i = 0; i < status.length; ++i) {
            sb.append(status[i]);
            if (i == status.length - 1) continue;
            sb.append(", ");
        }
        return StringUtil.replace((String)sql, (String)"[$WORKFLOW_STATUS$]", (String)sb.toString());
    }

    private Predicate _getKeywordsPredicate(Expression<String> expression, String[] keywords) {
        expression = DSLFunctionFactoryUtil.lower(expression);
        Predicate keywordsPredicate = null;
        for (String keyword : keywords) {
            if (keyword == null) continue;
            Predicate keywordPredicate = expression.like(keyword);
            keywordsPredicate = keywordsPredicate == null ? keywordPredicate : keywordsPredicate.or((Expression)keywordPredicate);
        }
        return keywordsPredicate;
    }

    private OrderByStep _getOrderByStep(FromStep fromStep, long groupId, String keywords, int status) {
        return fromStep.from((Table)KBArticleTable.INSTANCE).where(KBArticleTable.INSTANCE.groupId.eq((Object)groupId).and((Expression)InlineSQLHelperUtil.getPermissionWherePredicate(KBArticle.class, (Column)KBArticleTable.INSTANCE.kbArticleId, (long[])new long[]{groupId})).and(() -> {
            if (Validator.isNull((String)keywords)) {
                return null;
            }
            String[] keywordsArray = this._customSQL.keywords(keywords, true);
            return Predicate.withParentheses((Predicate)this._getKeywordsPredicate((Expression<String>)KBArticleTable.INSTANCE.title, keywordsArray).or((Expression)this._getKeywordsPredicate((Expression<String>)DSLFunctionFactoryUtil.castClobText((Expression)KBArticleTable.INSTANCE.content), keywordsArray)));
        }).and(() -> {
            if (status == -1) {
                return KBArticleTable.INSTANCE.latest.eq((Object)Boolean.TRUE);
            }
            return KBArticleTable.INSTANCE.status.eq((Object)status);
        }));
    }
}

