/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.service.impl;

import com.liferay.knowledge.base.internal.helper.KBArticleSiblingNavigationHelper;
import com.liferay.knowledge.base.internal.util.KBSectionEscapeUtil;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBArticleSearchDisplay;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.model.impl.KBArticleSearchDisplayImpl;
import com.liferay.knowledge.base.service.KBFolderService;
import com.liferay.knowledge.base.service.base.KBArticleServiceBaseImpl;
import com.liferay.knowledge.base.util.KnowledgeBaseUtil;
import com.liferay.knowledge.base.util.comparator.KBArticleModifiedDateComparator;
import com.liferay.knowledge.base.util.comparator.KBArticlePriorityComparator;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HtmlParser;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.rss.export.RSSExporter;
import com.liferay.rss.model.SyndContent;
import com.liferay.rss.model.SyndEntry;
import com.liferay.rss.model.SyndFeed;
import com.liferay.rss.model.SyndLink;
import com.liferay.rss.model.SyndModelFactory;
import com.liferay.rss.util.RSSUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=kb", "json.web.service.context.path=KBArticle"}, service={AopService.class})
public class KBArticleServiceImpl
extends KBArticleServiceBaseImpl {
    private static final int _INTERVAL = 200;
    @Reference(target="(resource.name=com.liferay.knowledge.base.admin)")
    private PortletResourcePermission _adminPortletResourcePermission;
    @Reference(target="(resource.name=com.liferay.knowledge.base.display)")
    private PortletResourcePermission _displayPortletResourcePermission;
    @Reference
    private HtmlParser _htmlParser;
    @Reference(target="(model.class.name=com.liferay.knowledge.base.model.KBArticle)")
    private ModelResourcePermission<KBArticle> _kbArticleModelResourcePermission;
    @Reference
    private KBFolderService _kbFolderService;
    @Reference
    private Portal _portal;
    @Reference
    private RSSExporter _rssExporter;
    @Reference
    private SyndModelFactory _syndModelFactory;

    public KBArticle addKBArticle(String externalReferenceCode, String portletId, long parentResourceClassNameId, long parentResourcePrimKey, String title, String urlTitle, String content, String description, String[] sections, String sourceURL, Date displayDate, Date expirationDate, Date reviewDate, String[] selectedFileNames, ServiceContext serviceContext) throws PortalException {
        this._checkKBArticlePermissions(portletId, serviceContext);
        return this.kbArticleLocalService.addKBArticle(externalReferenceCode, this.getUserId(), parentResourceClassNameId, parentResourcePrimKey, title, urlTitle, content, description, sections, sourceURL, displayDate, expirationDate, reviewDate, selectedFileNames, serviceContext);
    }

    public int addKBArticlesMarkdown(long groupId, long parentKBFolderId, String fileName, boolean prioritizeByNumericalPrefix, InputStream inputStream, ServiceContext serviceContext) throws PortalException {
        this._adminPortletResourcePermission.check(this.getPermissionChecker(), groupId, "IMPORT_KB_ARTICLES");
        return this.kbArticleLocalService.addKBArticlesMarkdown(this.getUserId(), groupId, parentKBFolderId, fileName, prioritizeByNumericalPrefix, inputStream, serviceContext);
    }

    public void addTempAttachment(long groupId, long resourcePrimKey, String fileName, String tempFolderName, InputStream inputStream, String mimeType) throws PortalException {
        this._checkAttachmentPermissions(groupId, "com_liferay_knowledge_base_web_portlet_AdminPortlet", resourcePrimKey);
        this.kbArticleLocalService.addTempAttachment(groupId, this.getUserId(), fileName, tempFolderName, inputStream, mimeType);
    }

    public int countKBArticlesByKeywords(long groupId, String keywords, int status) {
        return this.kbArticleFinder.filterCountByKeywords(groupId, keywords, status);
    }

    public KBArticle deleteKBArticle(long resourcePrimKey) throws PortalException {
        this._kbArticleModelResourcePermission.check(this.getPermissionChecker(), resourcePrimKey, "DELETE");
        return this.kbArticleLocalService.deleteKBArticle(resourcePrimKey);
    }

    public void deleteKBArticles(long groupId, long[] resourcePrimKeys) throws PortalException {
        this._adminPortletResourcePermission.check(this.getPermissionChecker(), groupId, "DELETE_KB_ARTICLES");
        this.kbArticleLocalService.deleteKBArticles(resourcePrimKeys);
    }

    public void deleteTempAttachment(long groupId, long resourcePrimKey, String fileName, String tempFolderName) throws PortalException {
        this._checkAttachmentPermissions(groupId, "com_liferay_knowledge_base_web_portlet_AdminPortlet", resourcePrimKey);
        this.kbArticleLocalService.deleteTempAttachment(groupId, this.getUserId(), fileName, tempFolderName);
    }

    public KBArticle expireKBArticle(long resourcePrimKey, ServiceContext serviceContext) throws PortalException {
        this._kbArticleModelResourcePermission.check(this.getPermissionChecker(), resourcePrimKey, "UPDATE");
        return this.kbArticleLocalService.expireKBArticle(this.getUserId(), resourcePrimKey, serviceContext);
    }

    public KBArticle fetchFirstChildKBArticle(long groupId, long parentResourcePrimKey) {
        List kbArticles = this.kbArticlePersistence.filterFindByG_P_L(groupId, parentResourcePrimKey, true, 0, 1, (OrderByComparator)new KBArticlePriorityComparator(true));
        if (kbArticles.isEmpty()) {
            return null;
        }
        return (KBArticle)kbArticles.get(0);
    }

    public KBArticle fetchFirstChildKBArticle(long groupId, long parentResourcePrimKey, int status) {
        List kbArticles = this.kbArticlePersistence.filterFindByG_P_L_S(groupId, parentResourcePrimKey, true, 0, 0, 1, (OrderByComparator)new KBArticlePriorityComparator(true));
        if (kbArticles.isEmpty()) {
            return null;
        }
        return (KBArticle)kbArticles.get(0);
    }

    public KBArticle fetchKBArticleByUrlTitle(long groupId, long kbFolderId, String urlTitle) throws PortalException {
        KBArticle kbArticle = this.kbArticleLocalService.fetchKBArticleByUrlTitle(groupId, kbFolderId, urlTitle);
        if (kbArticle != null && this._kbArticleModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)kbArticle, "VIEW")) {
            return kbArticle;
        }
        return null;
    }

    public KBArticle fetchLatestKBArticle(long resourcePrimKey, int status) throws PortalException {
        KBArticle kbArticle = this.kbArticleLocalService.fetchLatestKBArticle(resourcePrimKey, status);
        if (kbArticle != null && this._kbArticleModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)kbArticle, "VIEW")) {
            return kbArticle;
        }
        return null;
    }

    public KBArticle fetchLatestKBArticleByExternalReferenceCode(long groupId, String externalReferenceCode) throws PortalException {
        KBArticle kbArticle = this.kbArticleLocalService.fetchLatestKBArticleByExternalReferenceCode(groupId, externalReferenceCode);
        if (kbArticle != null && this._kbArticleModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)kbArticle, "VIEW")) {
            return kbArticle;
        }
        return null;
    }

    public KBArticle fetchLatestKBArticleByUrlTitle(long groupId, long kbFolderId, String urlTitle, int status) throws PortalException {
        KBArticle kbArticle = this.kbArticleLocalService.fetchLatestKBArticleByUrlTitle(groupId, kbFolderId, urlTitle, status);
        if (kbArticle != null && this._kbArticleModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)kbArticle, "VIEW")) {
            return kbArticle;
        }
        return null;
    }

    public List<KBArticle> getAllDescendantKBArticles(long groupId, long resourcePrimKey, int status, OrderByComparator<KBArticle> orderByComparator) throws PortalException {
        groupId = this._checkGroupId(groupId, resourcePrimKey);
        return this._getAllDescendantKBArticles(groupId, resourcePrimKey, status, orderByComparator, false);
    }

    public List<KBArticle> getGroupKBArticles(long groupId, int status, int start, int end, OrderByComparator<KBArticle> orderByComparator) {
        if (status == -1) {
            return this.kbArticlePersistence.filterFindByG_L(groupId, true, start, end, orderByComparator);
        }
        if (status == 0) {
            return this.kbArticlePersistence.filterFindByG_M(groupId, true, start, end, orderByComparator);
        }
        return this.kbArticlePersistence.filterFindByG_S(groupId, status, start, end, orderByComparator);
    }

    public int getGroupKBArticlesCount(long groupId, int status) {
        if (status == -1) {
            return this.kbArticlePersistence.filterCountByG_L(groupId, true);
        }
        if (status == 0) {
            return this.kbArticlePersistence.filterCountByG_M(groupId, true);
        }
        return this.kbArticlePersistence.filterCountByG_S(groupId, status);
    }

    public String getGroupKBArticlesRSS(int status, int max, String type, double version, String displayStyle, ThemeDisplay themeDisplay) throws PortalException {
        String descriptiveName;
        Group group = themeDisplay.getScopeGroup();
        String name = descriptiveName = HtmlUtil.escape((String)group.getDescriptiveName(themeDisplay.getLocale()));
        String description = descriptiveName;
        String feedURL = this._portal.getLayoutFullURL(themeDisplay);
        List<KBArticle> kbArticles = this.getGroupKBArticles(group.getGroupId(), status, 0, max, (OrderByComparator<KBArticle>)new KBArticleModifiedDateComparator());
        return this._exportToRSS(name, description, feedURL, kbArticles, type, version, displayStyle, themeDisplay);
    }

    public KBArticle getKBArticle(long resourcePrimKey, int version) throws PortalException {
        this._kbArticleModelResourcePermission.check(this.getPermissionChecker(), resourcePrimKey, "VIEW");
        return this.kbArticleLocalService.getKBArticle(resourcePrimKey, version);
    }

    public List<KBArticle> getKBArticleAndAllDescendantKBArticles(long resourcePrimKey, int status, OrderByComparator<KBArticle> orderByComparator) throws PortalException {
        return this._getAllDescendantKBArticles(0L, resourcePrimKey, status, orderByComparator, true);
    }

    public String getKBArticleRSS(long resourcePrimKey, int status, int max, String type, double version, String displayStyle, ThemeDisplay themeDisplay) throws PortalException {
        KBArticle kbArticle = this.kbArticleLocalService.getLatestKBArticle(resourcePrimKey, status);
        String name = kbArticle.getTitle();
        String description = kbArticle.getTitle();
        String feedURL = KnowledgeBaseUtil.getKBArticleURL((long)themeDisplay.getPlid(), (long)resourcePrimKey, (int)status, (String)themeDisplay.getPortalURL(), (boolean)false);
        List<KBArticle> kbArticles = this.getAllDescendantKBArticles(0L, resourcePrimKey, status, (OrderByComparator<KBArticle>)new KBArticleModifiedDateComparator());
        return this._exportToRSS(name, description, feedURL, ListUtil.subList(kbArticles, (int)0, (int)max), type, version, displayStyle, themeDisplay);
    }

    public List<KBArticle> getKBArticles(long groupId, long parentResourcePrimKey, int status, int start, int end, OrderByComparator<KBArticle> orderByComparator) {
        if (status == -1) {
            return this.kbArticlePersistence.filterFindByG_P_L(groupId, parentResourcePrimKey, true, start, end, orderByComparator);
        }
        if (status == 0) {
            return this.kbArticlePersistence.filterFindByG_P_M(groupId, parentResourcePrimKey, true, start, end, orderByComparator);
        }
        return this.kbArticlePersistence.filterFindByG_P_S(groupId, parentResourcePrimKey, status, start, end, orderByComparator);
    }

    public List<KBArticle> getKBArticles(long groupId, long[] resourcePrimKeys, int status, int start, int end, OrderByComparator<KBArticle> orderByComparator) {
        List kbArticles = new ArrayList();
        Long[][] params = new Long[][]{ArrayUtil.toArray((long[])resourcePrimKeys)};
        while ((params = KnowledgeBaseUtil.getParams((Long[])params[0])) != null) {
            List curKBArticles = null;
            curKBArticles = status == -1 ? this.kbArticlePersistence.filterFindByR_G_L(ArrayUtil.toArray((Long[])params[1]), groupId, true, start, end) : (status == 0 ? this.kbArticlePersistence.filterFindByR_G_M(ArrayUtil.toArray((Long[])params[1]), groupId, true, start, end) : this.kbArticlePersistence.filterFindByR_G_S(ArrayUtil.toArray((Long[])params[1]), groupId, status, start, end));
            kbArticles.addAll(curKBArticles);
        }
        kbArticles = orderByComparator != null ? ListUtil.sort(kbArticles, orderByComparator) : KnowledgeBaseUtil.sort((long[])resourcePrimKeys, kbArticles);
        return Collections.unmodifiableList(kbArticles);
    }

    public List<KBArticle> getKBArticles(long groupId, long[] resourcePrimKeys, int status, OrderByComparator<KBArticle> orderByComparator) {
        return this.getKBArticles(groupId, resourcePrimKeys, status, -1, -1, orderByComparator);
    }

    public List<KBArticle> getKBArticlesByKeywords(long groupId, String keywords, int status, int start, int end) {
        return this.kbArticleFinder.filterFindByKeywords(groupId, keywords, status, start, end);
    }

    public int getKBArticlesCount(long groupId, long parentResourcePrimKey, int status) {
        if (status == -1) {
            return this.kbArticlePersistence.filterCountByG_P_L(groupId, parentResourcePrimKey, true);
        }
        if (status == 0) {
            return this.kbArticlePersistence.filterCountByG_P_M(groupId, parentResourcePrimKey, true);
        }
        return this.kbArticlePersistence.filterCountByG_P_S(groupId, parentResourcePrimKey, status);
    }

    public int getKBArticlesCount(long groupId, long[] resourcePrimKeys, int status) {
        int count = 0;
        Long[][] params = new Long[][]{ArrayUtil.toArray((long[])resourcePrimKeys)};
        while ((params = KnowledgeBaseUtil.getParams((Long[])params[0])) != null) {
            if (status == -1) {
                count += this.kbArticlePersistence.filterCountByR_G_L(ArrayUtil.toArray((Long[])params[1]), groupId, true);
                continue;
            }
            if (status == 0) {
                count += this.kbArticlePersistence.filterCountByR_G_M(ArrayUtil.toArray((Long[])params[1]), groupId, true);
                continue;
            }
            count += this.kbArticlePersistence.filterCountByR_G_S(ArrayUtil.toArray((Long[])params[1]), groupId, status);
        }
        return count;
    }

    public KBArticleSearchDisplay getKBArticleSearchDisplay(long groupId, String title, String content, int status, Date startDate, Date endDate, boolean andOperator, int[] curStartValues, int cur, int delta, OrderByComparator<KBArticle> orderByComparator) throws PortalException {
        List curKBArticles;
        int start = 0;
        if (curStartValues.length > cur - 1) {
            start = curStartValues[cur - 1];
            curStartValues = ArrayUtil.subset((int[])curStartValues, (int)0, (int)(cur - 1 + 1));
        } else {
            cur = 1;
            curStartValues = new int[]{0};
        }
        int end = start + 200;
        ArrayList<KBArticle> kbArticles = new ArrayList<KBArticle>();
        int curStartValue = 0;
        while (curStartValue == 0 && !(curKBArticles = this.kbArticleLocalService.search(groupId, title, content, status, startDate, endDate, andOperator, start, end, orderByComparator)).isEmpty()) {
            for (int i = 0; i < curKBArticles.size(); ++i) {
                KBArticle curKBArticle = (KBArticle)curKBArticles.get(i);
                if (!this._kbArticleModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)curKBArticle, "VIEW")) continue;
                if (kbArticles.size() == delta) {
                    curStartValue = start + i;
                    break;
                }
                kbArticles.add(curKBArticle);
            }
            end = (start += 200) + 200;
        }
        int total = (cur - 1) * delta + kbArticles.size();
        if (curStartValue > 0) {
            curStartValues = ArrayUtil.append((int[])curStartValues, (int)curStartValue);
            ++total;
        }
        return new KBArticleSearchDisplayImpl(kbArticles, total, curStartValues);
    }

    public List<KBArticle> getKBArticleVersions(long groupId, long resourcePrimKey, int status, int start, int end, OrderByComparator<KBArticle> orderByComparator) {
        if (status == -1) {
            return this.kbArticlePersistence.filterFindByR_G(resourcePrimKey, groupId, start, end, orderByComparator);
        }
        return this.kbArticlePersistence.filterFindByR_G_S(resourcePrimKey, groupId, status, start, end, orderByComparator);
    }

    public int getKBArticleVersionsCount(long groupId, long resourcePrimKey, int status) {
        if (status == -1) {
            return this.kbArticlePersistence.filterCountByR_G(resourcePrimKey, groupId);
        }
        return this.kbArticlePersistence.filterCountByR_G_S(resourcePrimKey, groupId, status);
    }

    public KBArticle getLatestKBArticle(long resourcePrimKey, int status) throws PortalException {
        this._kbArticleModelResourcePermission.check(this.getPermissionChecker(), resourcePrimKey, "VIEW");
        return this.kbArticleLocalService.getLatestKBArticle(resourcePrimKey, status);
    }

    public KBArticle getLatestKBArticleByExternalReferenceCode(long groupId, String externalReferenceCode) throws PortalException {
        KBArticle kbArticle = this.kbArticleLocalService.getLatestKBArticleByExternalReferenceCode(groupId, externalReferenceCode);
        this._kbArticleModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)kbArticle, "VIEW");
        return kbArticle;
    }

    public KBArticle[] getPreviousAndNextKBArticles(long kbArticleId) throws PortalException {
        KBArticle kbArticle = this.kbArticlePersistence.findByPrimaryKey(kbArticleId);
        this._kbArticleModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)kbArticle, "VIEW");
        KBArticleSiblingNavigationHelper kbArticleSiblingNavigationHelper = new KBArticleSiblingNavigationHelper(this.kbArticlePersistence);
        return kbArticleSiblingNavigationHelper.getPreviousAndNextKBArticles(kbArticleId);
    }

    public List<KBArticle> getSectionsKBArticles(long groupId, String[] sections, int status, int start, int end, OrderByComparator<KBArticle> orderByComparator) {
        String[] array = KBSectionEscapeUtil.escapeSections(sections);
        for (int i = 0; i < array.length; ++i) {
            array[i] = StringUtil.quote((String)array[i], (String)"%");
        }
        if (status == -1) {
            return this.kbArticlePersistence.filterFindByG_LikeS_L(groupId, array, true, start, end, orderByComparator);
        }
        if (status == 0) {
            return this.kbArticlePersistence.filterFindByG_LikeS_M(groupId, array, true, start, end, orderByComparator);
        }
        return this.kbArticlePersistence.filterFindByG_LikeS_S(groupId, array, status, start, end, orderByComparator);
    }

    public int getSectionsKBArticlesCount(long groupId, String[] sections, int status) {
        String[] array = KBSectionEscapeUtil.escapeSections(sections);
        for (int i = 0; i < array.length; ++i) {
            array[i] = StringUtil.quote((String)array[i], (String)"%");
        }
        if (status == -1) {
            return this.kbArticlePersistence.filterCountByG_LikeS_L(groupId, array, true);
        }
        if (status == 0) {
            return this.kbArticlePersistence.filterCountByG_LikeS_M(groupId, array, true);
        }
        return this.kbArticlePersistence.filterCountByG_LikeS_S(groupId, array, status);
    }

    public String[] getTempAttachmentNames(long groupId, String tempFolderName) throws PortalException {
        return this.kbArticleLocalService.getTempAttachmentNames(groupId, this.getUserId(), tempFolderName);
    }

    public void moveKBArticle(long resourcePrimKey, long parentResourceClassNameId, long parentResourcePrimKey, double priority) throws PortalException {
        this._kbArticleModelResourcePermission.check(this.getPermissionChecker(), resourcePrimKey, "MOVE_KB_ARTICLE");
        this.kbArticleLocalService.moveKBArticle(this.getUserId(), resourcePrimKey, parentResourceClassNameId, parentResourcePrimKey, priority);
    }

    public KBArticle revertKBArticle(long resourcePrimKey, int version, ServiceContext serviceContext) throws PortalException {
        this._kbArticleModelResourcePermission.check(this.getPermissionChecker(), resourcePrimKey, "UPDATE");
        return this.kbArticleLocalService.revertKBArticle(this.getUserId(), resourcePrimKey, version, serviceContext);
    }

    public void subscribeGroupKBArticles(long groupId, String portletId) throws PortalException {
        if (portletId.equals("com_liferay_knowledge_base_web_portlet_AdminPortlet")) {
            this._adminPortletResourcePermission.check(this.getPermissionChecker(), groupId, "SUBSCRIBE");
        } else if (portletId.equals("com_liferay_knowledge_base_web_portlet_DisplayPortlet")) {
            this._displayPortletResourcePermission.check(this.getPermissionChecker(), groupId, "SUBSCRIBE");
        }
        this.kbArticleLocalService.subscribeGroupKBArticles(this.getUserId(), groupId);
    }

    public void subscribeKBArticle(long groupId, long resourcePrimKey) throws PortalException {
        this._kbArticleModelResourcePermission.check(this.getPermissionChecker(), resourcePrimKey, "SUBSCRIBE");
        this.kbArticleLocalService.subscribeKBArticle(this.getUserId(), groupId, resourcePrimKey);
    }

    public void unsubscribeGroupKBArticles(long groupId, String portletId) throws PortalException {
        if (portletId.equals("com_liferay_knowledge_base_web_portlet_AdminPortlet")) {
            this._adminPortletResourcePermission.check(this.getPermissionChecker(), groupId, "SUBSCRIBE");
        } else if (portletId.equals("com_liferay_knowledge_base_web_portlet_DisplayPortlet")) {
            this._displayPortletResourcePermission.check(this.getPermissionChecker(), groupId, "SUBSCRIBE");
        }
        this.kbArticleLocalService.unsubscribeGroupKBArticles(this.getUserId(), groupId);
    }

    public void unsubscribeKBArticle(long resourcePrimKey) throws PortalException {
        this._kbArticleModelResourcePermission.check(this.getPermissionChecker(), resourcePrimKey, "SUBSCRIBE");
        this.kbArticleLocalService.unsubscribeKBArticle(this.getUserId(), resourcePrimKey);
    }

    public KBArticle updateKBArticle(long resourcePrimKey, String title, String content, String description, String[] sections, String sourceURL, Date displayDate, Date expirationDate, Date reviewDate, String[] selectedFileNames, long[] removeFileEntryIds, ServiceContext serviceContext) throws PortalException {
        this._kbArticleModelResourcePermission.check(this.getPermissionChecker(), resourcePrimKey, "UPDATE");
        return this.kbArticleLocalService.updateKBArticle(this.getUserId(), resourcePrimKey, title, content, description, sections, sourceURL, displayDate, expirationDate, reviewDate, selectedFileNames, removeFileEntryIds, serviceContext);
    }

    public void updateKBArticlesPriorities(long groupId, Map<Long, Double> resourcePrimKeyToPriorityMap) throws PortalException {
        this._adminPortletResourcePermission.check(this.getPermissionChecker(), groupId, "UPDATE_KB_ARTICLES_PRIORITIES");
        this.kbArticleLocalService.updateKBArticlesPriorities(resourcePrimKeyToPriorityMap);
    }

    private void _checkAttachmentPermissions(long groupId, String portletId, long resourcePrimKey) throws PortalException {
        if (resourcePrimKey <= 0L && portletId.equals("com_liferay_knowledge_base_web_portlet_AdminPortlet")) {
            this._adminPortletResourcePermission.check(this.getPermissionChecker(), groupId, "ADD_KB_ARTICLE");
        } else if (resourcePrimKey <= 0L && portletId.equals("com_liferay_knowledge_base_web_portlet_DisplayPortlet")) {
            this._displayPortletResourcePermission.check(this.getPermissionChecker(), groupId, "ADD_KB_ARTICLE");
        } else {
            this._kbArticleModelResourcePermission.check(this.getPermissionChecker(), resourcePrimKey, "UPDATE");
        }
    }

    private long _checkGroupId(long groupId, long resourcePrimKey) throws PortalException {
        if (groupId == 0L) {
            if (resourcePrimKey == 0L) {
                throw new PrincipalException();
            }
            KBArticle kbArticle = this.fetchLatestKBArticle(resourcePrimKey, -1);
            if (kbArticle != null) {
                return kbArticle.getGroupId();
            }
            KBFolder kbFolder = this._kbFolderService.fetchKBFolder(resourcePrimKey);
            if (kbFolder == null) {
                throw new PrincipalException();
            }
            return kbFolder.getGroupId();
        }
        if (resourcePrimKey == 0L) {
            return groupId;
        }
        KBArticle kbArticle = this.fetchLatestKBArticle(resourcePrimKey, -1);
        if (kbArticle != null) {
            if (kbArticle.getGroupId() != groupId) {
                throw new PrincipalException();
            }
            return kbArticle.getGroupId();
        }
        KBFolder kbFolder = this._kbFolderService.fetchKBFolder(resourcePrimKey);
        if (kbFolder == null || kbFolder.getGroupId() != groupId) {
            throw new PrincipalException();
        }
        return kbFolder.getGroupId();
    }

    private void _checkKBArticlePermissions(String portletId, ServiceContext serviceContext) throws PortalException {
        if (portletId.equals("com_liferay_knowledge_base_web_portlet_AdminPortlet")) {
            this._adminPortletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_KB_ARTICLE");
        } else if (portletId.equals("com_liferay_knowledge_base_web_portlet_DisplayPortlet")) {
            this._displayPortletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_KB_ARTICLE");
        }
    }

    private String _exportToRSS(String name, String description, String feedURL, List<KBArticle> kbArticles, String type, double version, String displayStyle, ThemeDisplay themeDisplay) {
        SyndFeed syndFeed = this._syndModelFactory.createSyndFeed();
        syndFeed.setDescription(description);
        ArrayList<SyndEntry> syndEntries = new ArrayList<SyndEntry>();
        syndFeed.setEntries(syndEntries);
        for (KBArticle kbArticle : kbArticles) {
            SyndEntry syndEntry = this._syndModelFactory.createSyndEntry();
            syndEntry.setAuthor(this._portal.getUserName((BaseModel)kbArticle));
            SyndContent syndContent = this._syndModelFactory.createSyndContent();
            syndContent.setType("html");
            String value = null;
            if (displayStyle.equals("abstract")) {
                value = this._htmlParser.extractText(kbArticle.getDescription());
                if (Validator.isNull((String)value)) {
                    value = StringUtil.shorten((String)this._htmlParser.extractText(kbArticle.getContent()), (int)200);
                }
            } else {
                value = displayStyle.equals("title") ? "" : StringUtil.replace((String)kbArticle.getContent(), (String[])new String[]{"href=\"/", "src=\"/"}, (String[])new String[]{"href=\"" + themeDisplay.getURLPortal() + "/", "src=\"" + themeDisplay.getURLPortal() + "/"});
            }
            syndContent.setValue(value);
            syndEntry.setDescription(syndContent);
            String link = KnowledgeBaseUtil.getKBArticleURL((long)themeDisplay.getPlid(), (long)kbArticle.getResourcePrimKey(), (int)kbArticle.getStatus(), (String)themeDisplay.getPortalURL(), (boolean)false);
            syndEntry.setLink(link);
            syndEntry.setPublishedDate(kbArticle.getCreateDate());
            syndEntry.setTitle(kbArticle.getTitle());
            syndEntry.setUpdatedDate(kbArticle.getModifiedDate());
            syndEntry.setUri(link);
            syndEntries.add(syndEntry);
        }
        syndFeed.setFeedType(RSSUtil.getFeedType((String)type, (double)version));
        ArrayList<SyndLink> syndLinks = new ArrayList<SyndLink>();
        syndFeed.setLinks(syndLinks);
        SyndLink selfSyndLink = this._syndModelFactory.createSyndLink();
        syndLinks.add(selfSyndLink);
        selfSyndLink.setHref(feedURL);
        selfSyndLink.setRel("self");
        syndFeed.setPublishedDate(new Date());
        syndFeed.setTitle(name);
        syndFeed.setUri(feedURL);
        return this._rssExporter.export(syndFeed);
    }

    private void _getAllDescendantKBArticles(List<KBArticle> kbArticles, long groupId, long resourcePrimKey, int status, OrderByComparator<KBArticle> orderByComparator) {
        List curKBArticles = null;
        curKBArticles = status == -1 ? this.kbArticlePersistence.filterFindByG_P_L(groupId, resourcePrimKey, true, -1, -1, orderByComparator) : (status == 0 ? this.kbArticlePersistence.findByG_P_M(groupId, resourcePrimKey, true, -1, -1, orderByComparator) : this.kbArticlePersistence.findByG_P_S(groupId, resourcePrimKey, status, -1, -1, orderByComparator));
        for (KBArticle curKBArticle : curKBArticles) {
            kbArticles.add(curKBArticle);
            this._getAllDescendantKBArticles(kbArticles, groupId, curKBArticle.getResourcePrimKey(), status, orderByComparator);
        }
    }

    private List<KBArticle> _getAllDescendantKBArticles(long groupId, long resourcePrimKey, int status, OrderByComparator<KBArticle> orderByComparator, boolean includeParentArticle) throws PortalException {
        List<Object> kbArticles = null;
        if (includeParentArticle) {
            kbArticles = this.getKBArticles(groupId, new long[]{resourcePrimKey}, status, null);
            kbArticles = ListUtil.copy(kbArticles);
        } else {
            kbArticles = new ArrayList<KBArticle>();
        }
        this._getAllDescendantKBArticles(kbArticles, groupId, resourcePrimKey, status, orderByComparator);
        return Collections.unmodifiableList(kbArticles);
    }
}

