/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.upgrade.v1_1_0;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.knowledge.base.internal.upgrade.v1_1_0.util.KBArticleAttachmentsHelper;
import com.liferay.knowledge.base.internal.upgrade.v1_1_0.util.KBArticleLatestUpgradeColumnImpl;
import com.liferay.knowledge.base.internal.upgrade.v1_1_0.util.KBArticleMainUpgradeColumnImpl;
import com.liferay.knowledge.base.internal.upgrade.v1_1_0.util.KBArticleRootResourcePrimKeyUpgradeColumnImpl;
import com.liferay.knowledge.base.internal.upgrade.v1_1_0.util.KBArticleTable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.TempUpgradeColumnImpl;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.kernel.upgrade.util.UpgradeTable;
import com.liferay.portal.kernel.upgrade.util.UpgradeTableFactoryUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;

public class KBArticleUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(KBArticleUpgradeProcess.class);
    private final Store _store;

    public KBArticleUpgradeProcess(Store store) {
        this._store = store;
    }

    protected void doUpgrade() throws Exception {
        this.renameAndUpdateTable(StringUtil.replaceFirst((String)"KBArticle", (String)"KB", (String)"KB_"), "KBArticle", KBArticleTable.TABLE_COLUMNS, "create table KBArticle (uuid_ VARCHAR(75) null,kbArticleId LONG not null primary key,resourcePrimKey LONG,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,rootResourcePrimKey LONG,parentResourcePrimKey LONG,version INTEGER,title STRING null,content TEXT null,description STRING null,kbTemplateId LONG,priority DOUBLE,sections STRING null,viewCount INTEGER,latest BOOLEAN,main BOOLEAN,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)", "drop table KBArticle");
    }

    protected void renameAndUpdateTable(String oldTableName, String newTableName, Object[][] tableColumns, String tableSqlCreate, String tableSqlDrop) throws Exception {
        if (this.hasRows(newTableName)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Not renaming ", oldTableName, " to ", newTableName, " because ", newTableName, " has data"}));
            }
            return;
        }
        if (!this.hasRows(oldTableName)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Not renaming ", oldTableName, " to ", newTableName, " because ", oldTableName, " has no data"}));
            }
            return;
        }
        this.updateSchema(oldTableName, newTableName, tableSqlDrop);
        this.renameTable(oldTableName, tableColumns, tableSqlCreate);
        this.updateTable(newTableName, tableColumns, tableSqlCreate);
        KBArticleAttachmentsHelper kbArticleAttachmentsHelper = new KBArticleAttachmentsHelper(this._store);
        kbArticleAttachmentsHelper.deleteAttachmentsDirectory(PortalUtil.getDefaultCompanyId());
    }

    protected void renameTable(String oldTableName, Object[][] tableColumns, String tableSqlCreate) throws Exception {
        UpgradeTable upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)oldTableName, (Object[][])tableColumns, (UpgradeColumn[])new UpgradeColumn[0]);
        upgradeTable.setCreateSQL(tableSqlCreate);
        upgradeTable.updateTable();
    }

    protected void updateColumn(String tableName, String columnName, String dataType, String data) throws Exception {
        if (this.hasColumn(tableName, columnName)) {
            return;
        }
        String dataTypeUpperCase = StringUtil.toUpperCase((String)dataType);
        if (dataTypeUpperCase.equals("DATE") || dataType.equals("STRING")) {
            dataTypeUpperCase = dataTypeUpperCase.concat(" null");
        }
        this.alterTableAddColumn(tableName, columnName, dataTypeUpperCase);
        this.runSQL(StringBundler.concat((String[])new String[]{"update ", tableName, " set ", columnName, " = ", data}));
    }

    protected void updateSchema(String oldTableName, String newTableName, String tableSqlDrop) throws Exception {
        if (this.hasTable(newTableName)) {
            this.runSQL(tableSqlDrop);
        }
        this.updateColumn(oldTableName, "kbArticleId", "LONG", "articleId");
        this.updateColumn(oldTableName, "rootResourcePrimKey", "LONG", "0");
        this.updateColumn(oldTableName, "kbTemplateId", "LONG", "0");
        this.updateColumn(oldTableName, "sections", "STRING", "'_general_'");
        this.updateColumn(oldTableName, "viewCount", "INTEGER", "0");
        this.updateColumn(oldTableName, "latest", "BOOLEAN", "FALSE");
        this.updateColumn(oldTableName, "main", "BOOLEAN", "FALSE");
        this.updateColumn(oldTableName, "status", "INTEGER", "0");
        this.updateColumn(oldTableName, "statusByUserId", "LONG", "userId");
        this.updateColumn(oldTableName, "statusByUserName", "STRING", "userName");
        this.updateColumn(oldTableName, "statusDate", "DATE", "modifiedDate");
        this.alterTableDropColumn(oldTableName, "articleId");
    }

    protected void updateTable(String newTableName, Object[][] tableColumns, String tableSqlCreate) throws Exception {
        TempUpgradeColumnImpl kbArticleIdColumn = new TempUpgradeColumnImpl("kbArticleId");
        TempUpgradeColumnImpl resourcePrimKeyColumn = new TempUpgradeColumnImpl("resourcePrimKey");
        KBArticleRootResourcePrimKeyUpgradeColumnImpl kbArticleRootResourcePrimKeyUpgradeColumnImpl = new KBArticleRootResourcePrimKeyUpgradeColumnImpl((UpgradeColumn)resourcePrimKeyColumn);
        KBArticleAttachmentsHelper kbArticleAttachmentsHelper = new KBArticleAttachmentsHelper(this._store);
        KBArticleLatestUpgradeColumnImpl kbArticleLatestUpgradeColumnImpl = new KBArticleLatestUpgradeColumnImpl(kbArticleAttachmentsHelper, (UpgradeColumn)kbArticleIdColumn, (UpgradeColumn)resourcePrimKeyColumn);
        KBArticleMainUpgradeColumnImpl kbArticleMainUpgradeColumnImpl = new KBArticleMainUpgradeColumnImpl(kbArticleAttachmentsHelper, (UpgradeColumn)kbArticleIdColumn, (UpgradeColumn)resourcePrimKeyColumn);
        UpgradeTable upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)newTableName, (Object[][])tableColumns, (UpgradeColumn[])new UpgradeColumn[]{kbArticleIdColumn, resourcePrimKeyColumn, kbArticleRootResourcePrimKeyUpgradeColumnImpl, kbArticleLatestUpgradeColumnImpl, kbArticleMainUpgradeColumnImpl});
        upgradeTable.setCreateSQL(tableSqlCreate);
        upgradeTable.updateTable();
    }
}

