/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.scheduler;

import com.liferay.knowledge.base.internal.configuration.KBServiceConfiguration;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.scheduler.SchedulerJobConfiguration;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerConfiguration;
import com.liferay.portal.kernel.service.CompanyLocalService;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.knowledge.base.internal.configuration.KBServiceConfiguration"}, service={SchedulerJobConfiguration.class})
public class CheckKBArticleSchedulerJobConfiguration
implements SchedulerJobConfiguration {
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private KBArticleLocalService _kbArticleLocalService;
    private KBServiceConfiguration _kbServiceConfiguration;

    public UnsafeConsumer<Long, Exception> getCompanyJobExecutorUnsafeConsumer() {
        return companyId -> this._kbArticleLocalService.checkKBArticles(companyId.longValue());
    }

    public UnsafeRunnable<Exception> getJobExecutorUnsafeRunnable() {
        return () -> this._companyLocalService.forEachCompanyId(companyId -> this._kbArticleLocalService.checkKBArticles(companyId.longValue()));
    }

    public TriggerConfiguration getTriggerConfiguration() {
        return TriggerConfiguration.createTriggerConfiguration((int)this._kbServiceConfiguration.checkInterval(), (TimeUnit)TimeUnit.MINUTE);
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._kbServiceConfiguration = (KBServiceConfiguration)ConfigurableUtil.createConfigurable(KBServiceConfiguration.class, properties);
    }
}

