/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.importer.util;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.knowledge.base.configuration.KBGroupServiceConfiguration;
import com.liferay.knowledge.base.exception.KBArticleImportException;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.zip.ZipReader;
import java.io.InputStream;
import java.util.Map;

public class KBArticleImporterUtil {
    private static final Log _log = LogFactoryUtil.getLog(KBArticleImporterUtil.class);

    public static FileEntry addImageFileEntry(String imageFileName, long userId, KBArticle kbArticle, ZipReader zipReader, Map<String, FileEntry> fileEntriesMap) throws PortalException {
        KBGroupServiceConfiguration kbGroupServiceConfiguration;
        block4: {
            kbGroupServiceConfiguration = (KBGroupServiceConfiguration)ConfigurationProviderUtil.getConfiguration(KBGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(kbArticle.getGroupId(), "com.liferay.knowledge.base"));
            try {
                KBArticleImporterUtil.validateImageFileExtension(imageFileName, kbGroupServiceConfiguration.markdownImporterImageFileExtensions());
            }
            catch (KBArticleImportException kbArticleImportException) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)("Unsupported image file suffix used in ZIP file " + imageFileName), (Throwable)kbArticleImportException);
            }
        }
        try {
            String zipReaderFileName = KBArticleImporterUtil._getZipReaderFileName(kbGroupServiceConfiguration.markdownImporterImageFolder(), imageFileName);
            return KBArticleImporterUtil.addImageFileEntry(userId, kbArticle, imageFileName, zipReader.getEntryAsInputStream(zipReaderFileName), fileEntriesMap);
        }
        catch (Exception exception) {
            throw new KBArticleImportException(StringBundler.concat((String[])new String[]{"Unable to import image file ", imageFileName, ": ", exception.getLocalizedMessage()}));
        }
    }

    public static String extractImageFileName(String html) {
        String imageSrc = null;
        String[] lines = StringUtil.split((String)html, (String)"\"");
        for (int i = 0; i < lines.length; ++i) {
            if (!lines[i].endsWith("src=")) continue;
            if (i + 1 >= lines.length) break;
            imageSrc = lines[i + 1];
            break;
        }
        if (Validator.isNull(imageSrc)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Missing src attribute for image " + html));
            }
            return null;
        }
        String[] paths = StringUtil.split(imageSrc, (String)"/");
        if (paths.length < 1) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Expected image file path to contain a slash " + html));
            }
            return null;
        }
        return paths[paths.length - 1];
    }

    public static void validateImageFileExtension(String imageFileName, String[] fileExtensions) throws KBArticleImportException {
        boolean validImageFileExtension = false;
        for (String fileExtension : fileExtensions) {
            if (!"*".equals(fileExtension) && !StringUtil.endsWith((String)imageFileName, (String)fileExtension)) continue;
            validImageFileExtension = true;
            break;
        }
        if (!validImageFileExtension) {
            throw new KBArticleImportException(imageFileName);
        }
    }

    protected static FileEntry addImageFileEntry(long userId, KBArticle kbArticle, String imageFileName, InputStream inputStream, Map<String, FileEntry> fileEntriesMap) throws PortalException {
        String mimeType;
        FileEntry fileEntry;
        block3: {
            fileEntry = fileEntriesMap.get(imageFileName);
            if (fileEntry != null) {
                return fileEntry;
            }
            mimeType = MimeTypesUtil.getContentType((String)imageFileName);
            try {
                PortletFileRepositoryUtil.getPortletFileEntry((long)kbArticle.getGroupId(), (long)kbArticle.getAttachmentsFolderId(), (String)imageFileName);
                PortletFileRepositoryUtil.deletePortletFileEntry((long)kbArticle.getGroupId(), (long)kbArticle.getAttachmentsFolderId(), (String)imageFileName);
            }
            catch (NoSuchFileEntryException noSuchFileEntryException) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)noSuchFileEntryException);
            }
        }
        fileEntry = PortletFileRepositoryUtil.addPortletFileEntry(null, (long)kbArticle.getGroupId(), (long)userId, (String)KBArticle.class.getName(), (long)kbArticle.getClassPK(), (String)"com_liferay_knowledge_base_web_portlet_ArticlePortlet", (long)kbArticle.getAttachmentsFolderId(), (InputStream)inputStream, (String)imageFileName, (String)mimeType, (boolean)false);
        fileEntriesMap.put(imageFileName, fileEntry);
        return fileEntry;
    }

    private static String _getZipReaderFileName(String dirName, String fileName) {
        if (dirName.endsWith("/")) {
            return dirName + fileName;
        }
        return dirName + "/" + fileName;
    }
}

