/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.importer;

import com.liferay.asset.kernel.exception.AssetCategoryException;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.knowledge.base.constants.KBArticleConstants;
import com.liferay.knowledge.base.constants.KBFolderConstants;
import com.liferay.knowledge.base.exception.KBArticleImportException;
import com.liferay.knowledge.base.internal.importer.KBArchive;
import com.liferay.knowledge.base.internal.importer.KBArchiveFactory;
import com.liferay.knowledge.base.internal.importer.util.KBArticleMarkdownConverter;
import com.liferay.knowledge.base.markdown.converter.MarkdownConverter;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class KBArticleImporter {
    private static final Log _log = LogFactoryUtil.getLog(KBArticleImporter.class);
    private final DLURLHelper _dlURLHelper;
    private final KBArchiveFactory _kbArchiveFactory;
    private final KBArticleLocalService _kbArticleLocalService;
    private final MarkdownConverter _markdownConverter;
    private final Portal _portal;
    private final ZipReaderFactory _zipReaderFactory;

    public KBArticleImporter(MarkdownConverter markdownConverter, KBArchiveFactory kbArchiveFactory, KBArticleLocalService kbArticleLocalService, Portal portal, DLURLHelper dlURLHelper, ZipReaderFactory zipReaderFactory) {
        this._markdownConverter = markdownConverter;
        this._kbArchiveFactory = kbArchiveFactory;
        this._kbArticleLocalService = kbArticleLocalService;
        this._portal = portal;
        this._dlURLHelper = dlURLHelper;
        this._zipReaderFactory = zipReaderFactory;
    }

    public int processZipFile(long userId, long groupId, long parentKBFolderId, boolean prioritizeByNumericalPrefix, InputStream inputStream, ServiceContext serviceContext) throws PortalException {
        if (inputStream == null) {
            throw new KBArticleImportException("Input stream is null");
        }
        try {
            ZipReader zipReader = this._zipReaderFactory.getZipReader(inputStream);
            return this._processKBArticleFiles(userId, groupId, parentKBFolderId, prioritizeByNumericalPrefix, zipReader, this._getMetadata(zipReader), serviceContext);
        }
        catch (IOException ioException) {
            throw new KBArticleImportException((Throwable)ioException);
        }
    }

    private KBArticle _addKBArticleMarkdown(long userId, long groupId, long parentKBFolderId, long parentResourceClassNameId, long parentResourcePrimaryKey, String markdown, String fileEntryName, ZipReader zipReader, Map<String, String> metadata, ServiceContext serviceContext) throws KBArticleImportException {
        if (Validator.isNull((String)markdown)) {
            throw new KBArticleImportException("Markdown is null for file entry " + fileEntryName);
        }
        KBArticleMarkdownConverter kbArticleMarkdownConverter = new KBArticleMarkdownConverter(markdown, fileEntryName, this._markdownConverter, metadata, this._dlURLHelper);
        String urlTitle = kbArticleMarkdownConverter.getUrlTitle();
        KBArticle kbArticle = this._kbArticleLocalService.fetchKBArticleByUrlTitle(groupId, parentKBFolderId, urlTitle);
        try {
            if (kbArticle == null) {
                int workflowAction = serviceContext.getWorkflowAction();
                serviceContext.setWorkflowAction(2);
                kbArticle = this._kbArticleLocalService.addKBArticle(null, userId, parentResourceClassNameId, parentResourcePrimaryKey, kbArticleMarkdownConverter.getTitle(), urlTitle, markdown, null, null, kbArticleMarkdownConverter.getSourceURL(), new Date(), null, null, null, serviceContext);
                serviceContext.setWorkflowAction(workflowAction);
            }
        }
        catch (AssetCategoryException assetCategoryException) {
            throw new KBArticleImportException.MustHaveACategory(assetCategoryException);
        }
        catch (Exception exception) {
            throw new KBArticleImportException(StringBundler.concat((String[])new String[]{"Unable to add basic KB article for file entry ", fileEntryName, ": ", exception.getLocalizedMessage()}), (Throwable)exception);
        }
        try {
            String html = kbArticleMarkdownConverter.processAttachmentsReferences(userId, kbArticle, zipReader, new HashMap<String, FileEntry>());
            return this._kbArticleLocalService.updateKBArticle(userId, kbArticle.getResourcePrimKey(), kbArticleMarkdownConverter.getTitle(), html, kbArticle.getDescription(), null, kbArticleMarkdownConverter.getSourceURL(), kbArticle.getDisplayDate(), kbArticle.getExpirationDate(), kbArticle.getReviewDate(), null, null, serviceContext);
        }
        catch (Exception exception) {
            throw new KBArticleImportException(StringBundler.concat((String[])new String[]{"Unable to update KB article for file entry ", fileEntryName, ": ", exception.getLocalizedMessage()}), (Throwable)exception);
        }
    }

    private double _getKBArchiveResourcePriority(KBArchive.Resource kbArchiveResource) throws KBArticleImportException {
        String kbArchiveResourceName = kbArchiveResource.getName();
        int slashIndex = kbArchiveResourceName.lastIndexOf("/");
        if (slashIndex == -1) {
            return 1.0;
        }
        String shortFileName = "";
        if (slashIndex > -1 && kbArchiveResourceName.length() > slashIndex + 1) {
            shortFileName = kbArchiveResourceName.substring(slashIndex + 1);
        }
        String leadingDigits = StringUtil.extractLeadingDigits((String)shortFileName);
        try {
            return Math.max(1.0, Double.parseDouble(leadingDigits));
        }
        catch (NumberFormatException numberFormatException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Invalid numerical prefix: " + kbArchiveResourceName), (Throwable)numberFormatException);
            }
            return 1.0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> _getMetadata(ZipReader zipReader) throws KBArticleImportException {
        try (InputStream inputStream = zipReader.getEntryAsInputStream(".METADATA");){
            if (inputStream == null) {
                Map<String, String> map = Collections.emptyMap();
                return map;
            }
            Properties properties = new Properties();
            properties.load(inputStream);
            HashMap<String, String> metadata = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Object value = entry.getValue();
                if (value == null) continue;
                metadata.put(String.valueOf(entry.getKey()), value.toString());
            }
            HashMap<String, String> hashMap = metadata;
            return hashMap;
        }
        catch (IOException ioException) {
            throw new KBArticleImportException((Throwable)ioException);
        }
    }

    private int _processKBArticleFiles(long userId, long groupId, long parentKBFolderId, boolean prioritizeByNumericalPrefix, ZipReader zipReader, Map<String, String> metadata, ServiceContext serviceContext) throws PortalException {
        int importedKBArticlesCount = 0;
        KBArchive kbArchive = this._kbArchiveFactory.createKBArchive(groupId, zipReader);
        HashMap<KBArchive.File, KBArticle> introFileNameKBArticleMap = new HashMap<KBArchive.File, KBArticle>();
        for (KBArchive.Folder folder : kbArchive.getFolders()) {
            long sectionResourcePrimaryKey;
            long sectionResourceClassNameId;
            KBArchive.File introFile = folder.getIntroFile();
            KBArticle introKBArticle = (KBArticle)introFileNameKBArticleMap.get(introFile);
            if (introFile != null && introKBArticle == null) {
                sectionResourceClassNameId = this._portal.getClassNameId(KBFolderConstants.getClassName());
                sectionResourcePrimaryKey = parentKBFolderId;
                KBArticle parentIntroKBArticle = (KBArticle)introFileNameKBArticleMap.get(folder.getParentFolderIntroFile());
                if (parentIntroKBArticle != null) {
                    sectionResourceClassNameId = this._portal.getClassNameId(KBArticleConstants.getClassName());
                    sectionResourcePrimaryKey = parentIntroKBArticle.getResourcePrimKey();
                }
                introKBArticle = this._addKBArticleMarkdown(userId, groupId, parentKBFolderId, sectionResourceClassNameId, sectionResourcePrimaryKey, introFile.getContent(), introFile.getName(), zipReader, metadata, serviceContext);
                ++importedKBArticlesCount;
                introFileNameKBArticleMap.put(introFile, introKBArticle);
                if (prioritizeByNumericalPrefix) {
                    double introFilePriority = this._getKBArchiveResourcePriority(folder);
                    this._kbArticleLocalService.moveKBArticle(userId, introKBArticle.getResourcePrimKey(), sectionResourceClassNameId, sectionResourcePrimaryKey, introFilePriority);
                }
            }
            sectionResourceClassNameId = this._portal.getClassNameId(KBFolderConstants.getClassName());
            sectionResourcePrimaryKey = parentKBFolderId;
            if (introKBArticle != null) {
                sectionResourceClassNameId = this._portal.getClassNameId(KBArticleConstants.getClassName());
                sectionResourcePrimaryKey = introKBArticle.getResourcePrimKey();
            }
            for (KBArchive.File file : folder.getFiles()) {
                double nonintroFilePriority;
                int value;
                String markdown = file.getContent();
                if (Validator.isNull((String)markdown) && _log.isWarnEnabled()) {
                    _log.warn((Object)("Missing Markdown in file entry " + file.getName()));
                }
                KBArticle kbArticle = this._addKBArticleMarkdown(userId, groupId, parentKBFolderId, sectionResourceClassNameId, sectionResourcePrimaryKey, markdown, file.getName(), zipReader, metadata, serviceContext);
                ++importedKBArticlesCount;
                if (!prioritizeByNumericalPrefix || (value = Double.compare(nonintroFilePriority = this._getKBArchiveResourcePriority(file), kbArticle.getPriority())) == 0) continue;
                this._kbArticleLocalService.moveKBArticle(userId, kbArticle.getResourcePrimKey(), sectionResourceClassNameId, sectionResourcePrimaryKey, nonintroFilePriority);
            }
        }
        return importedKBArticlesCount;
    }
}

