/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.configuration;

import com.liferay.knowledge.base.configuration.KBServiceConfigurationProvider;
import com.liferay.knowledge.base.internal.configuration.KBServiceConfiguration;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.util.HashMapDictionary;
import java.io.IOException;
import java.util.Dictionary;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={KBServiceConfigurationProvider.class})
public class KBServiceConfigurationProviderImpl
implements KBServiceConfigurationProvider {
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private ConfigurationProvider _configurationProvider;

    public int getCheckInterval() throws ConfigurationException {
        KBServiceConfiguration kbServiceConfiguration = (KBServiceConfiguration)this._configurationProvider.getSystemConfiguration(KBServiceConfiguration.class);
        return kbServiceConfiguration.checkInterval();
    }

    public int getExpirationDateNotificationDateWeeks() throws ConfigurationException {
        KBServiceConfiguration kbServiceConfiguration = (KBServiceConfiguration)this._configurationProvider.getSystemConfiguration(KBServiceConfiguration.class);
        return kbServiceConfiguration.expirationDateNotificationDateWeeks();
    }

    public void updateExpirationDateConfiguration(int checkInterval, int expirationDateNotificationDateWeeks) throws IOException {
        Configuration configuration = this._configurationAdmin.getConfiguration(KBServiceConfiguration.class.getName(), "?");
        Dictionary properties = configuration.getProperties();
        if (properties == null) {
            properties = new HashMapDictionary();
        }
        properties.put("checkInterval", checkInterval);
        properties.put("expirationDateNotificationDateWeeks", expirationDateNotificationDateWeeks);
        configuration.update(properties);
    }
}

