/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.knowledge.base.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBArticleModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the KBArticle service. Represents a row in the &quot;KBArticle&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>KBArticleModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link KBArticleImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see KBArticleImpl
 * @generated
 */
@JSON(strict = true)
public class KBArticleModelImpl
	extends BaseModelImpl<KBArticle> implements KBArticleModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a kb article model instance should use the <code>KBArticle</code> interface instead.
	 */
	public static final String TABLE_NAME = "KBArticle";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"uuid_", Types.VARCHAR}, {"kbArticleId", Types.BIGINT},
		{"resourcePrimKey", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP},
		{"externalReferenceCode", Types.VARCHAR},
		{"rootResourcePrimKey", Types.BIGINT},
		{"parentResourceClassNameId", Types.BIGINT},
		{"parentResourcePrimKey", Types.BIGINT}, {"kbFolderId", Types.BIGINT},
		{"version", Types.INTEGER}, {"title", Types.VARCHAR},
		{"urlTitle", Types.VARCHAR}, {"content", Types.CLOB},
		{"description", Types.VARCHAR}, {"priority", Types.DOUBLE},
		{"sections", Types.VARCHAR}, {"latest", Types.BOOLEAN},
		{"main", Types.BOOLEAN}, {"sourceURL", Types.VARCHAR},
		{"displayDate", Types.TIMESTAMP}, {"expirationDate", Types.TIMESTAMP},
		{"reviewDate", Types.TIMESTAMP}, {"lastPublishDate", Types.TIMESTAMP},
		{"status", Types.INTEGER}, {"statusByUserId", Types.BIGINT},
		{"statusByUserName", Types.VARCHAR}, {"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("kbArticleId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("resourcePrimKey", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("rootResourcePrimKey", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("parentResourceClassNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("parentResourcePrimKey", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("kbFolderId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("version", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("title", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("urlTitle", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("content", Types.CLOB);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("priority", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("sections", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("latest", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("main", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("sourceURL", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("displayDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("expirationDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("reviewDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table KBArticle (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,uuid_ VARCHAR(75) null,kbArticleId LONG not null,resourcePrimKey LONG,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,externalReferenceCode VARCHAR(75) null,rootResourcePrimKey LONG,parentResourceClassNameId LONG,parentResourcePrimKey LONG,kbFolderId LONG,version INTEGER,title STRING null,urlTitle VARCHAR(75) null,content TEXT null,description STRING null,priority DOUBLE,sections STRING null,latest BOOLEAN,main BOOLEAN,sourceURL STRING null,displayDate DATE null,expirationDate DATE null,reviewDate DATE null,lastPublishDate DATE null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null,primary key (kbArticleId, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table KBArticle";

	public static final String ORDER_BY_JPQL =
		" ORDER BY kbArticle.modifiedDate DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY KBArticle.modifiedDate DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long DISPLAYDATE_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long KBFOLDERID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LATEST_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long MAIN_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PARENTRESOURCEPRIMKEY_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long RESOURCEPRIMKEY_COLUMN_BITMASK = 256L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SECTIONS_COLUMN_BITMASK = 512L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long STATUS_COLUMN_BITMASK = 1024L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long URLTITLE_COLUMN_BITMASK = 2048L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 4096L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long VERSION_COLUMN_BITMASK = 8192L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long MODIFIEDDATE_COLUMN_BITMASK = 16384L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public KBArticleModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _kbArticleId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setKbArticleId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _kbArticleId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return KBArticle.class;
	}

	@Override
	public String getModelClassName() {
		return KBArticle.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<KBArticle, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<KBArticle, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<KBArticle, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName, attributeGetterFunction.apply((KBArticle)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<KBArticle, Object>> attributeSetterBiConsumers =
			getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<KBArticle, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(KBArticle)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<KBArticle, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<KBArticle, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<KBArticle, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<KBArticle, Object>> attributeGetterFunctions =
				new LinkedHashMap<String, Function<KBArticle, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", KBArticle::getMvccVersion);
			attributeGetterFunctions.put(
				"ctCollectionId", KBArticle::getCtCollectionId);
			attributeGetterFunctions.put("uuid", KBArticle::getUuid);
			attributeGetterFunctions.put(
				"kbArticleId", KBArticle::getKbArticleId);
			attributeGetterFunctions.put(
				"resourcePrimKey", KBArticle::getResourcePrimKey);
			attributeGetterFunctions.put("groupId", KBArticle::getGroupId);
			attributeGetterFunctions.put("companyId", KBArticle::getCompanyId);
			attributeGetterFunctions.put("userId", KBArticle::getUserId);
			attributeGetterFunctions.put("userName", KBArticle::getUserName);
			attributeGetterFunctions.put(
				"createDate", KBArticle::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", KBArticle::getModifiedDate);
			attributeGetterFunctions.put(
				"externalReferenceCode", KBArticle::getExternalReferenceCode);
			attributeGetterFunctions.put(
				"rootResourcePrimKey", KBArticle::getRootResourcePrimKey);
			attributeGetterFunctions.put(
				"parentResourceClassNameId",
				KBArticle::getParentResourceClassNameId);
			attributeGetterFunctions.put(
				"parentResourcePrimKey", KBArticle::getParentResourcePrimKey);
			attributeGetterFunctions.put(
				"kbFolderId", KBArticle::getKbFolderId);
			attributeGetterFunctions.put("version", KBArticle::getVersion);
			attributeGetterFunctions.put("title", KBArticle::getTitle);
			attributeGetterFunctions.put("urlTitle", KBArticle::getUrlTitle);
			attributeGetterFunctions.put("content", KBArticle::getContent);
			attributeGetterFunctions.put(
				"description", KBArticle::getDescription);
			attributeGetterFunctions.put("priority", KBArticle::getPriority);
			attributeGetterFunctions.put("sections", KBArticle::getSections);
			attributeGetterFunctions.put("latest", KBArticle::getLatest);
			attributeGetterFunctions.put("main", KBArticle::getMain);
			attributeGetterFunctions.put("sourceURL", KBArticle::getSourceURL);
			attributeGetterFunctions.put(
				"displayDate", KBArticle::getDisplayDate);
			attributeGetterFunctions.put(
				"expirationDate", KBArticle::getExpirationDate);
			attributeGetterFunctions.put(
				"reviewDate", KBArticle::getReviewDate);
			attributeGetterFunctions.put(
				"lastPublishDate", KBArticle::getLastPublishDate);
			attributeGetterFunctions.put("status", KBArticle::getStatus);
			attributeGetterFunctions.put(
				"statusByUserId", KBArticle::getStatusByUserId);
			attributeGetterFunctions.put(
				"statusByUserName", KBArticle::getStatusByUserName);
			attributeGetterFunctions.put(
				"statusDate", KBArticle::getStatusDate);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<KBArticle, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<KBArticle, ?>> attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<KBArticle, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<KBArticle, Long>)KBArticle::setMvccVersion);
			attributeSetterBiConsumers.put(
				"ctCollectionId",
				(BiConsumer<KBArticle, Long>)KBArticle::setCtCollectionId);
			attributeSetterBiConsumers.put(
				"uuid", (BiConsumer<KBArticle, String>)KBArticle::setUuid);
			attributeSetterBiConsumers.put(
				"kbArticleId",
				(BiConsumer<KBArticle, Long>)KBArticle::setKbArticleId);
			attributeSetterBiConsumers.put(
				"resourcePrimKey",
				(BiConsumer<KBArticle, Long>)KBArticle::setResourcePrimKey);
			attributeSetterBiConsumers.put(
				"groupId", (BiConsumer<KBArticle, Long>)KBArticle::setGroupId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<KBArticle, Long>)KBArticle::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId", (BiConsumer<KBArticle, Long>)KBArticle::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<KBArticle, String>)KBArticle::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<KBArticle, Date>)KBArticle::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<KBArticle, Date>)KBArticle::setModifiedDate);
			attributeSetterBiConsumers.put(
				"externalReferenceCode",
				(BiConsumer<KBArticle, String>)
					KBArticle::setExternalReferenceCode);
			attributeSetterBiConsumers.put(
				"rootResourcePrimKey",
				(BiConsumer<KBArticle, Long>)KBArticle::setRootResourcePrimKey);
			attributeSetterBiConsumers.put(
				"parentResourceClassNameId",
				(BiConsumer<KBArticle, Long>)
					KBArticle::setParentResourceClassNameId);
			attributeSetterBiConsumers.put(
				"parentResourcePrimKey",
				(BiConsumer<KBArticle, Long>)
					KBArticle::setParentResourcePrimKey);
			attributeSetterBiConsumers.put(
				"kbFolderId",
				(BiConsumer<KBArticle, Long>)KBArticle::setKbFolderId);
			attributeSetterBiConsumers.put(
				"version",
				(BiConsumer<KBArticle, Integer>)KBArticle::setVersion);
			attributeSetterBiConsumers.put(
				"title", (BiConsumer<KBArticle, String>)KBArticle::setTitle);
			attributeSetterBiConsumers.put(
				"urlTitle",
				(BiConsumer<KBArticle, String>)KBArticle::setUrlTitle);
			attributeSetterBiConsumers.put(
				"content",
				(BiConsumer<KBArticle, String>)KBArticle::setContent);
			attributeSetterBiConsumers.put(
				"description",
				(BiConsumer<KBArticle, String>)KBArticle::setDescription);
			attributeSetterBiConsumers.put(
				"priority",
				(BiConsumer<KBArticle, Double>)KBArticle::setPriority);
			attributeSetterBiConsumers.put(
				"sections",
				(BiConsumer<KBArticle, String>)KBArticle::setSections);
			attributeSetterBiConsumers.put(
				"latest", (BiConsumer<KBArticle, Boolean>)KBArticle::setLatest);
			attributeSetterBiConsumers.put(
				"main", (BiConsumer<KBArticle, Boolean>)KBArticle::setMain);
			attributeSetterBiConsumers.put(
				"sourceURL",
				(BiConsumer<KBArticle, String>)KBArticle::setSourceURL);
			attributeSetterBiConsumers.put(
				"displayDate",
				(BiConsumer<KBArticle, Date>)KBArticle::setDisplayDate);
			attributeSetterBiConsumers.put(
				"expirationDate",
				(BiConsumer<KBArticle, Date>)KBArticle::setExpirationDate);
			attributeSetterBiConsumers.put(
				"reviewDate",
				(BiConsumer<KBArticle, Date>)KBArticle::setReviewDate);
			attributeSetterBiConsumers.put(
				"lastPublishDate",
				(BiConsumer<KBArticle, Date>)KBArticle::setLastPublishDate);
			attributeSetterBiConsumers.put(
				"status", (BiConsumer<KBArticle, Integer>)KBArticle::setStatus);
			attributeSetterBiConsumers.put(
				"statusByUserId",
				(BiConsumer<KBArticle, Long>)KBArticle::setStatusByUserId);
			attributeSetterBiConsumers.put(
				"statusByUserName",
				(BiConsumer<KBArticle, String>)KBArticle::setStatusByUserName);
			attributeSetterBiConsumers.put(
				"statusDate",
				(BiConsumer<KBArticle, Date>)KBArticle::setStatusDate);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public long getKbArticleId() {
		return _kbArticleId;
	}

	@Override
	public void setKbArticleId(long kbArticleId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_kbArticleId = kbArticleId;
	}

	@JSON
	@Override
	public long getResourcePrimKey() {
		return _resourcePrimKey;
	}

	@Override
	public void setResourcePrimKey(long resourcePrimKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_resourcePrimKey = resourcePrimKey;
	}

	@Override
	public boolean isResourceMain() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalResourcePrimKey() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("resourcePrimKey"));
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getRootResourcePrimKey() {
		return _rootResourcePrimKey;
	}

	@Override
	public void setRootResourcePrimKey(long rootResourcePrimKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_rootResourcePrimKey = rootResourcePrimKey;
	}

	@JSON
	@Override
	public long getParentResourceClassNameId() {
		return _parentResourceClassNameId;
	}

	@Override
	public void setParentResourceClassNameId(long parentResourceClassNameId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_parentResourceClassNameId = parentResourceClassNameId;
	}

	@JSON
	@Override
	public long getParentResourcePrimKey() {
		return _parentResourcePrimKey;
	}

	@Override
	public void setParentResourcePrimKey(long parentResourcePrimKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_parentResourcePrimKey = parentResourcePrimKey;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalParentResourcePrimKey() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("parentResourcePrimKey"));
	}

	@JSON
	@Override
	public long getKbFolderId() {
		return _kbFolderId;
	}

	@Override
	public void setKbFolderId(long kbFolderId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_kbFolderId = kbFolderId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalKbFolderId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("kbFolderId"));
	}

	@JSON
	@Override
	public int getVersion() {
		return _version;
	}

	@Override
	public void setVersion(int version) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_version = version;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalVersion() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("version"));
	}

	@JSON
	@Override
	public String getTitle() {
		if (_title == null) {
			return "";
		}
		else {
			return _title;
		}
	}

	@Override
	public void setTitle(String title) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_title = title;
	}

	@JSON
	@Override
	public String getUrlTitle() {
		if (_urlTitle == null) {
			return "";
		}
		else {
			return _urlTitle;
		}
	}

	@Override
	public void setUrlTitle(String urlTitle) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_urlTitle = urlTitle;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUrlTitle() {
		return getColumnOriginalValue("urlTitle");
	}

	@JSON
	@Override
	public String getContent() {
		if (_content == null) {
			return "";
		}
		else {
			return _content;
		}
	}

	@Override
	public void setContent(String content) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_content = content;
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_description = description;
	}

	@JSON
	@Override
	public double getPriority() {
		return _priority;
	}

	@Override
	public void setPriority(double priority) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_priority = priority;
	}

	@JSON
	@Override
	public String getSections() {
		if (_sections == null) {
			return "";
		}
		else {
			return _sections;
		}
	}

	@Override
	public void setSections(String sections) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_sections = sections;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalSections() {
		return getColumnOriginalValue("sections");
	}

	@JSON
	@Override
	public boolean getLatest() {
		return _latest;
	}

	@JSON
	@Override
	public boolean isLatest() {
		return _latest;
	}

	@Override
	public void setLatest(boolean latest) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_latest = latest;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalLatest() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("latest"));
	}

	@JSON
	@Override
	public boolean getMain() {
		return _main;
	}

	@JSON
	@Override
	public boolean isMain() {
		return _main;
	}

	@Override
	public void setMain(boolean main) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_main = main;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalMain() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("main"));
	}

	@JSON
	@Override
	public String getSourceURL() {
		if (_sourceURL == null) {
			return "";
		}
		else {
			return _sourceURL;
		}
	}

	@Override
	public void setSourceURL(String sourceURL) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_sourceURL = sourceURL;
	}

	@JSON
	@Override
	public Date getDisplayDate() {
		return _displayDate;
	}

	@Override
	public void setDisplayDate(Date displayDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_displayDate = displayDate;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public Date getOriginalDisplayDate() {
		return getColumnOriginalValue("displayDate");
	}

	@JSON
	@Override
	public Date getExpirationDate() {
		return _expirationDate;
	}

	@Override
	public void setExpirationDate(Date expirationDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_expirationDate = expirationDate;
	}

	@JSON
	@Override
	public Date getReviewDate() {
		return _reviewDate;
	}

	@Override
	public void setReviewDate(Date reviewDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_reviewDate = reviewDate;
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPublishDate = lastPublishDate;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalStatus() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("status"));
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(KBArticle.class.getName()));
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), KBArticle.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public KBArticle toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, KBArticle>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		KBArticleImpl kbArticleImpl = new KBArticleImpl();

		kbArticleImpl.setMvccVersion(getMvccVersion());
		kbArticleImpl.setCtCollectionId(getCtCollectionId());
		kbArticleImpl.setUuid(getUuid());
		kbArticleImpl.setKbArticleId(getKbArticleId());
		kbArticleImpl.setResourcePrimKey(getResourcePrimKey());
		kbArticleImpl.setGroupId(getGroupId());
		kbArticleImpl.setCompanyId(getCompanyId());
		kbArticleImpl.setUserId(getUserId());
		kbArticleImpl.setUserName(getUserName());
		kbArticleImpl.setCreateDate(getCreateDate());
		kbArticleImpl.setModifiedDate(getModifiedDate());
		kbArticleImpl.setExternalReferenceCode(getExternalReferenceCode());
		kbArticleImpl.setRootResourcePrimKey(getRootResourcePrimKey());
		kbArticleImpl.setParentResourceClassNameId(
			getParentResourceClassNameId());
		kbArticleImpl.setParentResourcePrimKey(getParentResourcePrimKey());
		kbArticleImpl.setKbFolderId(getKbFolderId());
		kbArticleImpl.setVersion(getVersion());
		kbArticleImpl.setTitle(getTitle());
		kbArticleImpl.setUrlTitle(getUrlTitle());
		kbArticleImpl.setContent(getContent());
		kbArticleImpl.setDescription(getDescription());
		kbArticleImpl.setPriority(getPriority());
		kbArticleImpl.setSections(getSections());
		kbArticleImpl.setLatest(isLatest());
		kbArticleImpl.setMain(isMain());
		kbArticleImpl.setSourceURL(getSourceURL());
		kbArticleImpl.setDisplayDate(getDisplayDate());
		kbArticleImpl.setExpirationDate(getExpirationDate());
		kbArticleImpl.setReviewDate(getReviewDate());
		kbArticleImpl.setLastPublishDate(getLastPublishDate());
		kbArticleImpl.setStatus(getStatus());
		kbArticleImpl.setStatusByUserId(getStatusByUserId());
		kbArticleImpl.setStatusByUserName(getStatusByUserName());
		kbArticleImpl.setStatusDate(getStatusDate());

		kbArticleImpl.resetOriginalValues();

		return kbArticleImpl;
	}

	@Override
	public KBArticle cloneWithOriginalValues() {
		KBArticleImpl kbArticleImpl = new KBArticleImpl();

		kbArticleImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		kbArticleImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		kbArticleImpl.setUuid(this.<String>getColumnOriginalValue("uuid_"));
		kbArticleImpl.setKbArticleId(
			this.<Long>getColumnOriginalValue("kbArticleId"));
		kbArticleImpl.setResourcePrimKey(
			this.<Long>getColumnOriginalValue("resourcePrimKey"));
		kbArticleImpl.setGroupId(this.<Long>getColumnOriginalValue("groupId"));
		kbArticleImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		kbArticleImpl.setUserId(this.<Long>getColumnOriginalValue("userId"));
		kbArticleImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		kbArticleImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		kbArticleImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		kbArticleImpl.setExternalReferenceCode(
			this.<String>getColumnOriginalValue("externalReferenceCode"));
		kbArticleImpl.setRootResourcePrimKey(
			this.<Long>getColumnOriginalValue("rootResourcePrimKey"));
		kbArticleImpl.setParentResourceClassNameId(
			this.<Long>getColumnOriginalValue("parentResourceClassNameId"));
		kbArticleImpl.setParentResourcePrimKey(
			this.<Long>getColumnOriginalValue("parentResourcePrimKey"));
		kbArticleImpl.setKbFolderId(
			this.<Long>getColumnOriginalValue("kbFolderId"));
		kbArticleImpl.setVersion(
			this.<Integer>getColumnOriginalValue("version"));
		kbArticleImpl.setTitle(this.<String>getColumnOriginalValue("title"));
		kbArticleImpl.setUrlTitle(
			this.<String>getColumnOriginalValue("urlTitle"));
		kbArticleImpl.setContent(
			this.<String>getColumnOriginalValue("content"));
		kbArticleImpl.setDescription(
			this.<String>getColumnOriginalValue("description"));
		kbArticleImpl.setPriority(
			this.<Double>getColumnOriginalValue("priority"));
		kbArticleImpl.setSections(
			this.<String>getColumnOriginalValue("sections"));
		kbArticleImpl.setLatest(this.<Boolean>getColumnOriginalValue("latest"));
		kbArticleImpl.setMain(this.<Boolean>getColumnOriginalValue("main"));
		kbArticleImpl.setSourceURL(
			this.<String>getColumnOriginalValue("sourceURL"));
		kbArticleImpl.setDisplayDate(
			this.<Date>getColumnOriginalValue("displayDate"));
		kbArticleImpl.setExpirationDate(
			this.<Date>getColumnOriginalValue("expirationDate"));
		kbArticleImpl.setReviewDate(
			this.<Date>getColumnOriginalValue("reviewDate"));
		kbArticleImpl.setLastPublishDate(
			this.<Date>getColumnOriginalValue("lastPublishDate"));
		kbArticleImpl.setStatus(this.<Integer>getColumnOriginalValue("status"));
		kbArticleImpl.setStatusByUserId(
			this.<Long>getColumnOriginalValue("statusByUserId"));
		kbArticleImpl.setStatusByUserName(
			this.<String>getColumnOriginalValue("statusByUserName"));
		kbArticleImpl.setStatusDate(
			this.<Date>getColumnOriginalValue("statusDate"));

		return kbArticleImpl;
	}

	@Override
	public int compareTo(KBArticle kbArticle) {
		int value = 0;

		value = DateUtil.compareTo(
			getModifiedDate(), kbArticle.getModifiedDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof KBArticle)) {
			return false;
		}

		KBArticle kbArticle = (KBArticle)object;

		long primaryKey = kbArticle.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<KBArticle> toCacheModel() {
		KBArticleCacheModel kbArticleCacheModel = new KBArticleCacheModel();

		kbArticleCacheModel.mvccVersion = getMvccVersion();

		kbArticleCacheModel.ctCollectionId = getCtCollectionId();

		kbArticleCacheModel.uuid = getUuid();

		String uuid = kbArticleCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			kbArticleCacheModel.uuid = null;
		}

		kbArticleCacheModel.kbArticleId = getKbArticleId();

		kbArticleCacheModel.resourcePrimKey = getResourcePrimKey();

		kbArticleCacheModel.groupId = getGroupId();

		kbArticleCacheModel.companyId = getCompanyId();

		kbArticleCacheModel.userId = getUserId();

		kbArticleCacheModel.userName = getUserName();

		String userName = kbArticleCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			kbArticleCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			kbArticleCacheModel.createDate = createDate.getTime();
		}
		else {
			kbArticleCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			kbArticleCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			kbArticleCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		kbArticleCacheModel.externalReferenceCode = getExternalReferenceCode();

		String externalReferenceCode =
			kbArticleCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			kbArticleCacheModel.externalReferenceCode = null;
		}

		kbArticleCacheModel.rootResourcePrimKey = getRootResourcePrimKey();

		kbArticleCacheModel.parentResourceClassNameId =
			getParentResourceClassNameId();

		kbArticleCacheModel.parentResourcePrimKey = getParentResourcePrimKey();

		kbArticleCacheModel.kbFolderId = getKbFolderId();

		kbArticleCacheModel.version = getVersion();

		kbArticleCacheModel.title = getTitle();

		String title = kbArticleCacheModel.title;

		if ((title != null) && (title.length() == 0)) {
			kbArticleCacheModel.title = null;
		}

		kbArticleCacheModel.urlTitle = getUrlTitle();

		String urlTitle = kbArticleCacheModel.urlTitle;

		if ((urlTitle != null) && (urlTitle.length() == 0)) {
			kbArticleCacheModel.urlTitle = null;
		}

		kbArticleCacheModel.content = getContent();

		String content = kbArticleCacheModel.content;

		if ((content != null) && (content.length() == 0)) {
			kbArticleCacheModel.content = null;
		}

		kbArticleCacheModel.description = getDescription();

		String description = kbArticleCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			kbArticleCacheModel.description = null;
		}

		kbArticleCacheModel.priority = getPriority();

		kbArticleCacheModel.sections = getSections();

		String sections = kbArticleCacheModel.sections;

		if ((sections != null) && (sections.length() == 0)) {
			kbArticleCacheModel.sections = null;
		}

		kbArticleCacheModel.latest = isLatest();

		kbArticleCacheModel.main = isMain();

		kbArticleCacheModel.sourceURL = getSourceURL();

		String sourceURL = kbArticleCacheModel.sourceURL;

		if ((sourceURL != null) && (sourceURL.length() == 0)) {
			kbArticleCacheModel.sourceURL = null;
		}

		Date displayDate = getDisplayDate();

		if (displayDate != null) {
			kbArticleCacheModel.displayDate = displayDate.getTime();
		}
		else {
			kbArticleCacheModel.displayDate = Long.MIN_VALUE;
		}

		Date expirationDate = getExpirationDate();

		if (expirationDate != null) {
			kbArticleCacheModel.expirationDate = expirationDate.getTime();
		}
		else {
			kbArticleCacheModel.expirationDate = Long.MIN_VALUE;
		}

		Date reviewDate = getReviewDate();

		if (reviewDate != null) {
			kbArticleCacheModel.reviewDate = reviewDate.getTime();
		}
		else {
			kbArticleCacheModel.reviewDate = Long.MIN_VALUE;
		}

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			kbArticleCacheModel.lastPublishDate = lastPublishDate.getTime();
		}
		else {
			kbArticleCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		kbArticleCacheModel.status = getStatus();

		kbArticleCacheModel.statusByUserId = getStatusByUserId();

		kbArticleCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName = kbArticleCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			kbArticleCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			kbArticleCacheModel.statusDate = statusDate.getTime();
		}
		else {
			kbArticleCacheModel.statusDate = Long.MIN_VALUE;
		}

		return kbArticleCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<KBArticle, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<KBArticle, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<KBArticle, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((KBArticle)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, KBArticle>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					KBArticle.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private String _uuid;
	private long _kbArticleId;
	private long _resourcePrimKey;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _externalReferenceCode;
	private long _rootResourcePrimKey;
	private long _parentResourceClassNameId;
	private long _parentResourcePrimKey;
	private long _kbFolderId;
	private int _version;
	private String _title;
	private String _urlTitle;
	private String _content;
	private String _description;
	private double _priority;
	private String _sections;
	private boolean _latest;
	private boolean _main;
	private String _sourceURL;
	private Date _displayDate;
	private Date _expirationDate;
	private Date _reviewDate;
	private Date _lastPublishDate;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<KBArticle, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((KBArticle)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put("kbArticleId", _kbArticleId);
		_columnOriginalValues.put("resourcePrimKey", _resourcePrimKey);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put("rootResourcePrimKey", _rootResourcePrimKey);
		_columnOriginalValues.put(
			"parentResourceClassNameId", _parentResourceClassNameId);
		_columnOriginalValues.put(
			"parentResourcePrimKey", _parentResourcePrimKey);
		_columnOriginalValues.put("kbFolderId", _kbFolderId);
		_columnOriginalValues.put("version", _version);
		_columnOriginalValues.put("title", _title);
		_columnOriginalValues.put("urlTitle", _urlTitle);
		_columnOriginalValues.put("content", _content);
		_columnOriginalValues.put("description", _description);
		_columnOriginalValues.put("priority", _priority);
		_columnOriginalValues.put("sections", _sections);
		_columnOriginalValues.put("latest", _latest);
		_columnOriginalValues.put("main", _main);
		_columnOriginalValues.put("sourceURL", _sourceURL);
		_columnOriginalValues.put("displayDate", _displayDate);
		_columnOriginalValues.put("expirationDate", _expirationDate);
		_columnOriginalValues.put("reviewDate", _reviewDate);
		_columnOriginalValues.put("lastPublishDate", _lastPublishDate);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusByUserName", _statusByUserName);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("uuid_", 4L);

		columnBitmasks.put("kbArticleId", 8L);

		columnBitmasks.put("resourcePrimKey", 16L);

		columnBitmasks.put("groupId", 32L);

		columnBitmasks.put("companyId", 64L);

		columnBitmasks.put("userId", 128L);

		columnBitmasks.put("userName", 256L);

		columnBitmasks.put("createDate", 512L);

		columnBitmasks.put("modifiedDate", 1024L);

		columnBitmasks.put("externalReferenceCode", 2048L);

		columnBitmasks.put("rootResourcePrimKey", 4096L);

		columnBitmasks.put("parentResourceClassNameId", 8192L);

		columnBitmasks.put("parentResourcePrimKey", 16384L);

		columnBitmasks.put("kbFolderId", 32768L);

		columnBitmasks.put("version", 65536L);

		columnBitmasks.put("title", 131072L);

		columnBitmasks.put("urlTitle", 262144L);

		columnBitmasks.put("content", 524288L);

		columnBitmasks.put("description", 1048576L);

		columnBitmasks.put("priority", 2097152L);

		columnBitmasks.put("sections", 4194304L);

		columnBitmasks.put("latest", 8388608L);

		columnBitmasks.put("main", 16777216L);

		columnBitmasks.put("sourceURL", 33554432L);

		columnBitmasks.put("displayDate", 67108864L);

		columnBitmasks.put("expirationDate", 134217728L);

		columnBitmasks.put("reviewDate", 268435456L);

		columnBitmasks.put("lastPublishDate", 536870912L);

		columnBitmasks.put("status", 1073741824L);

		columnBitmasks.put("statusByUserId", 2147483648L);

		columnBitmasks.put("statusByUserName", 4294967296L);

		columnBitmasks.put("statusDate", 8589934592L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private KBArticle _escapedModel;

}