create table KBArticle (
	mvccVersion LONG default 0 not null,
	ctCollectionId LONG default 0 not null,
	uuid_ VARCHAR(75) null,
	kbArticleId LONG not null,
	resourcePrimKey LONG,
	groupId LONG,
	companyId LONG,
	userId LONG,
	userName VARCHAR(75) null,
	createDate DATE null,
	modifiedDate DATE null,
	externalReferenceCode VARCHAR(75) null,
	rootResourcePrimKey LONG,
	parentResourceClassNameId LONG,
	parentResourcePrimKey LONG,
	kbFolderId LONG,
	version INTEGER,
	title STRING null,
	urlTitle VARCHAR(75) null,
	content TEXT null,
	description STRING null,
	priority DOUBLE,
	sections STRING null,
	latest BOOLEAN,
	main BOOLEAN,
	sourceURL STRING null,
	displayDate DATE null,
	expirationDate DATE null,
	reviewDate DATE null,
	lastPublishDate DATE null,
	status INTEGER,
	statusByUserId LONG,
	statusByUserName VARCHAR(75) null,
	statusDate DATE null,
	primary key (kbArticleId, ctCollectionId)
);

create table KBComment (
	mvccVersion LONG default 0 not null,
	ctCollectionId LONG default 0 not null,
	uuid_ VARCHAR(75) null,
	kbCommentId LONG not null,
	groupId LONG,
	companyId LONG,
	userId LONG,
	userName VARCHAR(75) null,
	createDate DATE null,
	modifiedDate DATE null,
	classNameId LONG,
	classPK LONG,
	content STRING null,
	userRating INTEGER,
	lastPublishDate DATE null,
	status INTEGER,
	primary key (kbCommentId, ctCollectionId)
);

create table KBFolder (
	mvccVersion LONG default 0 not null,
	ctCollectionId LONG default 0 not null,
	uuid_ VARCHAR(75) null,
	externalReferenceCode VARCHAR(75) null,
	kbFolderId LONG not null,
	groupId LONG,
	companyId LONG,
	userId LONG,
	userName VARCHAR(75) null,
	createDate DATE null,
	modifiedDate DATE null,
	parentKBFolderId LONG,
	name VARCHAR(75) null,
	urlTitle VARCHAR(75) null,
	description STRING null,
	lastPublishDate DATE null,
	primary key (kbFolderId, ctCollectionId)
);

create table KBTemplate (
	mvccVersion LONG default 0 not null,
	ctCollectionId LONG default 0 not null,
	uuid_ VARCHAR(75) null,
	kbTemplateId LONG not null,
	groupId LONG,
	companyId LONG,
	userId LONG,
	userName VARCHAR(75) null,
	createDate DATE null,
	modifiedDate DATE null,
	title STRING null,
	content TEXT null,
	lastPublishDate DATE null,
	primary key (kbTemplateId, ctCollectionId)
);