/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.service.persistence.impl;

import com.liferay.knowledge.base.exception.NoSuchTemplateException;
import com.liferay.knowledge.base.model.KBTemplate;
import com.liferay.knowledge.base.model.KBTemplateTable;
import com.liferay.knowledge.base.model.impl.KBTemplateImpl;
import com.liferay.knowledge.base.model.impl.KBTemplateModelImpl;
import com.liferay.knowledge.base.service.persistence.KBTemplatePersistence;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.sanitizer.SanitizerException;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={KBTemplatePersistence.class, BasePersistence.class})
public class KBTemplatePersistenceImpl
extends BasePersistenceImpl<KBTemplate>
implements KBTemplatePersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = KBTemplateImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "kbTemplate.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(kbTemplate.uuid IS NULL OR kbTemplate.uuid = '')";
    private FinderPath _finderPathFetchByUUID_G;
    private FinderPath _finderPathCountByUUID_G;
    private static final String _FINDER_COLUMN_UUID_G_UUID_2 = "kbTemplate.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_3 = "(kbTemplate.uuid IS NULL OR kbTemplate.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_G_GROUPID_2 = "kbTemplate.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "kbTemplate.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(kbTemplate.uuid IS NULL OR kbTemplate.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "kbTemplate.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByGroupId;
    private FinderPath _finderPathWithoutPaginationFindByGroupId;
    private FinderPath _finderPathCountByGroupId;
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "kbTemplate.groupId = ?";
    private BundleContext _bundleContext;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_KBTEMPLATE = "SELECT kbTemplate FROM KBTemplate kbTemplate";
    private static final String _SQL_SELECT_KBTEMPLATE_WHERE = "SELECT kbTemplate FROM KBTemplate kbTemplate WHERE ";
    private static final String _SQL_COUNT_KBTEMPLATE = "SELECT COUNT(kbTemplate) FROM KBTemplate kbTemplate";
    private static final String _SQL_COUNT_KBTEMPLATE_WHERE = "SELECT COUNT(kbTemplate) FROM KBTemplate kbTemplate WHERE ";
    private static final String _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN = "kbTemplate.kbTemplateId";
    private static final String _FILTER_SQL_SELECT_KBTEMPLATE_WHERE = "SELECT DISTINCT {kbTemplate.*} FROM KBTemplate kbTemplate WHERE ";
    private static final String _FILTER_SQL_SELECT_KBTEMPLATE_NO_INLINE_DISTINCT_WHERE_1 = "SELECT {KBTemplate.*} FROM (SELECT DISTINCT kbTemplate.kbTemplateId FROM KBTemplate kbTemplate WHERE ";
    private static final String _FILTER_SQL_SELECT_KBTEMPLATE_NO_INLINE_DISTINCT_WHERE_2 = ") TEMP_TABLE INNER JOIN KBTemplate ON TEMP_TABLE.kbTemplateId = KBTemplate.kbTemplateId";
    private static final String _FILTER_SQL_COUNT_KBTEMPLATE_WHERE = "SELECT COUNT(DISTINCT kbTemplate.kbTemplateId) AS COUNT_VALUE FROM KBTemplate kbTemplate WHERE ";
    private static final String _FILTER_ENTITY_ALIAS = "kbTemplate";
    private static final String _FILTER_ENTITY_TABLE = "KBTemplate";
    private static final String _ORDER_BY_ENTITY_ALIAS = "kbTemplate.";
    private static final String _ORDER_BY_ENTITY_TABLE = "KBTemplate.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No KBTemplate exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No KBTemplate exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(KBTemplatePersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid"});
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<KBTemplate> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<KBTemplate> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<KBTemplate> findByUuid(String uuid, int start, int end, OrderByComparator<KBTemplate> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<KBTemplate> findByUuid(String uuid, int start, int end, OrderByComparator<KBTemplate> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid;
                finderArgs = new Object[]{uuid};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (KBTemplate kbTemplate : list) {
                if (uuid.equals(kbTemplate.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_KBTEMPLATE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY kbTemplate.modifiedDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public KBTemplate findByUuid_First(String uuid, OrderByComparator<KBTemplate> orderByComparator) throws NoSuchTemplateException {
        KBTemplate kbTemplate = this.fetchByUuid_First(uuid, orderByComparator);
        if (kbTemplate != null) {
            return kbTemplate;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchTemplateException(sb.toString());
    }

    public KBTemplate fetchByUuid_First(String uuid, OrderByComparator<KBTemplate> orderByComparator) {
        List<KBTemplate> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public KBTemplate findByUuid_Last(String uuid, OrderByComparator<KBTemplate> orderByComparator) throws NoSuchTemplateException {
        KBTemplate kbTemplate = this.fetchByUuid_Last(uuid, orderByComparator);
        if (kbTemplate != null) {
            return kbTemplate;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchTemplateException(sb.toString());
    }

    public KBTemplate fetchByUuid_Last(String uuid, OrderByComparator<KBTemplate> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<KBTemplate> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public KBTemplate[] findByUuid_PrevAndNext(long kbTemplateId, String uuid, OrderByComparator<KBTemplate> orderByComparator) throws NoSuchTemplateException {
        uuid = Objects.toString(uuid, "");
        KBTemplate kbTemplate = this.findByPrimaryKey(kbTemplateId);
        Session session = null;
        try {
            session = this.openSession();
            KBTemplate[] array = new KBTemplateImpl[]{this.getByUuid_PrevAndNext(session, kbTemplate, uuid, orderByComparator, true), kbTemplate, this.getByUuid_PrevAndNext(session, kbTemplate, uuid, orderByComparator, false)};
            KBTemplate[] kBTemplateArray = array;
            return kBTemplateArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected KBTemplate getByUuid_PrevAndNext(Session session, KBTemplate kbTemplate, String uuid, OrderByComparator<KBTemplate> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_KBTEMPLATE_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY kbTemplate.modifiedDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)kbTemplate)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (KBTemplate)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (KBTemplate kbTemplate : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)kbTemplate);
        }
    }

    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_KBTEMPLATE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public KBTemplate findByUUID_G(String uuid, long groupId) throws NoSuchTemplateException {
        KBTemplate kbTemplate = this.fetchByUUID_G(uuid, groupId);
        if (kbTemplate == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("uuid=");
            sb.append(uuid);
            sb.append(", groupId=");
            sb.append(groupId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchTemplateException(sb.toString());
        }
        return kbTemplate;
    }

    public KBTemplate fetchByUUID_G(String uuid, long groupId) {
        return this.fetchByUUID_G(uuid, groupId, true);
    }

    public KBTemplate fetchByUUID_G(String uuid, long groupId, boolean useFinderCache) {
        KBTemplate kbTemplate;
        uuid = Objects.toString(uuid, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{uuid, groupId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByUUID_G, finderArgs);
        }
        if (result instanceof KBTemplate && (!Objects.equals(uuid, (kbTemplate = (KBTemplate)result).getUuid()) || groupId != kbTemplate.getGroupId())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_KBTEMPLATE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(kbTemplate.uuid IS NULL OR kbTemplate.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("kbTemplate.uuid = ? AND ");
            }
            sb.append("kbTemplate.groupId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(groupId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByUUID_G, finderArgs, (Object)list);
                    }
                } else {
                    KBTemplate kbTemplate2 = (KBTemplate)list.get(0);
                    result = kbTemplate2;
                    this.cacheResult(kbTemplate2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (KBTemplate)result;
    }

    public KBTemplate removeByUUID_G(String uuid, long groupId) throws NoSuchTemplateException {
        KBTemplate kbTemplate = this.findByUUID_G(uuid, groupId);
        return (KBTemplate)this.remove((BaseModel)kbTemplate);
    }

    public int countByUUID_G(String uuid, long groupId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUUID_G;
        Object[] finderArgs = new Object[]{uuid, groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_KBTEMPLATE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(kbTemplate.uuid IS NULL OR kbTemplate.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("kbTemplate.uuid = ? AND ");
            }
            sb.append("kbTemplate.groupId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(groupId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<KBTemplate> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<KBTemplate> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<KBTemplate> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<KBTemplate> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<KBTemplate> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<KBTemplate> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid_C;
                finderArgs = new Object[]{uuid, companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (KBTemplate kbTemplate : list) {
                if (uuid.equals(kbTemplate.getUuid()) && companyId == kbTemplate.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_KBTEMPLATE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(kbTemplate.uuid IS NULL OR kbTemplate.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("kbTemplate.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY kbTemplate.modifiedDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public KBTemplate findByUuid_C_First(String uuid, long companyId, OrderByComparator<KBTemplate> orderByComparator) throws NoSuchTemplateException {
        KBTemplate kbTemplate = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (kbTemplate != null) {
            return kbTemplate;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchTemplateException(sb.toString());
    }

    public KBTemplate fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<KBTemplate> orderByComparator) {
        List<KBTemplate> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public KBTemplate findByUuid_C_Last(String uuid, long companyId, OrderByComparator<KBTemplate> orderByComparator) throws NoSuchTemplateException {
        KBTemplate kbTemplate = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (kbTemplate != null) {
            return kbTemplate;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchTemplateException(sb.toString());
    }

    public KBTemplate fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<KBTemplate> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<KBTemplate> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public KBTemplate[] findByUuid_C_PrevAndNext(long kbTemplateId, String uuid, long companyId, OrderByComparator<KBTemplate> orderByComparator) throws NoSuchTemplateException {
        uuid = Objects.toString(uuid, "");
        KBTemplate kbTemplate = this.findByPrimaryKey(kbTemplateId);
        Session session = null;
        try {
            session = this.openSession();
            KBTemplate[] array = new KBTemplateImpl[]{this.getByUuid_C_PrevAndNext(session, kbTemplate, uuid, companyId, orderByComparator, true), kbTemplate, this.getByUuid_C_PrevAndNext(session, kbTemplate, uuid, companyId, orderByComparator, false)};
            KBTemplate[] kBTemplateArray = array;
            return kBTemplateArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected KBTemplate getByUuid_C_PrevAndNext(Session session, KBTemplate kbTemplate, String uuid, long companyId, OrderByComparator<KBTemplate> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_KBTEMPLATE_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append("(kbTemplate.uuid IS NULL OR kbTemplate.uuid = '') AND ");
        } else {
            bindUuid = true;
            sb.append("kbTemplate.uuid = ? AND ");
        }
        sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY kbTemplate.modifiedDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)kbTemplate)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (KBTemplate)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (KBTemplate kbTemplate : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)kbTemplate);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_KBTEMPLATE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(kbTemplate.uuid IS NULL OR kbTemplate.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("kbTemplate.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<KBTemplate> findByGroupId(long groupId) {
        return this.findByGroupId(groupId, -1, -1, null);
    }

    public List<KBTemplate> findByGroupId(long groupId, int start, int end) {
        return this.findByGroupId(groupId, start, end, null);
    }

    public List<KBTemplate> findByGroupId(long groupId, int start, int end, OrderByComparator<KBTemplate> orderByComparator) {
        return this.findByGroupId(groupId, start, end, orderByComparator, true);
    }

    public List<KBTemplate> findByGroupId(long groupId, int start, int end, OrderByComparator<KBTemplate> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByGroupId;
                finderArgs = new Object[]{groupId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByGroupId;
            finderArgs = new Object[]{groupId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (KBTemplate kbTemplate : list) {
                if (groupId == kbTemplate.getGroupId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_KBTEMPLATE_WHERE);
            sb.append("kbTemplate.groupId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY kbTemplate.modifiedDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public KBTemplate findByGroupId_First(long groupId, OrderByComparator<KBTemplate> orderByComparator) throws NoSuchTemplateException {
        KBTemplate kbTemplate = this.fetchByGroupId_First(groupId, orderByComparator);
        if (kbTemplate != null) {
            return kbTemplate;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append("}");
        throw new NoSuchTemplateException(sb.toString());
    }

    public KBTemplate fetchByGroupId_First(long groupId, OrderByComparator<KBTemplate> orderByComparator) {
        List<KBTemplate> list = this.findByGroupId(groupId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public KBTemplate findByGroupId_Last(long groupId, OrderByComparator<KBTemplate> orderByComparator) throws NoSuchTemplateException {
        KBTemplate kbTemplate = this.fetchByGroupId_Last(groupId, orderByComparator);
        if (kbTemplate != null) {
            return kbTemplate;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append("}");
        throw new NoSuchTemplateException(sb.toString());
    }

    public KBTemplate fetchByGroupId_Last(long groupId, OrderByComparator<KBTemplate> orderByComparator) {
        int count = this.countByGroupId(groupId);
        if (count == 0) {
            return null;
        }
        List<KBTemplate> list = this.findByGroupId(groupId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public KBTemplate[] findByGroupId_PrevAndNext(long kbTemplateId, long groupId, OrderByComparator<KBTemplate> orderByComparator) throws NoSuchTemplateException {
        KBTemplate kbTemplate = this.findByPrimaryKey(kbTemplateId);
        Session session = null;
        try {
            session = this.openSession();
            KBTemplate[] array = new KBTemplateImpl[]{this.getByGroupId_PrevAndNext(session, kbTemplate, groupId, orderByComparator, true), kbTemplate, this.getByGroupId_PrevAndNext(session, kbTemplate, groupId, orderByComparator, false)};
            KBTemplate[] kBTemplateArray = array;
            return kBTemplateArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected KBTemplate getByGroupId_PrevAndNext(Session session, KBTemplate kbTemplate, long groupId, OrderByComparator<KBTemplate> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_KBTEMPLATE_WHERE);
        sb.append("kbTemplate.groupId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY kbTemplate.modifiedDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(groupId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)kbTemplate)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (KBTemplate)list.get(1);
        }
        return null;
    }

    public List<KBTemplate> filterFindByGroupId(long groupId) {
        return this.filterFindByGroupId(groupId, -1, -1, null);
    }

    public List<KBTemplate> filterFindByGroupId(long groupId, int start, int end) {
        return this.filterFindByGroupId(groupId, start, end, null);
    }

    public List<KBTemplate> filterFindByGroupId(long groupId, int start, int end, OrderByComparator<KBTemplate> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByGroupId(groupId, start, end, orderByComparator);
        }
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_KBTEMPLATE_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_KBTEMPLATE_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append("kbTemplate.groupId = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_KBTEMPLATE_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY kbTemplate.modifiedDate DESC");
        } else {
            sb.append(" ORDER BY KBTemplate.modifiedDate DESC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)KBTemplate.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, KBTemplateImpl.class);
            } else {
                sqlQuery.addEntity(_FILTER_ENTITY_TABLE, KBTemplateImpl.class);
            }
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public KBTemplate[] filterFindByGroupId_PrevAndNext(long kbTemplateId, long groupId, OrderByComparator<KBTemplate> orderByComparator) throws NoSuchTemplateException {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByGroupId_PrevAndNext(kbTemplateId, groupId, orderByComparator);
        }
        KBTemplate kbTemplate = this.findByPrimaryKey(kbTemplateId);
        Session session = null;
        try {
            session = this.openSession();
            KBTemplate[] array = new KBTemplateImpl[]{this.filterGetByGroupId_PrevAndNext(session, kbTemplate, groupId, orderByComparator, true), kbTemplate, this.filterGetByGroupId_PrevAndNext(session, kbTemplate, groupId, orderByComparator, false)};
            KBTemplate[] kBTemplateArray = array;
            return kBTemplateArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected KBTemplate filterGetByGroupId_PrevAndNext(Session session, KBTemplate kbTemplate, long groupId, OrderByComparator<KBTemplate> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_KBTEMPLATE_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_KBTEMPLATE_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append("kbTemplate.groupId = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_KBTEMPLATE_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY kbTemplate.modifiedDate DESC");
        } else {
            sb.append(" ORDER BY KBTemplate.modifiedDate DESC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)KBTemplate.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.setFirstResult(0);
        sqlQuery.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, KBTemplateImpl.class);
        } else {
            sqlQuery.addEntity(_FILTER_ENTITY_TABLE, KBTemplateImpl.class);
        }
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        queryPos.add(groupId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)kbTemplate)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = sqlQuery.list()).size() == 2) {
            return (KBTemplate)list.get(1);
        }
        return null;
    }

    public void removeByGroupId(long groupId) {
        for (KBTemplate kbTemplate : this.findByGroupId(groupId, -1, -1, null)) {
            this.remove((BaseModel)kbTemplate);
        }
    }

    public int countByGroupId(long groupId) {
        FinderPath finderPath = this._finderPathCountByGroupId;
        Object[] finderArgs = new Object[]{groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_KBTEMPLATE_WHERE);
            sb.append("kbTemplate.groupId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByGroupId(long groupId) {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.countByGroupId(groupId);
        }
        StringBundler sb = new StringBundler(2);
        sb.append(_FILTER_SQL_COUNT_KBTEMPLATE_WHERE);
        sb.append("kbTemplate.groupId = ?");
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)KBTemplate.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            Long count = (Long)sqlQuery.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public KBTemplatePersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(KBTemplate.class);
        this.setModelImplClass(KBTemplateImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)KBTemplateTable.INSTANCE);
    }

    public void cacheResult(KBTemplate kbTemplate) {
        this.entityCache.putResult(KBTemplateImpl.class, (Serializable)Long.valueOf(kbTemplate.getPrimaryKey()), (Serializable)kbTemplate);
        this.finderCache.putResult(this._finderPathFetchByUUID_G, new Object[]{kbTemplate.getUuid(), kbTemplate.getGroupId()}, (Object)kbTemplate);
    }

    public void cacheResult(List<KBTemplate> kbTemplates) {
        for (KBTemplate kbTemplate : kbTemplates) {
            if (this.entityCache.getResult(KBTemplateImpl.class, (Serializable)Long.valueOf(kbTemplate.getPrimaryKey())) != null) continue;
            this.cacheResult(kbTemplate);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(KBTemplateImpl.class);
        this.finderCache.clearCache(KBTemplateImpl.class);
    }

    public void clearCache(KBTemplate kbTemplate) {
        this.entityCache.removeResult(KBTemplateImpl.class, (BaseModel)kbTemplate);
    }

    public void clearCache(List<KBTemplate> kbTemplates) {
        for (KBTemplate kbTemplate : kbTemplates) {
            this.entityCache.removeResult(KBTemplateImpl.class, (BaseModel)kbTemplate);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(KBTemplateImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(KBTemplateImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(KBTemplateModelImpl kbTemplateModelImpl) {
        Object[] args = new Object[]{kbTemplateModelImpl.getUuid(), kbTemplateModelImpl.getGroupId()};
        this.finderCache.putResult(this._finderPathCountByUUID_G, args, (Object)1L);
        this.finderCache.putResult(this._finderPathFetchByUUID_G, args, (Object)kbTemplateModelImpl);
    }

    public KBTemplate create(long kbTemplateId) {
        KBTemplateImpl kbTemplate = new KBTemplateImpl();
        kbTemplate.setNew(true);
        kbTemplate.setPrimaryKey(kbTemplateId);
        String uuid = PortalUUIDUtil.generate();
        kbTemplate.setUuid(uuid);
        kbTemplate.setCompanyId(CompanyThreadLocal.getCompanyId());
        return kbTemplate;
    }

    public KBTemplate remove(long kbTemplateId) throws NoSuchTemplateException {
        return this.remove(Long.valueOf(kbTemplateId));
    }

    public KBTemplate remove(Serializable primaryKey) throws NoSuchTemplateException {
        Session session = null;
        try {
            session = this.openSession();
            KBTemplate kbTemplate = (KBTemplate)session.get(KBTemplateImpl.class, primaryKey);
            if (kbTemplate == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchTemplateException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            KBTemplate kBTemplate = (KBTemplate)this.remove((BaseModel)kbTemplate);
            return kBTemplate;
        }
        catch (NoSuchTemplateException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected KBTemplate removeImpl(KBTemplate kbTemplate) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)kbTemplate)) {
                kbTemplate = (KBTemplate)session.get(KBTemplateImpl.class, kbTemplate.getPrimaryKeyObj());
            }
            if (kbTemplate != null) {
                session.delete((Object)kbTemplate);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (kbTemplate != null) {
            this.clearCache(kbTemplate);
        }
        return kbTemplate;
    }

    public KBTemplate updateImpl(KBTemplate kbTemplate) {
        long userId;
        boolean isNew = kbTemplate.isNew();
        if (!(kbTemplate instanceof KBTemplateModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(kbTemplate.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)kbTemplate);
                throw new IllegalArgumentException("Implement ModelWrapper in kbTemplate proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom KBTemplate implementation " + kbTemplate.getClass());
        }
        KBTemplateModelImpl kbTemplateModelImpl = (KBTemplateModelImpl)kbTemplate;
        if (Validator.isNull((String)kbTemplate.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            kbTemplate.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && kbTemplate.getCreateDate() == null) {
            if (serviceContext == null) {
                kbTemplate.setCreateDate(now);
            } else {
                kbTemplate.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!kbTemplateModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                kbTemplate.setModifiedDate(now);
            } else {
                kbTemplate.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        if ((userId = GetterUtil.getLong((String)PrincipalThreadLocal.getName())) > 0L) {
            long companyId = kbTemplate.getCompanyId();
            long groupId = kbTemplate.getGroupId();
            long kbTemplateId = 0L;
            if (!isNew) {
                kbTemplateId = kbTemplate.getPrimaryKey();
            }
            try {
                kbTemplate.setContent(SanitizerUtil.sanitize((long)companyId, (long)groupId, (long)userId, (String)KBTemplate.class.getName(), (long)kbTemplateId, (String)"text/html", (String)"ALL", (String)kbTemplate.getContent(), null));
            }
            catch (SanitizerException sanitizerException) {
                throw new SystemException((Throwable)sanitizerException);
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)kbTemplate);
            } else {
                kbTemplate = (KBTemplate)session.merge((Object)kbTemplate);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(KBTemplateImpl.class, (BaseModel)kbTemplateModelImpl, false, true);
        this.cacheUniqueFindersCache(kbTemplateModelImpl);
        if (isNew) {
            kbTemplate.setNew(false);
        }
        kbTemplate.resetOriginalValues();
        return kbTemplate;
    }

    public KBTemplate findByPrimaryKey(Serializable primaryKey) throws NoSuchTemplateException {
        KBTemplate kbTemplate = (KBTemplate)this.fetchByPrimaryKey(primaryKey);
        if (kbTemplate == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchTemplateException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return kbTemplate;
    }

    public KBTemplate findByPrimaryKey(long kbTemplateId) throws NoSuchTemplateException {
        return this.findByPrimaryKey(Long.valueOf(kbTemplateId));
    }

    public KBTemplate fetchByPrimaryKey(long kbTemplateId) {
        return (KBTemplate)this.fetchByPrimaryKey(Long.valueOf(kbTemplateId));
    }

    public List<KBTemplate> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<KBTemplate> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<KBTemplate> findAll(int start, int end, OrderByComparator<KBTemplate> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<KBTemplate> findAll(int start, int end, OrderByComparator<KBTemplate> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_KBTEMPLATE);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_KBTEMPLATE;
                sql = sql.concat(" ORDER BY kbTemplate.modifiedDate DESC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (KBTemplate kbTemplate : this.findAll()) {
            this.remove((BaseModel)kbTemplate);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_KBTEMPLATE);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "kbTemplateId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_KBTEMPLATE;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return KBTemplateModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new KBTemplateModelArgumentsResolver(), (Dictionary)new HashMapDictionary());
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathCountByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, false);
        this._finderPathFetchByUUID_G = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "groupId"}, true);
        this._finderPathCountByUUID_G = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "groupId"}, false);
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathCountByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, false);
        this._finderPathWithPaginationFindByGroupId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByGroupId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"groupId"}, true);
        this._finderPathWithoutPaginationFindByGroupId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByGroupId", new String[]{Long.class.getName()}, new String[]{"groupId"}, true);
        this._finderPathCountByGroupId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGroupId", new String[]{Long.class.getName()}, new String[]{"groupId"}, false);
    }

    @Deactivate
    public void deactivate() {
        this.entityCache.removeCache(KBTemplateImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.knowledge.base.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.knowledge.base.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.knowledge.base.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }

    private static class KBTemplateModelArgumentsResolver
    implements ArgumentsResolver {
        private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();
        private static final long _ORDER_BY_COLUMNS_BITMASK;

        private KBTemplateModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return FINDER_ARGS_EMPTY;
                }
                return null;
            }
            KBTemplateModelImpl kbTemplateModelImpl = (KBTemplateModelImpl)baseModel;
            long columnBitmask = kbTemplateModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return KBTemplateModelArgumentsResolver._getValue(kbTemplateModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | KBTemplateModelImpl.getColumnBitmask(columnName);
                }
                if (finderPath.isBaseModelResult() && FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION == finderPath.getCacheName()) {
                    finderPathColumnBitmask = finderPathColumnBitmask | _ORDER_BY_COLUMNS_BITMASK;
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return KBTemplateModelArgumentsResolver._getValue(kbTemplateModelImpl, columnNames, original);
            }
            return null;
        }

        public String getClassName() {
            return KBTemplateImpl.class.getName();
        }

        public String getTableName() {
            return KBTemplateTable.INSTANCE.getTableName();
        }

        private static Object[] _getValue(KBTemplateModelImpl kbTemplateModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? kbTemplateModelImpl.getColumnOriginalValue(columnName) : kbTemplateModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }

        static {
            long orderByColumnsBitmask = 0L;
            _ORDER_BY_COLUMNS_BITMASK = orderByColumnsBitmask |= KBTemplateModelImpl.getColumnBitmask("modifiedDate");
        }
    }
}

