/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.upgrade.v1_1_0;

import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.upgrade.CamelCaseUpgradePortletPreferences;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class UpgradePortletPreferences
extends CamelCaseUpgradePortletPreferences {
    private static final String[] _PORTLET_IDS = new String[]{"1_WAR_knowledgebaseportlet", "2_WAR_knowledgebaseportlet", "3_WAR_knowledgebaseportlet_INSTANCE_%"};
    private static final Map<String, String> _adminDefaultPreferencesMap = new HashMap<String, String>(){
        {
            this.put("enableKBArticleAssetCategories", "false");
            this.put("enableKBArticleAssetTags", "true");
            this.put("enableKBArticleDescription", "false");
            this.put("enableKBArticleKBComments", "true");
            this.put("enableKBArticleRatings", "false");
            this.put("enableKBArticleViewCountIncrement", "true");
            this.put("enableKBStructureKBComments", "true");
            this.put("enableKBTemplateKBComments", "true");
            this.put("kbArticlesOrderByCol", "priority");
            this.put("kbArticlesOrderByType", "desc");
            this.put("showKBArticleAssetEntries", "true");
            this.put("showKBArticleKBComments", "true");
            this.put("showKBStructureKBComments", "true");
            this.put("showKBTemplateKBComments", "true");
        }
    };
    private static final Map<String, String> _articleDefaultPreferencesMap = new HashMap<String, String>(){
        {
            this.put("enableKBArticleAssetCategories", "false");
            this.put("enableKBArticleAssetTags", "true");
            this.put("enableKBArticleDescription", "false");
            this.put("enableKBArticleKBComments", "true");
            this.put("enableKBArticleRatings", "false");
            this.put("enableKBArticleViewCountIncrement", "true");
            this.put("resourcePrimKey", "0");
            this.put("rssDelta", "20");
            this.put("rssDisplayStyle", "full-content");
            this.put("rssFormat", "atom10");
            this.put("showKBArticleAssetEntries", "true");
            this.put("showKBArticleKBComments", "true");
        }
    };
    private static final Map<String, String> _displayDefaultPreferencesMap = new HashMap<String, String>(){
        {
            this.put("enableKBArticleAssetCategories", "false");
            this.put("enableKBArticleAssetTags", "true");
            this.put("enableKBArticleDescription", "false");
            this.put("enableKBArticleKBComments", "true");
            this.put("enableKBArticleRatings", "false");
            this.put("enableKBArticleViewCountIncrement", "true");
            this.put("enableKBTemplateKBComments", "true");
            this.put("kbArticlesOrderByCol", "priority");
            this.put("kbArticlesOrderByType", "desc");
            this.put("rssDelta", "20");
            this.put("rssDisplayStyle", "full-content");
            this.put("rssFormat", "atom10");
            this.put("showKBArticleAssetEntries", "true");
            this.put("showKBArticleAuthorColumn", "true");
            this.put("showKBArticleCreateDateColumn", "true");
            this.put("showKBArticleKBComments", "true");
            this.put("showKBArticleModifiedDateColumn", "true");
            this.put("showKBArticlePriorityColumn", "true");
            this.put("showKBArticleStatusColumn", "true");
            this.put("showKBArticleViewsColumn", "true");
            this.put("showKBTemplateKBComments", "true");
        }
    };
    private static final Map<String, String> _oldAdminPreferenceNamesMap = new HashMap<String, String>(){
        {
            this.put("articlesOrderByCol", "kbArticlesOrderByCol");
            this.put("articlesOrderByType", "kbArticlesOrderByType");
            this.put("enableArticleAssetCategories", "enableKBArticleAssetCategories");
            this.put("enableArticleAssetTags", "enableKBArticleAssetTags");
            this.put("enableArticleComments", "enableKBArticleKBComments");
            this.put("enableArticleDescription", "enableKBArticleDescription");
            this.put("enableArticleRatings", "enableKBArticleRatings");
            this.put("enableArticleViewCountIncrement", "enableKBArticleViewCountIncrement");
            this.put("enableTemplateComments", "enableKBTemplateKBComments");
            this.put("showArticleComments", "showKBArticleKBComments");
            this.put("showTemplateComments", "showKBTemplateKBComments");
        }
    };
    private static final Map<String, String> _oldArticlePreferenceNamesMap = new HashMap<String, String>(){
        {
            this.put("enableArticleAssetCategories", "enableKBArticleAssetCategories");
            this.put("enableArticleAssetTags", "enableKBArticleAssetTags");
            this.put("enableArticleComments", "enableKBArticleKBComments");
            this.put("enableArticleDescription", "enableKBArticleDescription");
            this.put("enableArticleRatings", "enableKBArticleRatings");
            this.put("enableArticleViewCountIncrement", "enableKBArticleViewCountIncrement");
            this.put("showArticleComments", "showKBArticleKBComments");
        }
    };
    private static final Map<String, String> _oldDisplayPreferenceNamesMap = new HashMap<String, String>(){
        {
            this.put("articlesOrderByCol", "kbArticlesOrderByCol");
            this.put("articlesOrderByType", "kbArticlesOrderByType");
            this.put("enableArticleAssetCategories", "enableKBArticleAssetCategories");
            this.put("enableArticleAssetTags", "enableKBArticleAssetTags");
            this.put("enableArticleComments", "enableKBArticleKBComments");
            this.put("enableArticleDescription", "enableKBArticleDescription");
            this.put("enableArticleRatings", "enableKBArticleRatings");
            this.put("enableArticleViewCountIncrement", "enableKBArticleViewCountIncrement");
            this.put("enableTemplateComments", "enableKBTemplateKBComments");
            this.put("showArticleComments", "showKBArticleKBComments");
            this.put("showTemplateComments", "showKBTemplateKBComments");
        }
    };

    protected Map<String, String> getDefaultPreferencesMap(String rootPortletId) {
        if (rootPortletId.equals("1_WAR_knowledgebaseportlet")) {
            return _adminDefaultPreferencesMap;
        }
        if (rootPortletId.equals("2_WAR_knowledgebaseportlet")) {
            return _displayDefaultPreferencesMap;
        }
        if (rootPortletId.equals("3_WAR_knowledgebaseportlet")) {
            return _articleDefaultPreferencesMap;
        }
        return Collections.emptyMap();
    }

    protected String getName(String rootPortletId, String oldName) {
        if (rootPortletId.equals("1_WAR_knowledgebaseportlet")) {
            return _oldAdminPreferenceNamesMap.get(oldName);
        }
        if (rootPortletId.equals("2_WAR_knowledgebaseportlet")) {
            return _oldDisplayPreferenceNamesMap.get(oldName);
        }
        if (rootPortletId.equals("3_WAR_knowledgebaseportlet")) {
            return _oldArticlePreferenceNamesMap.get(oldName);
        }
        return null;
    }

    protected String[] getPortletIds() {
        return _PORTLET_IDS;
    }

    protected String updatePreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        PortletPreferences preferences = PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        Map preferencesMap = preferences.getMap();
        String rootPortletId = PortletIdCodec.decodePortletName((String)portletId);
        for (Map.Entry entry : preferencesMap.entrySet()) {
            String oldName = (String)entry.getKey();
            String newName = this.getName(rootPortletId, oldName);
            preferences.reset(oldName);
            if (newName == null) continue;
            preferences.setValues(newName, (String[])entry.getValue());
        }
        Map<String, String> defaultPreferencesMap = this.getDefaultPreferencesMap(rootPortletId);
        for (Map.Entry<String, String> entry : defaultPreferencesMap.entrySet()) {
            String name = entry.getKey();
            if (preferences.getValues(name, null) != null) continue;
            preferences.setValues(name, StringUtil.split((String)entry.getValue()));
        }
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)preferences);
    }

    protected String upgradePreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        String preferences = super.upgradePreferences(companyId, ownerId, ownerType, plid, portletId, xml);
        return this.updatePreferences(companyId, ownerId, ownerType, plid, portletId, preferences);
    }
}

