/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.model.impl;

import com.liferay.knowledge.base.constants.KBFolderConstants;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.model.impl.KBFolderBaseImpl;
import com.liferay.knowledge.base.service.KBArticleServiceUtil;
import com.liferay.knowledge.base.service.KBFolderLocalServiceUtil;
import com.liferay.knowledge.base.service.KBFolderServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class KBFolderImpl
extends KBFolderBaseImpl {
    private long _classNameId;

    public List<Long> getAncestorKBFolderIds() throws PortalException {
        ArrayList<Long> ancestorFolderIds = new ArrayList<Long>();
        ancestorFolderIds.add(this.getKbFolderId());
        KBFolderImpl kbFolder = this;
        while (!kbFolder.isRoot() && (kbFolder = kbFolder.getParentKBFolder()) != null) {
            ancestorFolderIds.add(kbFolder.getKbFolderId());
        }
        return ancestorFolderIds;
    }

    public long getClassNameId() {
        if (this._classNameId == 0L) {
            this._classNameId = PortalUtil.getClassNameId((String)KBFolderConstants.getClassName());
        }
        return this._classNameId;
    }

    public KBFolder getParentKBFolder() throws PortalException {
        long parentKBFolderId = this.getParentKBFolderId();
        if (parentKBFolderId <= 0L) {
            return null;
        }
        return KBFolderLocalServiceUtil.getKBFolder((long)parentKBFolderId);
    }

    public String getParentTitle(Locale locale) throws PortalException {
        KBFolder parentKBFolder = this.getParentKBFolder();
        if (parentKBFolder == null) {
            return LanguageUtil.get((Locale)locale, (String)"home");
        }
        return parentKBFolder.getName();
    }

    public boolean isEmpty() throws PortalException {
        int kbArticlesCount = KBArticleServiceUtil.getKBArticlesCount((long)this.getGroupId(), (long)this.getKbFolderId(), (int)-1);
        if (kbArticlesCount > 0) {
            return false;
        }
        int kbFoldersCount = KBFolderServiceUtil.getKBFoldersCount((long)this.getGroupId(), (long)this.getKbFolderId());
        return kbFoldersCount <= 0;
    }

    public boolean isRoot() {
        return this.getParentKBFolderId() == 0L;
    }
}

