/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.exportimport.data.handler;

import com.liferay.exportimport.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.knowledge.base.model.KBComment;
import com.liferay.knowledge.base.service.KBCommentLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class KBCommentStagedModelDataHandler
extends BaseStagedModelDataHandler<KBComment> {
    public static final String[] CLASS_NAMES = new String[]{KBComment.class.getName()};
    private KBCommentLocalService _kbCommentLocalService;

    public void deleteStagedModel(KBComment kbComment) throws PortalException {
        this._kbCommentLocalService.deleteKBComment(kbComment);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        KBComment kbComment = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (kbComment != null) {
            this.deleteStagedModel(kbComment);
        }
    }

    public KBComment fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._kbCommentLocalService.fetchKBCommentByUuidAndGroupId(uuid, groupId);
    }

    public List<KBComment> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._kbCommentLocalService.getKBCommentsByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(KBComment kbComment) {
        return kbComment.getUuid();
    }

    @Reference(unbind="-")
    public void setKBCommentLocalService(KBCommentLocalService kbCommentLocalService) {
        this._kbCommentLocalService = kbCommentLocalService;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, KBComment kbComment) throws Exception {
        Element kbCommentElement = portletDataContext.getExportDataElement((ClassedModel)kbComment);
        portletDataContext.addClassedModel(kbCommentElement, ExportImportPathUtil.getModelPath((StagedModel)kbComment), (ClassedModel)kbComment);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, KBComment kbComment) throws Exception {
        long userId = portletDataContext.getUserId(kbComment.getUserUuid());
        Map relatedClassPKs = portletDataContext.getNewPrimaryKeysMap(kbComment.getClassName());
        long newClassPK = MapUtil.getLong((Map)relatedClassPKs, (long)kbComment.getClassPK(), (long)kbComment.getClassPK());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)kbComment);
        KBComment importedKBComment = null;
        if (portletDataContext.isDataStrategyMirror()) {
            KBComment existingKBComment = this.fetchStagedModelByUuidAndGroupId(kbComment.getUuid(), portletDataContext.getScopeGroupId());
            if (existingKBComment == null) {
                serviceContext.setUuid(kbComment.getUuid());
                importedKBComment = this._kbCommentLocalService.addKBComment(userId, kbComment.getClassNameId(), newClassPK, kbComment.getContent(), kbComment.getUserRating(), serviceContext);
            } else {
                importedKBComment = this._kbCommentLocalService.updateKBComment(existingKBComment.getKbCommentId(), kbComment.getClassNameId(), newClassPK, kbComment.getContent(), kbComment.getUserRating(), kbComment.getStatus(), serviceContext);
            }
        } else {
            importedKBComment = this._kbCommentLocalService.addKBComment(userId, kbComment.getClassNameId(), newClassPK, kbComment.getContent(), kbComment.getUserRating(), serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)kbComment, (ClassedModel)importedKBComment);
    }
}

