/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.security.permission.resource;

import com.liferay.knowledge.base.constants.KBFolderConstants;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBArticleModel;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={})
public class KBArticleModelResourcePermissionRegistrar {
    @Reference
    private KBArticleLocalService _kbArticleLocalService;
    @Reference(target="(model.class.name=com.liferay.knowledge.base.model.KBFolder)")
    private ModelResourcePermission<KBFolder> _kbFolderModelResourcePermission;
    @Reference(target="(resource.name=com.liferay.knowledge.base.admin)")
    private PortletResourcePermission _portletResourcePermission;
    private ServiceRegistration<ModelResourcePermission> _serviceRegistration;

    @Activate
    public void activate(BundleContext bundleContext) {
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("model.class.name", KBArticle.class.getName());
        this._serviceRegistration = bundleContext.registerService(ModelResourcePermission.class, (Object)ModelResourcePermissionFactory.create(KBArticle.class, KBArticleModel::getRootResourcePrimKey, classPK -> {
            KBArticle kbArticle = this._kbArticleLocalService.fetchLatestKBArticle(classPK.longValue(), -1);
            if (kbArticle == null) {
                kbArticle = this._kbArticleLocalService.getKBArticle(classPK.longValue());
            }
            return kbArticle;
        }, (PortletResourcePermission)this._portletResourcePermission, (modelResourcePermission, consumer) -> {
            if (PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
                consumer.accept(new KBArticleDynamicInheritancePermissionLogic(modelResourcePermission));
            }
        }), (Dictionary)properties);
    }

    @Deactivate
    public void deactivate() {
        this._serviceRegistration.unregister();
    }

    private class KBArticleDynamicInheritancePermissionLogic
    implements ModelResourcePermissionLogic<KBArticle> {
        private final ModelResourcePermission<KBArticle> _kbArticleModelResourcePermission;

        public Boolean contains(PermissionChecker permissionChecker, String name, KBArticle kbArticle, String actionId) throws PortalException {
            KBArticle parentKBArticle;
            if (!"VIEW".equals(actionId)) {
                return null;
            }
            long parentResourceClassNameId = kbArticle.getParentResourceClassNameId();
            long parentResourcePrimKey = kbArticle.getParentResourcePrimKey();
            long kbFolderClassNameId = PortalUtil.getClassNameId((String)KBFolderConstants.getClassName());
            if (parentResourcePrimKey == 0L) {
                return null;
            }
            if (parentResourceClassNameId == kbFolderClassNameId ? !KBArticleModelResourcePermissionRegistrar.this._kbFolderModelResourcePermission.contains(permissionChecker, parentResourcePrimKey, actionId) : !this._kbArticleModelResourcePermission.contains(permissionChecker, (ClassedModel)(parentKBArticle = KBArticleModelResourcePermissionRegistrar.this._kbArticleLocalService.getLatestKBArticle(parentResourcePrimKey, -1)), actionId)) {
                return false;
            }
            return null;
        }

        private KBArticleDynamicInheritancePermissionLogic(ModelResourcePermission<KBArticle> modelResourcePermission) {
            this._kbArticleModelResourcePermission = modelResourcePermission;
        }
    }
}

