/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.service.util;

import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.service.KBArticleLocalServiceUtil;
import com.liferay.knowledge.base.service.KBArticleServiceUtil;
import com.liferay.knowledge.base.util.comparator.KBArticleVersionComparator;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.diff.DiffHtmlUtil;
import com.liferay.portal.kernel.diff.DiffVersion;
import com.liferay.portal.kernel.diff.DiffVersionsInfo;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Source;

public class AdminUtil {
    public static String[] escapeSections(String[] sections) {
        if (ArrayUtil.isEmpty((Object[])sections)) {
            return new String[0];
        }
        sections = (String[])ArrayUtil.clone((Object[])sections);
        for (int i = 0; i < sections.length; ++i) {
            sections[i] = "_".concat(sections[i]).concat("_");
        }
        return sections;
    }

    public static DiffVersionsInfo getDiffVersionsInfo(long groupId, long kbArticleResourcePrimKey, int sourceVersion, int targetVersion) {
        double previousVersion = 0.0;
        double nextVersion = 0.0;
        List kbArticles = KBArticleServiceUtil.getKBArticleVersions((long)groupId, (long)kbArticleResourcePrimKey, (int)0, (int)-1, (int)-1, (OrderByComparator)new KBArticleVersionComparator());
        for (KBArticle curKBArticle : kbArticles) {
            if (curKBArticle.getVersion() < sourceVersion && (double)curKBArticle.getVersion() > previousVersion) {
                previousVersion = curKBArticle.getVersion();
            }
            if (curKBArticle.getVersion() <= targetVersion || !((double)curKBArticle.getVersion() < nextVersion) && nextVersion != 0.0) continue;
            nextVersion = curKBArticle.getVersion();
        }
        ArrayList<DiffVersion> diffVersions = new ArrayList<DiffVersion>();
        for (KBArticle curKBArticle : kbArticles) {
            DiffVersion diffVersion = new DiffVersion(curKBArticle.getUserId(), (double)curKBArticle.getVersion(), curKBArticle.getModifiedDate());
            diffVersions.add(diffVersion);
        }
        return new DiffVersionsInfo(diffVersions, nextVersion, previousVersion);
    }

    public static String getKBArticleDiff(long resourcePrimKey, int sourceVersion, int targetVersion, String param) throws Exception {
        if (sourceVersion < 1) {
            sourceVersion = 1;
        }
        if (sourceVersion == targetVersion) {
            KBArticle kbArticle = KBArticleLocalServiceUtil.getKBArticle((long)resourcePrimKey, (int)targetVersion);
            return BeanPropertiesUtil.getString((Object)kbArticle, (String)param);
        }
        KBArticle sourceKBArticle = KBArticleLocalServiceUtil.getKBArticle((long)resourcePrimKey, (int)sourceVersion);
        KBArticle targetKBArticle = KBArticleLocalServiceUtil.getKBArticle((long)resourcePrimKey, (int)targetVersion);
        String sourceHtml = BeanPropertiesUtil.getString((Object)sourceKBArticle, (String)param);
        String targetHtml = BeanPropertiesUtil.getString((Object)targetKBArticle, (String)param);
        String diff = DiffHtmlUtil.diff((Reader)new UnsyncStringReader(sourceHtml), (Reader)new UnsyncStringReader(targetHtml));
        Source source = new Source(diff);
        OutputDocument outputDocument = new OutputDocument(source);
        for (Element element : source.getAllElements()) {
            Attribute classAttribute;
            StringBundler sb = new StringBundler(4);
            Attributes attributes = element.getAttributes();
            if (attributes == null) continue;
            Attribute changeTypeAttribute = attributes.get("changeType");
            if (changeTypeAttribute != null) {
                String changeTypeValue = changeTypeAttribute.getValue();
                if (changeTypeValue.contains("diff-added-image")) {
                    sb.append("border: 10px solid #CFC; ");
                } else if (changeTypeValue.contains("diff-changed-image")) {
                    sb.append("border: 10px solid #C6C6FD; ");
                } else if (changeTypeValue.contains("diff-removed-image")) {
                    sb.append("border: 10px solid #FDC6C6; ");
                }
            }
            if ((classAttribute = attributes.get("class")) != null) {
                String classValue = classAttribute.getValue();
                if (classValue.contains("diff-html-added")) {
                    sb.append("background-color: #CFC; ");
                } else if (classValue.contains("diff-html-changed")) {
                    sb.append("background-color: #C6C6FD; ");
                } else if (classValue.contains("diff-html-removed")) {
                    sb.append("background-color: #FDC6C6; ");
                    sb.append("text-decoration: line-through; ");
                }
            }
            if (Validator.isNull((String)sb.toString())) continue;
            Attribute styleAttribute = attributes.get("style");
            if (styleAttribute != null) {
                sb.append(GetterUtil.getString((String)styleAttribute.getValue()));
            }
            Map<String, String> map = outputDocument.replace(attributes, false);
            map.put("style", sb.toString());
        }
        return outputDocument.toString();
    }

    public static String[] unescapeSections(String sections) {
        String[] sectionsArray = StringUtil.split((String)sections);
        for (int i = 0; i < sectionsArray.length; ++i) {
            String section = sectionsArray[i];
            if (!StringUtil.startsWith((String)section, (String)"_") || !StringUtil.endsWith((String)section, (String)"_")) continue;
            sectionsArray[i] = section.substring(1, section.length() - 1);
        }
        return sectionsArray;
    }
}

