/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.service.permission;

import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.service.KBArticleLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;

public class KBArticlePermission {
    public static void check(PermissionChecker permissionChecker, KBArticle kbArticle, String actionId) throws PortalException {
        if (!KBArticlePermission.contains(permissionChecker, kbArticle, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long resourcePrimKey, String actionId) throws PortalException {
        if (!KBArticlePermission.contains(permissionChecker, resourcePrimKey, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, KBArticle kbArticle, String actionId) {
        if (permissionChecker.hasOwnerPermission(kbArticle.getCompanyId(), KBArticle.class.getName(), kbArticle.getRootResourcePrimKey(), kbArticle.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(kbArticle.getGroupId(), KBArticle.class.getName(), kbArticle.getRootResourcePrimKey(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long resourcePrimKey, String actionId) throws PortalException {
        KBArticle kbArticle = KBArticleLocalServiceUtil.getLatestKBArticle((long)resourcePrimKey, (int)-1);
        return KBArticlePermission.contains(permissionChecker, kbArticle, actionId);
    }
}

