/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.service.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.knowledge.base.model.KBComment;
import com.liferay.knowledge.base.service.base.KBCommentServiceBaseImpl;
import com.liferay.knowledge.base.service.permission.AdminPermission;
import com.liferay.knowledge.base.service.permission.KBCommentPermission;
import com.liferay.knowledge.base.service.permission.SuggestionPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Collections;
import java.util.List;

@ProviderType
public class KBCommentServiceImpl
extends KBCommentServiceBaseImpl {
    public KBComment deleteKBComment(KBComment kbComment) throws PortalException {
        KBCommentPermission.check(this.getPermissionChecker(), kbComment, "DELETE");
        return this.kbCommentLocalService.deleteKBComment(kbComment);
    }

    public KBComment deleteKBComment(long kbCommentId) throws PortalException {
        KBComment kbComment = this.kbCommentPersistence.findByPrimaryKey(kbCommentId);
        return this.deleteKBComment(kbComment);
    }

    public KBComment getKBComment(long kbCommentId) throws PortalException {
        KBCommentPermission.check(this.getPermissionChecker(), kbCommentId, "VIEW");
        return this.kbCommentLocalService.getKBComment(kbCommentId);
    }

    public List<KBComment> getKBComments(long groupId, int status, int start, int end) throws PortalException {
        if (AdminPermission.contains(this.getPermissionChecker(), groupId, "VIEW_SUGGESTIONS")) {
            return this.kbCommentLocalService.getKBComments(groupId, status, start, end);
        }
        return Collections.emptyList();
    }

    public List<KBComment> getKBComments(long groupId, int status, int start, int end, OrderByComparator<KBComment> obc) throws PortalException {
        if (AdminPermission.contains(this.getPermissionChecker(), groupId, "VIEW_SUGGESTIONS")) {
            return this.kbCommentLocalService.getKBComments(groupId, status, start, end, obc);
        }
        return Collections.emptyList();
    }

    public List<KBComment> getKBComments(long groupId, int start, int end, OrderByComparator<KBComment> obc) throws PortalException {
        if (AdminPermission.contains(this.getPermissionChecker(), groupId, "VIEW_SUGGESTIONS")) {
            return this.kbCommentLocalService.getKBComments(groupId, start, end, obc);
        }
        return Collections.emptyList();
    }

    public List<KBComment> getKBComments(long groupId, String className, long classPK, int status, int start, int end) throws PortalException {
        if (SuggestionPermission.contains(this.getPermissionChecker(), groupId, className, classPK, "VIEW_SUGGESTIONS")) {
            return this.kbCommentLocalService.getKBComments(className, classPK, status, start, end);
        }
        return Collections.emptyList();
    }

    public List<KBComment> getKBComments(long groupId, String className, long classPK, int status, int start, int end, OrderByComparator<KBComment> obc) throws PortalException {
        if (SuggestionPermission.contains(this.getPermissionChecker(), groupId, className, classPK, "VIEW_SUGGESTIONS")) {
            return this.kbCommentLocalService.getKBComments(className, classPK, status, start, end, obc);
        }
        return Collections.emptyList();
    }

    public List<KBComment> getKBComments(long groupId, String className, long classPK, int start, int end, OrderByComparator<KBComment> obc) throws PortalException {
        if (SuggestionPermission.contains(this.getPermissionChecker(), groupId, className, classPK, "VIEW_SUGGESTIONS")) {
            return this.kbCommentLocalService.getKBComments(className, classPK, start, end, obc);
        }
        return Collections.emptyList();
    }

    public int getKBCommentsCount(long groupId) throws PortalException {
        if (AdminPermission.contains(this.getPermissionChecker(), groupId, "VIEW_SUGGESTIONS")) {
            return this.kbCommentPersistence.countByGroupId(groupId);
        }
        return 0;
    }

    public int getKBCommentsCount(long groupId, int status) throws PortalException {
        if (AdminPermission.contains(this.getPermissionChecker(), groupId, "VIEW_SUGGESTIONS")) {
            return this.kbCommentLocalService.getKBCommentsCount(groupId, status);
        }
        return 0;
    }

    public int getKBCommentsCount(long groupId, String className, long classPK) throws PortalException {
        if (SuggestionPermission.contains(this.getPermissionChecker(), groupId, className, classPK, "VIEW_SUGGESTIONS")) {
            return this.kbCommentLocalService.getKBCommentsCount(className, classPK);
        }
        return 0;
    }

    public int getKBCommentsCount(long groupId, String className, long classPK, int status) throws PortalException {
        if (SuggestionPermission.contains(this.getPermissionChecker(), groupId, className, classPK, "VIEW_SUGGESTIONS")) {
            return this.kbCommentLocalService.getKBCommentsCount(className, classPK, status);
        }
        return 0;
    }

    public KBComment updateKBComment(long kbCommentId, long classNameId, long classPK, String content, int status, ServiceContext serviceContext) throws PortalException {
        KBCommentPermission.check(this.getPermissionChecker(), kbCommentId, "UPDATE");
        return this.kbCommentLocalService.updateKBComment(kbCommentId, classNameId, classPK, content, status, serviceContext);
    }

    public KBComment updateKBComment(long kbCommentId, long classNameId, long classPK, String content, ServiceContext serviceContext) throws PortalException {
        KBComment kbComment = this.kbCommentPersistence.findByPrimaryKey(kbCommentId);
        return this.updateKBComment(kbCommentId, classNameId, classPK, content, kbComment.getStatus(), serviceContext);
    }

    public KBComment updateStatus(long kbCommentId, int status, ServiceContext serviceContext) throws PortalException {
        KBCommentPermission.check(this.getPermissionChecker(), kbCommentId, "UPDATE");
        return this.kbCommentLocalService.updateStatus(this.getUserId(), kbCommentId, status, serviceContext);
    }
}

